<?php
/**
 *
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Consalty_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

extract( $data );

$number_of_post = $data['itemnumber'];

$grid_query = null;
$args = array(
    'post_type'      => 'finbuzz_gallery',
    'post_status'    => 'publish',
    'posts_per_page' => $number_of_post,
    'p'       => $data['single_post'],
);

$grid_query = new WP_Query($args);

?>

<?php if ( $grid_query->have_posts() ): 

?>
<div class="gallery-default gallery-multi-layout-1 gallery-<?php echo esc_attr( $data['layout'] );?>">
	<?php
	    while ( $grid_query->have_posts() ) : $grid_query->the_post();
            $id            	= get_the_id();
			$content = apply_filters( 'the_content', get_the_content() );
			$gallery_title = wp_trim_words( get_the_title(), $title_count, '' );
			$content = wp_trim_words( $content, $data['excerpt_count'], '' );
	 ?>
	<div class="rtin-item">
        <div class="rtin-figure">
           
            <?php
                if ( has_post_thumbnail() ){
                    the_post_thumbnail( 'full', ['class' => 'img-fluid mb-10 width-100'] );
                } else {
                    if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
                        echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], 'full' );
                    } else {
                        echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'.get_the_title().'">';
                    }
                }
            ?>
            
            <div class="rtin-content">
                <h3><a href="<?php the_permalink(); ?>"><?php the_title();?></a></h3>					
                <?php if ( FinbuzzTheme::$options['gallery_ar_category'] ) { ?>
                <div class="rtin-cat"><?php
                    $i = 1;
                    $term_lists = get_the_terms( get_the_ID(), 'finbuzz_gallery_category' );
                    if($term_lists){
                        foreach ( $term_lists as $term_list ){ 
                        $link = get_term_link( $term_list->term_id, 'finbuzz_gallery_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php $i++; }
                        } ?>
                </div>
                <?php } ?>
                <?php if ($data['excerpt_display']=='yes' ) { ?>
					  <p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
					<?php } ?>
                <?php if ( FinbuzzTheme::$options['gallery_ar_excerpt'] ) { ?>
                    <p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
                <?php } ?>
                <?php if (  FinbuzzTheme::$options['gallery_ar_link'] ) { ?>
                    <div class="item-button">
                        <a href="<?php the_permalink();?>" class="gallery-btn">+</a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    
	<?php endwhile; wp_reset_postdata(); ?>
</div>

<?php endif; ?>

