<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
}
//image
if ( $attr ) {
  $getimg = '<a ' . $attr . '>' .Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'rt_image' ).'</a>';
}
else {
	$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'rt_image' );
}
$mask_getimg = wp_get_attachment_image( $data['rt_image2_style7']['id'], 'full');
$percentage_getimg = wp_get_attachment_image( $data['rt_image3_style7']['id'], 'thumbnail');
$mouse_follow_effect="";
if($data['mouse_follow']=='yes'){
    $mouse_follow_effect="motion-effects-wrap";
}
?>

<div class="image-default image-<?php echo esc_attr( $data['style'] );?> <?php echo esc_attr( $mouse_follow_effect); ?>">
	<div class="image-box rt-animate wow fadeInDown" data-wow-delay=".2s">
		<div class="mask-image  rt-animate wow fadeInDown" data-wow-delay=".8s">
        <?php if($mask_getimg){ ?>
            <?php echo  wp_kses_post($mask_getimg);?>
        <?php } else{ ?>	
            <img src="<?php echo FINBUZZ_ASSETS_URL . 'element/mask-image.svg'; ?>" height="84" width="92" alt="">
        <?php } ?>
		</div>
		<div class="full-image">
			<?php echo wp_kses_post($getimg);?>
		</div>
		<ul class="images-shape d-none d-xl-block">
			<li class="rt-animate wow fadeInUp" data-wow-delay="600ms" data-wow-duration="800ms">
				<?php if($percentage_getimg){ ?>
					<?php echo  wp_kses_post($percentage_getimg);?>
				<?php } else{ ?>	
					<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape18.png'; ?>" height="84" width="92" alt="">
				<?php } ?>
			</li>
			<li class="motion-effects2">
				<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape19.png'; ?>" width="152" height="112" alt="">	
			</li>
			<li class="motion-effects3">
				<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape20.png'; ?>" width="47" height="49" alt="">	
			</li>
			<li class="motion-effects5">
				<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape25.png'; ?>" width="173" height="169" alt="">	
			</li>
		</ul>
		
	</div>
</div>