<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$thumb_size = 'finbuzz-size7';
if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}

$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$excerpt_display=$data['excerpt_display'];
$excerpt_count = $data['excerpt_count'];
$title_count = $data['title_count'];
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' => 'finbuzz_portfolio',
	'post_status' => 'publish',
	'orderby' => $post_sorting,
	'order' => $post_ordering,
	'posts_per_page' => $number_of_post,
	'paged'          => $paged,
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_portfolio_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}

$query = new WP_Query( $args );

if($data['slider_autoplay']=='yes'){
	$data['slider_autoplay']=true;
}
else{
	$data['slider_autoplay']=false;
}

$swiper_data = array(
	'slidesPerView' 	=>2,
	'loop'				=>$data['slider_loop']=='yes' ? true:false,
	'spaceBetween'		=>$data['space']['size'],
	'slidesPerGroup'	=>$data['slider_per_group']['size'],
	'centeredSlides'	=>$data['centered_slide']=='yes' ? true:false ,
	'slideToClickedSlide' =>true,
	'autoplay'				=>array(
		'delay'  => $data['autoplayspeed']['size'],
	),
	'speed'      =>$data['speed']['size'],
	'breakpoints' =>array(
		'0'    =>array('slidesPerView' =>1),
		'576'    =>array('slidesPerView' =>$data['item_mobile']['size']),
		'768'    =>array('slidesPerView' =>$data['item_tablet']['size']),
		'992'    =>array('slidesPerView' =>$data['medium_item']['size']),
		'1200'    =>array('slidesPerView' =>$data['item']['size']),				
		'1600'    =>array('slidesPerView' =>$data['item']['size'])
	),
	'auto'   =>$data['slider_autoplay']
);
$swiper_data = json_encode( $swiper_data );

$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

?>
<div class="portfolio-default portfolio-multi-layout-5 portfolio-<?php echo esc_attr( $data['layout'] );?>">
	<div class="rt-related-slider" data-xld = '<?php echo esc_attr( $swiper_data )  ;?>'>	
		<?php $j = $data['delay']; $k = $data['duration'];
			if ( $query->have_posts() ) { ?>
                <div class="swiper-wrapper">
                    <?php while ( $query->have_posts() ) {
                    $query->the_post();	
                    $id 		= get_the_ID();
                    $portfolio_title = wp_trim_words( get_the_title(), $title_count, '' );
                    $content = apply_filters( 'the_content', get_the_content() );
                    $content = wp_trim_words( $content, $data['excerpt_count'], '' );
                    ?>
                    <div class="swiper-slide">
                        <div class="rtin-item rt-animate <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $j );?>s" data-wow-duration="<?php echo esc_attr( $k );?>s">
                            <div class="rtin-figure">
                                <a href="<?php the_permalink(); ?>">
                                    <?php
                                        if ( has_post_thumbnail() ){
                                            the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
                                        } else {
                                            echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'.get_the_title().'">';
                                        }
                                        
                                    ?>
                                </a>
                            </div>
                            <div class="rtin-content">
                                <?php if ( $data['cat_display'] ) { ?>
                                    <?php
                                        $i = 1;
                                        $term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
                                        if($term_lists){ ?>
                                        <div class="cat-list">
                                            <?php foreach ( $term_lists as $term_list ){ 
                                            $link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php $i++; } ?>
                                            </div>	
                                            
                                    <?php } }?>					
                                <h3>
                                    <a href="<?php echo the_permalink(); ?>">
                                    <span><?php echo wp_kses($portfolio_title,'alltext_allow');?></span>
                                    </a>
                                </h3>
                                <?php if ($data['excerpt_display']=='yes' ) { ?>
                                    <p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
                                <?php } ?>
                                <?php if ( $data['view_portfolio_link_btn'] ) { ?>
                                    <a href="<?php the_permalink();?>" class="read-more-btn"><i class="fas fa-plus"></i></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <?php  $j = $j + 0.2;} ?>
                </div>
                <?php if($data['navigation']=='yes'){ ?>
                    <div class="swiper-button">
                        <div class="swiper-button-prev"><i class="fas fa-chevron-left"></i></div>
                        <div class="swiper-button-next"><i class="fas fa-chevron-right"></i></div>
                    </div>
                <?php } ?>
	        <?php } ?>
	</div>	
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>
