<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$args = array(
	'post_type'      => 'finbuzz_testim',
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'finbuzz_testimonial_category',
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );

?>
<div class="default-testimonial testimonial-2 testimonial-vertical">
	<div class="slick-carousel slick-slider" data-slick="<?php echo esc_attr( $data['owl_data'] );?>">
		<?php if ( $query->have_posts() ) :?>
			<?php while ( $query->have_posts() ) : $query->the_post();?>
				<?php
				$id 			= get_the_id();
				$designation 	= get_post_meta( $id, 'finbuzz_tes_designation', true );
				$content 		= FinbuzzTheme_Helper::get_current_post_content();
				$content 		= wp_trim_words( $content, $data['count'], '' );
				$content 		= "<p>$content</p>";
				$ratting	 	= get_post_meta( $id, 'finbuzz_tes_rating', true );
				$rest_testimonial_rating = 5- intval( $ratting ) ;
				?>
				<div class="slick-slide testimonial-item">
					<div class="testimonial-content-wrap">
							<div class="testimonial-figure">
								<?php if ( has_post_thumbnail() && $data['thumbs_display']  == 'yes' ) { ?>
									<div class="testimonial-thumb"><?php the_post_thumbnail( 'finbuzz-size7' );?>
							    </div>
								<?php } ?>

								<div class="person-info">
									<div class="testimonial-title"><?php the_title(); ?></div>
									<div class="testimonial-designation">
										<?php if ( $data['designation_display']  == 'yes' && $designation ) { ?>
											<?php echo esc_html( $designation );?>
										<?php } ?>
									</div>
								</div>
							</div>
						<div class="testimonial-content">
							<?php if ( $data['ratting_display']  == 'yes' ) { ?>
								<ul class="rating">
									<?php for ($i=0; $i < $ratting; $i++) { ?>
										<li class="star-rate"><i class="fa fa-star" aria-hidden="true"></i></li>
									<?php } ?>			
									<?php for ($i=0; $i < $rest_testimonial_rating; $i++) { ?>
										<li><i class="fa fa-star" aria-hidden="true"></i></li>
									<?php } ?>
								</ul>
							<?php } ?>
							<?php echo wp_kses_post( $content ); ?>
							<div class="quotation-marks"><i class="fas fa-quote-right"></i></div>
						</div>
					</div>
				</div>
			<?php endwhile;?>
		<?php endif;?>
		<?php wp_reset_query();?>
	</div>
</div>