<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
if ( ! defined( 'ABSPATH' ) ) exit;

class Accordion extends Custom_Widget_Base{
    public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Accordion', 'bizcon-core' );
		$this->rt_base = 'rt-accordion';
		parent::__construct( $data, $args );
	}
    public function rt_fields(){
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'title', array(
				'label' => __( 'Title', 'bizcon-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'bizcon-core' ),
				'label_block' => true,
            )
		);
        $repeater->add_control(
			'accodion_text', array(
				'label' => __( 'Content', 'bizcon-core' ),
				'type' => \Elementor\Controls_Manager::WYSIWYG,
				'default' => __( 'List Content' , 'bizcon-core' ),
				'show_label' => false,
            )
		);
        $fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'bizcon-core' ),
			),
            array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Accordion Style', 'finbuzz-core' ),
				'options' => array(
					'style-1' => esc_html__( 'Style 1' , 'finbuzz-core' ),
					'style-2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style-3' => esc_html__( 'Style 3', 'finbuzz-core' ),
					'style-4' => esc_html__( 'Style 4', 'finbuzz-core' ),
				),
				'default' => 'style-1',
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'accordion_repeat',
				'label'   => esc_html__( 'Address', 'bizcon-core' ),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
				'fields' => $repeater->get_controls(),
			),
			array(
				'id'      => 'space_bottom',
				'mode'    => 'responsive',
				'type' => Controls_Manager::SLIDER,
				'label' => esc_html__( 'Space Bottom', 'bizcon-core' ),
				'range' => [
					'px' => [
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rt-accordion .accordion-item' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			),
			array(
				'mode' => 'section_end',
			),
			// Title
			array(
				'id'      => 'title_style',
				'mode'    => 'section_start',
				'label'   => esc_html__( 'Title', 'clenix-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Color', 'clenix-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-accordion .accordion-button.collapsed' => 'color: {{VALUE}}',
				),
			),
			array(
				'name'     => 'title_typo',
				'mode'     => 'group',
				'type'     => Group_Control_Typography::get_type(),
				'label'    => __( 'Typography', 'bizcon-core' ),
				'selector' => '{{WRAPPER}} .rt-accordion .accordion-header button',
			),
            array(
				'id'      => 'heading',
				'type' => Controls_Manager::HEADING,
				'label'   => __( 'Title Active', 'bizcon-core' ),
				'separator' => 'before',
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_active_color',
				'label'   => esc_html__( 'Title Active Color', 'clenix-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-accordion .accordion-header button' => 'color: {{VALUE}}',
				),
			),
            
			array(
				'mode' => 'section_end',
			),
			// Description
			array(
				'id'      => 'desc_style',
				'mode'    => 'section_start',
				'label'   => esc_html__( 'Description', 'clenix-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'desc_color',
				'label'   => esc_html__( 'Color', 'clenix-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-accordion .accordion-body p' => 'color: {{VALUE}}',
				),
			),
			array(
				'name'     => 'desc_typo',
				'mode'     => 'group',
				'type'     => Group_Control_Typography::get_type(),
				'label'    => __( 'Typography', 'bizcon-core' ),
				'selector' => '{{WRAPPER}} .rt-accordion .accordion-body p',
			),
			array(
				'mode' => 'section_end',
			),
			// Icon
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_style',
				'label'   => esc_html__( 'Icon', 'clenix-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'name'      => 'icon_bg_color',
				'mode'     => 'group',
				'type'     => Group_Control_Background::get_type(),
				'label'    => __( 'Icon Background', 'bizcon-core' ),
				'selector' => '{{WRAPPER}} .rt-accordion .accordion-button.collapsed:before',
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon  Color', 'clenix-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-accordion .accordion-button.collapsed:before' => 'color: {{VALUE}}',
				),
			),
            array(
				'id'      => 'heading2',
				'type' => Controls_Manager::HEADING,
				'label'   => __( 'Icon  Active', 'bizcon-core' ),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_active_color',
				'label'   => esc_html__( 'Icon  Color', 'clenix-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-accordion .accordion-button::before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .accordion-style-4 .accordion-button::before' => 'color: {{VALUE}}',
				),
			),
			array(
				'name'      => 'icon_bg_active_color',
				'mode'     => 'group',
				'type'     => Group_Control_Background::get_type(),
				'label'    => __( 'Icon Background', 'bizcon-core' ),
				'selector' => '{{WRAPPER}} .rt-accordion .accordion-button:before',
			),
			array(
				'mode' => 'section_end',
			),

		);
		return $fields;
    }
    protected function render() {
		$data = $this->get_settings();
		$template = 'accordion-1';
		return $this->rt_template( $template, $data );
	}

}