<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Gallery extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Gallery', 'finbuzz-core' );
		$this->rt_base = 'gallery';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => esc_html__( '1 Col', 'finbuzz-core' ),
				'6'  => esc_html__( '2 Col', 'finbuzz-core' ),
				'4'  => esc_html__( '3 Col', 'finbuzz-core' ),
				'3'  => esc_html__( '4 Col', 'finbuzz-core' ),
				'2'  => esc_html__( '6 Col', 'finbuzz-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	public function rt_fields(){
		$terms  = get_terms( array( 'taxonomy' => 'finbuzz_gallery_category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'Please Selecet category', 'finbuzz-core' ) );
		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}
		
		$posts = get_posts( ['post_type' => "finbuzz_gallery", 'posts_per_page' => -1, 'orderby' => 'title','order' => 'ASC','post_status' => 'publish','suppress_filters' => false]);
	    $posts_dropdown= array( '0' => __( 'Please Selecet Posts ', 'consalty-core' ) );
		
		
	    foreach ( $posts as $post ) {
	      $posts_dropdown[$post->ID] = $post->post_title;
	    }

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'finbuzz-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Gallery Layout 1', 'finbuzz-core' ),
					'layout2' => esc_html__( 'Gallery Layout 2', 'finbuzz-core' ),
				), 
				'default' => 'layout1',
			),
			array(
                'type'     => Controls_Manager::SELECT2,
                'id'       => 'single_post',
                'label'    => esc_html__('Select Post By Name', 'consalty-core'),
                'options'  =>$posts_dropdown,
                'default'  => '0',
                'multiple' => false,
                'label_block' => true,
                'condition'   => array( 'layout' =>'layout2' ),
            ),
			array(
				'type' 				=> Controls_Manager::SLIDER,
				'mode' 				=> 'responsive',
				'id'      		=> 'box_height',
				'label'   		=> esc_html__( 'Height', 'consalty-core' ),
				'size_units' => array( 'px' ),
				 'range' => [
				 'px' => [
				   'min' => 0,
				   'max' => 900,
				 ],
			   ],
				'default' => array(
				'unit' => 'px',
				'size' => 400,
				),
				'selectors' => array(
					'{{WRAPPER}} .gallery-layout2 .rtin-figure' => 'height: {{SIZE}}{{UNIT}};',	
					'{{WRAPPER}} .gallery-layout2 .rtin-figure img' => 'height: inherit;object-fit:cover;',						
				),
				'condition'   => array( 'layout' =>'layout2' ),
				
			),
			array (
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'cat_single',
				'label'     => esc_html__( 'Categories', 'finbuzz-core' ),
				'options'   => $category_dropdown,
				'default'   => '0',
				'multiple'  => false,
				'condition'   => array( 'layout' => array('layout1' )),
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => esc_html__( 'Post Ordering', 'finbuzz-core' ),
				'options' => array(
					'DESC'	=> esc_html__( 'Desecending', 'finbuzz-core' ),
					'ASC'	=> esc_html__( 'Ascending', 'finbuzz-core' ),
				),
				'default' => 'DESC',
				'condition'   => array( 'layout' =>'layout1' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Post Sorting', 'finbuzz-core' ),				
				'options' => array(
					'recent' 		=> esc_html__( 'Recent Post', 'finbuzz-core' ),
					'rand' 			=> esc_html__( 'Random Post', 'finbuzz-core' ),
					'menu_order' 	=> esc_html__( 'Custom Order', 'finbuzz-core' ),
					'title' 		=> esc_html__( 'By Name', 'finbuzz-core' ),
				),
				'default' => 'recent',
				'condition'   => array( 'layout' =>'layout1' ),
			),			
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_not_in',
				'label'   => esc_html__( 'Enter Post ID that will not display', 'finbuzz-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::NUMBER,
						'name'    => 'post_not_in',
						'label'   => esc_html__( 'Post ID', 'finbuzz-core' ),
						'default' => '0',
					),
				),
				'condition'   => array( 'layout' =>'layout1' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'item_space',
				'label'   => esc_html__( 'Item Space', 'neeon-core' ),
				'options' => array(
					'g-0' => esc_html__( 'Gutters 0', 'neeon-core' ),
					'g-1' => esc_html__( 'Gutters 1', 'neeon-core' ),
					'g-2' => esc_html__( 'Gutters 2', 'neeon-core' ),
					'g-3' => esc_html__( 'Gutters 3', 'neeon-core' ),
					'g-4' => esc_html__( 'Gutters 4', 'neeon-core' ),
					'g-5' => esc_html__( 'Gutters 5', 'neeon-core' ),
				),
				'default' => 'g-4',
				'condition'   => array( 'layout' =>'layout1' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'itemnumber',
				'label'   => esc_html__( 'Item Number', 'finbuzz-core' ),
				'default' => -1,
				'description' => esc_html__( 'Use -1 for showing all items( Showing items per category )', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_count',
				'label'   => esc_html__( 'Title Word count', 'finbuzz-core' ),
				'default' => 5,
				'description' => esc_html__( 'Maximum number of words', 'finbuzz-core' ),				
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'cat_display',
				'label'       => esc_html__( 'Category Name Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'excerpt_display',
				'label'       => esc_html__( 'Excerpt/Content Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'no',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'excerpt_count',
				'label'   => esc_html__( 'Word count', 'finbuzz-core' ),
				'default' => 15,
				'description' => esc_html__( 'Maximum number of words', 'finbuzz-core' ),
				'condition'   => array( 'excerpt_display' =>'yes' ),
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'view_display',
				'label'       => esc_html__( 'PopUp Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
				'condition'   => array( 'layout' => array('layout1' )),
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'view_project_link_btn',
				'label'       => esc_html__( 'Show Link Button', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Item Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .gallery-multi-layout-2 .rtin-item h3',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'more_button_display',
				'label'       => esc_html__( 'More Button Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide More Button . Default: On', 'finbuzz-core' ),
				'condition'   => array( 'layout' => array('layout1' )),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'more_button',
				'label'   => esc_html__( 'More Button', 'finbuzz-core' ),
				'options' => array(
					'show'        => esc_html__( 'Show Read More', 'finbuzz-core' ),
					'hide'        => esc_html__( 'Show Pagination', 'finbuzz-core' ),
				),
				'condition'   => array('more_button_display'=>'yes' ),	
				'condition'   => array( 'layout' => array('layout1' )),			
				'default' => 'show',				
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_text',
				'label'   => esc_html__( 'Button Text', 'finbuzz-core' ),
				'default' => esc_html__( 'More Gallery', 'finbuzz-core' ),
				'condition'   => array( 'more_button' => array( 'show' ),'more_button_display'=>array('yes') ),
				'condition'   => array( 'layout' => array('layout1' )),
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_link',
				'label'   => esc_html__( 'Button Link', 'finbuzz-core' ),
				'condition'   => array( 'more_button' => array( 'show' ),'more_button_display'=>array('yes') ),
				'condition'   => array( 'layout' => array('layout1' )),
			),
			array(
				'mode' => 'section_end',
			),

			// Style
			array(
				'mode'    => 'section_start',
				'id'      => 'layout_4_style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color',
				'label'   => esc_html__( 'Item Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .gallery-default .rtin-item h3 a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_cat_color',
				'label'   => esc_html__( 'Item Category Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .gallery-default .rtin-item .rtin-content .rtin-cat a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_content_color',
				'label'   => esc_html__( 'Item Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .gallery-default .rtin-item .rtin-content p' => 'color: {{VALUE}}',
				),
			),	
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_bg_color',
				'label'   => esc_html__( 'Icon Background Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .gallery-multi-layout-2 .rtin-item .item-icon a' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .gallery-multi-layout-1 .rtin-item .rtin-figure .rtin-content .item-button .gallery-btn' => 'background-color: {{VALUE}}',
				),
				
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon  Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .gallery-multi-layout-2 .rtin-item .item-icon a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .gallery-multi-layout-1 .rtin-item .rtin-figure .rtin-content .item-button .gallery-btn' => 'color: {{VALUE}}',
				),
				
			),
			array(
				'id'      => 'gallery_hover_heading',
				'type' =>        Controls_Manager::HEADING,
				'label'   => __( 'Hover', 'bizcon-core' ),
				'separator' => 'before',
				'condition'   => array( 'layout' => array('layout1' )),
			 ),
			 array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'hover_icon_bg_color',
				'label'   => esc_html__( 'Icon  Hover Background Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .gallery-multi-layout-2 .rtin-item .item-icon a:hover' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array('layout1' )),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'hover_icon_color',
				'label'   => esc_html__( 'Icon  Hover Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .gallery-multi-layout-2 .rtin-item .item-icon a:hover' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array('layout1' )),
			),
					
			array(
				'mode' => 'section_end',
			),
			
			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
				'condition'=>array( 'layout' => array('layout1') ),
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'finbuzz-core' ),
					'hide'        => esc_html__( 'Off', 'finbuzz-core' ),
				),
				'default' => 'wow',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'finbuzz-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'finbuzz-core' ),
					'bounce' => esc_html__( 'bounce', 'finbuzz-core' ),
					'flash' => esc_html__( 'flash', 'finbuzz-core' ),
					'pulse' => esc_html__( 'pulse', 'finbuzz-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'finbuzz-core' ),
					'shakeX' => esc_html__( 'shakeX', 'finbuzz-core' ),
					'shakeY' => esc_html__( 'shakeY', 'finbuzz-core' ),
					'headShake' => esc_html__( 'headShake', 'finbuzz-core' ),
					'swing' => esc_html__( 'swing', 'finbuzz-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'finbuzz-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'finbuzz-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'finbuzz-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'finbuzz-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'finbuzz-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'finbuzz-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'finbuzz-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'finbuzz-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'finbuzz-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'finbuzz-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'finbuzz-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'finbuzz-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'finbuzz-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'finbuzz-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'finbuzz-core' ),
				'default' => '0.2',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'finbuzz-core' ),
				'default' => '.8',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'finbuzz-core' ),
				'condition'   => array( 'layout' => array('layout1')),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xl',
				'label'   => esc_html__( 'Desktops: > 1199px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 991px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Tablets: > 767px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Phones: > 576px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col',
				'label'   => esc_html__( 'Phones: < 576px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		switch ( $data['layout'] ) {
			case 'layout2':
			$template = 'gallery-2';
			break;
			default:
			$template = 'gallery-1';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}