<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Testimonial extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Testimonial', 'finbuzz-core' );
		$this->rt_base = 'rt-testimonial';
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_style(  'slick' );
		wp_enqueue_style(  'slick-theme' );
		wp_enqueue_script( 'slick' );
	}
	private function rt_load_scripts2(){
		wp_enqueue_style(  'swiper-slider' );
		wp_enqueue_script('swiper-slider');
	}
	public function rt_fields(){
		$cpt = FINBUZZ_CORE_CPT_PREFIX;
		$terms  = get_terms( array( 'taxonomy' => "{$cpt}_testimonial_category", 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => esc_html__( 'All Categories', 'finbuzz-core' ) );
		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
					'style4' => esc_html__( 'Style 4', 'finbuzz-core' ),
					'style5' => esc_html__( 'Style 5', 'finbuzz-core' ),
					'style6' => esc_html__( 'Style 6', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat',
				'label'   => esc_html__( 'Categories', 'finbuzz-core' ),
				'options' => $category_dropdown,
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Order By', 'finbuzz-core' ),
				'options' => array(
					'date'        => esc_html__( 'Date (Recents comes first)', 'finbuzz-core' ),
					'title'       => esc_html__( 'Title', 'finbuzz-core' ),
				),
				'default' => 'date',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'count',
				'label'   => esc_html__( 'Word count', 'finbuzz-core' ),
				'default' => 34,
				'description' => esc_html__( 'Maximum number of words', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Total number of items', 'finbuzz-core' ),
				'default' => 5,
				'description' => esc_html__( 'Write -1 to show all', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'designation_display',
				'label'       => esc_html__( 'Designation Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Designation. Default: On', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'ratting_display',
				'label'       => esc_html__( 'Ratting Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'off',
				'description' => esc_html__( 'Show or Hide Ratting. Default: Off', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'thumbs_display',
				'label'       => esc_html__( 'Thumbs Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Thumbs. Default: Off', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'testi_padding',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Padding', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .testimonial-1 .testimonial-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => array( 'style' => array( 'style1') ),
			),
			array(
				'mode' => 'section_end',
			),
			// Style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typro', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .default-testimonial .testimonial-item .testimonial-title',
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'desig_title_typo',
				'label'   => esc_html__( 'Designation Typro', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .default-testimonial .testimonial-item .testimonial-designation',
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'content_typo',
				'label'   => esc_html__( 'Content Typro', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .default-testimonial .testimonial-item .testimonial-content p',
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_bg_color',
				'label'   => esc_html__( 'Item Background Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .default-testimonial .testimonial-item .testimonial-content ' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .default-testimonial .testimonial-item' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-4 .testimonial-item:after' => 'background-color: {{VALUE}}',
				),
				'condition'=>array('style'=>array('style1','style2','style3','style4'))
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .default-testimonial .testimonial-item .testimonial-title' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_designa_color',
				'label'   => esc_html__( 'Designation Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .default-testimonial .testimonial-item .testimonial-designation' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_content_color',
				'label'   => esc_html__( 'Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .default-testimonial .testimonial-item .testimonial-content p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-3 .testimonial-item .testimonial-content p:after' => 'background-color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_icon_color',
				'label'   => esc_html__( 'Item Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rtin-testimonial-1 .rtin-item .item-icon i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-2 .slick-arrow:before' => 'color: {{VALUE}}',
					'{{WRAPPER}} .testimonial-3 .rt-swiper-container .swiper-button > div' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style1','style2','style3','style4') ),	
			),						
			array(
				'mode' => 'section_end',
			),
			
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'vertical',
				'label'       => esc_html__( 'Vertical slide', 'finbuzz-core' ),
				'default'    =>'off',
				'condition'   => array( 'style' => array( 'style1','style2')),
			),

			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'finbuzz-core' ),
				'default'     => 'off',
				'condition'   => array( 'style' => array( 'style3','style4','style5','style6') ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'navigation',
				'label'       => esc_html__( 'Navigation', 'finbuzz-core' ),
				'default'     => 'off',
				'condition'   => array( 'style' => array('style4','style5','style6') ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'centered_slide',
				'label'       => esc_html__( 'Center Slide', 'finbuzz-core' ),
				'default'     => 'false',
				'condition'   => array( 'style' => array( 'style3','style4','style5','style6') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'slider_per_group',
				'label'       => esc_html__( 'Slides Per Group', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				'condition'   => array( 'style' => array( 'style3','style4','style5','style6') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'autoplayspeed',
				'label'       => esc_html__( 'Autoplay speed', 'finbuzz-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'speed',
				'label'       => esc_html__( 'Slider Speed', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
				'condition'   => array( 'style' => array( 'style3','style4','style5','style6') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'space',
				'label'       => esc_html__( 'Inter slider spacing', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 30,
                ],
				'condition'   => array( 'style' => array( 'style3','style4','style5','style6') ),
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item',
				'label'       => esc_html__( 'Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'medium_item',
				'label'       => esc_html__( 'Medium Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				'condition'   => array( 'style' => array( 'style3','style4','style5','style6') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_tablet',
				'label'       => esc_html__( 'Tablet items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				'condition'   => array( 'style' => array( 'style3','style4','style5','style6') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_mobile',
				'label'       => esc_html__( 'Mobile items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				'condition'   => array( 'style' => array( 'style3','style4','style5','style6') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'mode'      => 'responsive',
				'id'          => 'vertical_slide_height',
				'label'       => esc_html__( 'Slider height', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-2 .testimonial-content-wrap' => 'height: {{SIZE}}{{UNIT}};',
                ],
				'condition'   => array( 'style' => array( 'style2') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'mode'      => 'responsive',
				'id'          => 'arrow_positon',
				'label'       => esc_html__( 'Left Arrow Position', 'finbuzz-core' ),
                'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
                'size_units' => [ '%', 'px', 'vw' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-1 .slick-prev' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .default-testimonial .rt-related-slider .swiper-button-prev' => 'left: {{SIZE}}{{UNIT}};',
                ],
				'condition'   => array( 'style' => array( 'style1','style3','style4') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'mode'      => 'responsive',
				'id'          => 'arrow_right_positon',
				'label'       => esc_html__( 'Right Arrow Position', 'finbuzz-core' ),
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
                'size_units' => [ '%', 'px', 'vw' ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-1 .slick-next' => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .default-testimonial .rt-related-slider .swiper-button-next' => 'right: {{SIZE}}{{UNIT}};',
                ],
				'condition'   => array( 'style' => array( 'style1','style3','style4') ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		if ( is_rtl() ) {
			$rtl = true;
			$data['vertical'] ='no';
		}else {
			$rtl = false;
		}
		$owl_data = array(
			'autoplay' => $data['slider_autoplay'] == 'yes' ? true : false,
			'autoplaySpeed'  => $data['autoplayspeed']['size'],
			'slidesToShow'  => $data['item']['size'],
			'direction' => $data['vertical'] == 'yes' ? 'vertical' : 'horizontal',
			'vertical'  =>$data['vertical'] == 'yes' ? true :false,
			'rtl' => $rtl,
		);
		switch ( $data['style'] ) {
			case 'style6':
			$this->rt_load_scripts2();
			$template = 'testimonial-6';
			break;
			case 'style5':
			$this->rt_load_scripts2();
			$template = 'testimonial-5';
			break;
			case 'style4':
			$this->rt_load_scripts2();
			$template = 'testimonial-4';
			break;
			case 'style3':
			$this->rt_load_scripts2();
			$template = 'testimonial-3';
			break;
			case 'style2':
			$this->rt_load_scripts();
			$template = 'testimonial-2';
			break;
			default:
			$this->rt_load_scripts();
			$template = 'testimonial-1';
			break;
		}

		$data['owl_data'] = json_encode( $owl_data );

		return $this->rt_template( $template, $data );
	}
}