<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);
$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
}

$svg='<svg 
        xmlns="http://www.w3.org/2000/svg"
        xmlns:xlink="http://www.w3.org/1999/xlink"
        width="24px" height="24px">
        <path fill-rule="evenodd"  fill="rgb(250, 54, 10)"
        d="M11.998,23.997 C5.381,23.997 -0.001,18.614 -0.001,11.998 C-0.001,5.382 5.381,-0.001 11.998,-0.001 C18.614,-0.001 23.997,5.382 23.997,11.998 C23.997,18.614 18.614,23.997 11.998,23.997 ZM11.998,2.181 C6.584,2.181 2.180,6.585 2.180,11.998 C2.180,17.412 6.584,21.815 11.998,21.815 C17.411,21.815 21.815,17.412 21.815,11.998 C21.815,6.585 17.411,2.181 11.998,2.181 ZM17.368,12.415 C17.312,12.548 17.232,12.669 17.131,12.770 L12.769,17.132 C12.556,17.346 12.277,17.452 11.998,17.452 C11.718,17.452 11.439,17.346 11.226,17.132 C10.800,16.706 10.800,16.016 11.226,15.590 L13.728,13.089 L7.634,13.089 C7.032,13.089 6.543,12.600 6.543,11.998 C6.543,11.396 7.032,10.907 7.634,10.907 L13.728,10.907 L11.226,8.406 C10.800,7.980 10.800,7.289 11.226,6.863 C11.652,6.437 12.343,6.437 12.769,6.863 L17.131,11.226 C17.232,11.327 17.312,11.447 17.368,11.581 C17.478,11.848 17.478,12.148 17.368,12.415 Z"/>
        </svg>';

//image
$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'rt_image' );
  
//button style
if ( $data['button_style'] == 'finbuzz-button-2' ) {
	if ( !empty( $data['buttontext'] ) ) {
		$btn = '<a class=" btn-transperent" ' . $attr . '>' .  $data['buttontext'] . '</a>';
	}
}else {
	if ( !empty( $data['buttontext'] ) ) {
		$btn = '<a class="btn-style3" ' . $attr . '>' .$data['buttontext'] .$svg. '</a>';
	}
}
$mouse_follow_effect="";
if($data['mouse_follow']=='yes'){
    $mouse_follow_effect="motion-effects-wrap";
}
?>  

<!-- Start Banner -->
<section class="banner-addon style-4 <?php echo esc_attr( $mouse_follow_effect); ?>">
   
         <ul class="element-list d-none d-xl-block">
            <li class="motion-effects1">
                <?php if($data['shape1_display']=='yes'){?>
                <img class="wow fadeInLeft" data-wow-delay="600ms" data-wow-duration="800ms" src="<?php echo FINBUZZ_ASSETS_URL . 'element/element_40.png'; ?>" alt="element_40" >
                <?php } ?>
            </li>
            <li class="motion-effects3">
                <?php if($data['banner_1_shape2_display']=='yes'){?>
                <img class="wow fadeInUp" data-wow-delay="300ms" data-wow-duration="800ms" src="<?php echo FINBUZZ_ASSETS_URL . 'element/element_41.png'; ?>" alt="element_41">
                <?php } ?>
            </li>
		</ul>
        <div class="container">
            <div class="banner-content-wrap">
                <div class="row">
                    <div class="col-xl-7 col-lg-8 col-md-8">
                        <div class="banner-content style-2">
                            <span class="subtitle style-2">
                                <?php echo wp_kses_post( $data['sub_title'] );?>
                            </span>
                            <h1 class="banner-title">
                                <?php echo wp_kses_post( $data['title'] );?>
                            </h1>
                            <p>
                            <?php echo wp_kses_post( $data['content'] );?>
                            </p>
                            <?php if ( !empty( $btn ) ){ ?>
                            <div class="btn-wrap">
                            <?php echo wp_kses_post( $btn );?>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            
        </div>			
</section>
<!-- End Banner -->