<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
}
//title url

$title_attr = '';
if ( !empty( $data['title_url']['url'] ) ) {
	$title_attr  = 'href="' . $data['title_url']['url'] . '"';
	$title_attr .= !empty( $data['title_url']['is_external'] ) ? ' target="_blank"' : '';
	$title_attr .= !empty( $data['title_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $title_attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
}


$cat_attr = '';
if ( !empty( $data['cat_url']['url'] ) ) {
	$cat_attr  = 'href="' . $data['cat_url']['url'] . '"';
	$cat_attr .= !empty( $data['cat_url']['is_external'] ) ? ' target="_blank"' : '';
	$cat_attr .= !empty( $data['cat_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$cat = '<a ' . $cat_attr . '>' . $data['cat'] . '</a>';
	
}
else {
	$cat = $data['cat'];
}



$btn = '<a class="read-more-btn" ' . $attr . '>'.'<i class="fas fa-link"></i>' .'</a>';

$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'info_5_image_size', 'info_5_image' );

?>
<div class="info-box info-<?php echo esc_attr( $data['style'] );?>">
	<div class="info-item">
		<?php if($getimg){
			echo wp_kses_post( $getimg );
		} ?>
		<div class="info-content">
			<div class="info-category">
                <?php if ( !empty( $data['cat'] ) ) { ?>
                    <?php echo wp_kses_post( $cat);?>
                <?php } ?>
            </div>
			<?php if ( !empty( $data['title'] ) ) { ?>
				<h3 class="info-title"><?php echo wp_kses_post( $title );?></h3>
			<?php }  ?>

		</div>
		<?php if ( $data['button_display']  == 'yes' ) { ?>
			<div class="link-shape-box">
				<div class="link-shape">
					<div class="info-button">
					<?php echo wp_kses_post( $btn );?>
					</div>
				</div>
			</div>
		<?php } ?>
	</div>
</div>