<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$thumb_size = 'finbuzz-size5';
if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}


$number_of_post = $data['itemnumber'];
$post_sorting = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];
$excerpt_count = $data['excerpt_count'];	
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' 		=> 'finbuzz_service',
	'post_status' 		=> 'publish',
	'orderby' 			=> $post_sorting,
	'order' 			=> $post_ordering,
	'posts_per_page' 	=> $number_of_post,
	'paged'          	=> $paged,
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_service_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}
if($data['slider_autoplay']=='yes'){
	$data['slider_autoplay']=true;
}
else{
	$data['slider_autoplay']=false;
}

$swiper_data = array(
	'slidesPerView' 	=>2,
	'loop'				=>$data['slider_loop']=='yes' ? true:false,
	'spaceBetween'		=>$data['space']['size'],
	'slidesPerGroup'	=>$data['slider_per_group']['size'],
	'centeredSlides'	=>$data['centered_slide']=='yes' ? true:false ,
	'slideToClickedSlide' =>true,
	'autoplay'				=>array(
		'delay'  => $data['autoplayspeed']['size'],
	),
	'speed'      =>$data['speed']['size'],
	'breakpoints' =>array(
		'0'    =>array('slidesPerView' =>1),
		'576'    =>array('slidesPerView' =>$data['item_mobile']['size']),
		'768'    =>array('slidesPerView' =>$data['item_tablet']['size']),
		'992'    =>array('slidesPerView' =>$data['medium_item']['size']),
		'1200'    =>array('slidesPerView' =>$data['item']['size']),				
		'1600'    =>array('slidesPerView' =>$data['item']['size'])
	),
	'auto'   =>$data['slider_autoplay']
);
$svg='<svg 
		xmlns="http://www.w3.org/2000/svg"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		width="24px" height="24px" viewBox="0 0 24 24">
		<path fill-rule="evenodd" fill="#FA360A" d="M11.998 23.997c-6.617 0-11.999-5.383-11.999-11.999 0-6.616 5.382-11.999 11.999-11.999 6.616 0 11.999 5.383 11.999 11.999 0 6.616-5.383 11.999-11.999 11.999Zm0-21.816c-5.414 0-9.818 4.404-9.818 9.817 0 5.414 4.404 9.817 9.818 9.817 5.413 0 9.817-4.403 9.817-9.817 0-5.413-4.404-9.817-9.817-9.817Zm5.37 10.234a1.11 1.11 0 0 1-.237.355l-4.362 4.362c-.213.214-.492.32-.771.32a1.09 1.09 0 0 1-.772-1.862l2.502-2.501H7.634a1.092 1.092 0 0 1 0-2.182h6.094l-2.502-2.501a1.091 1.091 0 0 1 1.543-1.543l4.362 4.363a1.095 1.095 0 0 1 .237 1.189Z"/>
		</svg>';
$swiper_data = json_encode( $swiper_data );
$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

?>

<div class="service-default service-<?php echo esc_attr( $data['layout'] );?> service-slider-layout">
	<div class="rt-related-slider" data-xld = '<?php echo esc_attr( $swiper_data )  ;?>'>	
		<?php
			 $i = $data['delay']; $j = $data['duration'];
			if ( $query->have_posts() ) { ?>
                <div class="swiper-wrapper">
                    <?php	while ( $query->have_posts() ) {
                        $query->the_post();			
                        $id								= $query->ID;
                        $excerpt 						= wp_trim_words( get_the_excerpt(), $excerpt_count, '' );
                        $service_title 					= wp_trim_words( get_the_title(), $title_count, '' );
                        $finbuzz_service_icon   		= get_post_meta( get_the_ID(), 'finbuzz_service_icon', true );
                        $finbuzz_insurance_img   		= get_post_meta( get_the_ID(), 'finbuzz_service_img', true );
                    ?>
                    <div class="swiper-slide">
                        <div class="service-item rt-animate <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $i );?>s" data-wow-duration="<?php echo esc_attr( $j );?>s">
                            <div class="service-box-content">
                            <?php
                                $thumbnail1="";
                                $thumbnail2="";
                                if ( has_post_thumbnail() ){
                                    $thumbnail1=wp_get_attachment_image_src( get_post_thumbnail_id( $id ), $thumb_size  );
                                    
                                } else {
                                    $thumbnail2=FinbuzzTheme_Helper::get_img( 'noimage_390X340.jpg' );
                                }
                                if(isset($thumbnail1) && !empty($thumbnail1)){
                                    $thumbnail=$thumbnail1[0];
                                }
                                if(isset($thumbnail2) && !empty($thumbnail2)){
                                    $thumbnail=$thumbnail2;
                                }
                                ?>
                                <div class="service-figure"  data-bg-image=<?php echo esc_attr( $thumbnail ); ?>>
                                    <div class="service-content-wrap">
                                        <div class="service-content">
                                            <?php if($data['icon_display']){ ?>
                                                <?php if ( !empty($finbuzz_service_icon ) || !empty($finbuzz_insurance_img  )  ) { ?>
                                                    <?php if ( $finbuzz_insurance_img ) : ?>
                                                        <div class="service-img-wrap">
                                                            <div class="service-hover-img">
                                                                <span><?php echo wp_get_attachment_image($finbuzz_insurance_img );?></span>
                                                            </div>
                                                        </div>
                                                    <?php else: ?>
                                                    <div class="icon">
                                                        <span><i class="<?php echo wp_kses_post( $finbuzz_service_icon );?>"></i></span>
                                                    </div>
                                                <?php endif; ?>
                                                <?php } ?>
                                            <?php } ?>
                                            <h3 class="service-title"><a href="<?php the_permalink();?>"><?php echo esc_html( $service_title  );?></a></h3>
                                            <div class="service-info">
                                                <p><?php echo wp_kses( $excerpt , 'alltext_allow' ); ?></p>
                                                <a class="btn-style1" href="<?php  the_permalink(); ?>"><?php  esc_html_e( 'READ MORE', 'finbuzz' );?>
                                                    <?php echo wp_kses_post($svg); ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $i = $i + 0.2;  } ?>
                </div>
                <?php  if($data['pagination']=='yes'){  ?>
                    <div class="swiper-pagination"></div>
                <?php } ?>
	        <?php } ?>
	</div>
	
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>