<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Group_Control_Image_Size;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;

class CTA extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Call to Action', 'finbuzz-core' );
		$this->rt_base = 'rt-cta';
		parent::__construct( $data, $args );
	}
	
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'CTA Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1' , 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
					'style4' => esc_html__( 'Style 4', 'finbuzz-core' ),
					'style5' => esc_html__( 'Style 5', 'finbuzz-core' ),
					'style6' => esc_html__( 'Style 6', 'finbuzz-core' ),
					'style7' => esc_html__( 'Style 7', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'content_align',
				'label'   => esc_html__( 'Text Align', 'finbuzz-core' ),
				'options' => array(
					'left' => esc_html__( 'Left' , 'finbuzz-core' ),
					'center' => esc_html__( 'Center', 'finbuzz-core' ),
					'right' => esc_html__( 'right', 'finbuzz-core' ),
				),
				'selectors' => array(
					'{{WRAPPER}} .cta-style1 .action-box' => 'justify-content: {{VALUE}}',
					
				),
				'condition'   => array( 'style' => array( 'style1') ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Need Any Financial Help!', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'sub_title',
				'label'   => esc_html__( 'Sub Title', 'finbuzz-core' ),
				'default' => esc_html__( 'web financial epress , we will help to organize.', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style2','style3','style5') ),
			),
			
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'phone_icon_class',
				'label'   => esc_html__( 'Phone Icon', 'finbuzz-core' ),
				'default' => array(
			      'value' => 'far fa-comments',
			      'library' => 'fa-regular',
				),
				'condition'   => array( 'style' => array( 'style1','style6') ),	
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'phone_title',
				'label_block'=>true,
				'label'   => esc_html__( 'Phone Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Hotline', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style1','style5') ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'pho_number',
				'label_block'=>true,
				'label'   => esc_html__( 'Phone Number', 'finbuzz-core' ),
				'default' => '009850-9850',
				'condition'   => array( 'style' => array( 'style1','style5') ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'hour_text',
				'label_block'=>true,
				'label'   => esc_html__( 'Hour Text', 'finbuzz-core' ),
				'default' => esc_html__( 'HELP DESK 24H/7', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style6') ),
			),
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'email_icon_class',
				'label'   => esc_html__( 'Email Icon', 'finbuzz-core' ),
				'default' => array(
			      'value' => 'far fa-envelope',
			      'library' => 'fa-solid',
				),
				'condition'   => array( 'style' => array( 'style1') ),	
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'email_title',
				'label_block'=>true,
				'label'   => esc_html__( 'Email Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Send Us Email', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style1') ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'email',
				'label_block'=>true,
				'label'   => esc_html__( 'Email', 'finbuzz-core' ),
				'default' => 'info@gmail.com',
				'condition'   => array( 'style' => array( 'style1') ),
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'image',
				'label'   => esc_html__( 'Image', 'finbuzz-core' ),
				'description' => esc_html__( 'Recommended 587px width and 200px size image', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style1' ) ),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'image_size', 
				'separator' => 'none',
				'condition'   => array( 'style' => array('style1' ) ),		
			),
			array(
				'type'    	  => Controls_Manager::TEXT,
				'id'      	  => 'buttontext',
				'label_block'=>true,
				'label'   	  => esc_html__( 'Button Text', 'finbuzz-core' ),
				'default' 	  => esc_html__( 'Reguest A Call Back', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style2','style3','style4','style6','style7') ),
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'buttonurl',
				'label'   => esc_html__( 'Button URL', 'finbuzz-core' ),
				'placeholder' => 'https://your-link.com',
				'condition'   => array( 'style' => array('style2','style3','style4','style6','style7') ),	
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'cta_padding',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'CTA Padding', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .cta-style1 .action-box .cta-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .cta-style2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .cta-style3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .cta-style4 .action-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .cta-style5 .action-box ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .cta-style6 .action-box ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .cta-style7 .action-box ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'cta_button_radius',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Button Border Radius', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .cta-style4 .btn-style1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .cta-style6 .btn-style1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .cta-style7 .btn-style1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => array( 'style' => array('style4','style6','style7') ),	
			),
			array(
				'mode' => 'section_end',
			),
			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'CTA Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .cta-default .action-box h2',
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .cta-default .action-box h2' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'info6_phone_color',
				'label'   => esc_html__( 'Phone Number Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .cta-style6 .action-box .cta-info .phn-number a' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style6' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'info6_hour_text_color',
				'label'   => esc_html__( 'Hour Text Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .cta-style6 .action-box .cta-info .info-text' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style6' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'info6_dotted_color',
				'label'   => esc_html__( 'Dotted Shape Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .cta-style6 .action-box .rtin-button' => 'border-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style6' ) ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'sub_title_typo',
				'label'   => esc_html__( 'Subtitle Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .cta-default .action-box .cta-content .cta-subtitle',
				'condition'   => array( 'style' => array( 'style2','style3','style5') ),
			),			
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sub_title_color',
				'label'   => esc_html__( 'Sub Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .cta-default .action-box .cta-content .cta-subtitle' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2','style3','style5') ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'contact_info_title_color',
				'label'   => esc_html__( 'Contact Info Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .cta-style1 .action-box .cta-contact-box .cta-contact .contact-content .contact-title' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style1' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'contact_info_color',
				'label'   => esc_html__( 'Contact Info Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .cta-style1 .action-box .cta-contact-box .cta-contact .contact-content .contact-info a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cta-style5 .action-box .cta-contact-info .contact li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cta-style5 .action-box .cta-contact-info .contact li a ' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style1','style5') ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .cta-style1 .action-box .cta-contact-box .cta-contact .contact-icon ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .cta-style5 .action-box .cta-contact-info .phone-icon i' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style1','style5') ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'cta_bg_color',
				'label'   => esc_html__( 'Cta Background', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .cta-style5 .action-box' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array('style5') ),
			),
			array(
				'mode' => 'section_end',
			),
			
		);
		return $fields;
	}
	protected function render() {
		$data = $this->get_settings();
		switch ( $data['style'] ) {
			case 'style7':
			$template = 'cta-7';
			break;
			case 'style6':
			$template = 'cta-6';
			break;
			case 'style5':
			$template = 'cta-5';
			break;
			case 'style4':
			$template = 'cta-4';
			break;
			case 'style3':
			$template = 'cta-3';
			break;
			case 'style2':
			$template = 'cta-2';
			break;
			default:
			$template = 'cta-1';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}