<?php
/**
 * This file can be overridden by copying it to yourtheme/elementor-custom/about-box/class.php
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;


if ( ! defined( 'ABSPATH' ) ) exit;

class Pricing_Tab extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'Pricing Tab', 'finbuzz-core' );
		$this->rt_base = 'rt-pricing-tab';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'title',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => 'Basic Plan',
			]
		);
		$repeater->add_control(
			'monthly_price',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Monthly Price', 'finbuzz-core' ),
				'default' => '$19',
			]
		);
		$repeater->add_control(
			'yearly_price',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Yearly Price', 'finbuzz-core' ),
				'default' => '$60',
			]
		);
		$repeater->add_control(
			'content',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Content', 'finbuzz-core' ),
				'default' => 'Popularised in the follower with the etraset sheets containing.',
			]
		);
		$repeater->add_control(
			'list_item',
			 [
				'type'    => Controls_Manager::WYSIWYG,
				'label'   => esc_html__( 'Pricing List', 'finbuzz-core' ),
			]
		);
		$repeater->add_control(
			'btn_link',
			 [
				'type'    => Controls_Manager::URL,
				'label'   => esc_html__( 'Button Link', 'finbuzz-core' ),
			]
		);
		$fields = array(
			array(
				'id'      => 'sec_general',
				'mode'    => 'section_start',
				'label'   => __( 'General', 'finbuzz-core' ),
			),
			// Monthly
			array(
				'id'      => 'monthly_heading',
				'type' => Controls_Manager::HEADING,
				'label'   => __( 'Monthly', 'finbuzz-core' ),
				'separator' => 'before',
			),
			array(
				'id'      => 'monthly_label',
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Label', 'finbuzz-core' ),
				'default' => 'MONTHLY',
				'label_block' => true,
			),      
			// Yearly 
			array(
				'id'      => 'yearly_heading',
				'type' => Controls_Manager::HEADING,
				'label'   => __( 'Yearly', 'finbuzz-core' ),
				'separator' => 'before',
			),
			array(
				'id'      => 'yearly_label',
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Label', 'finbuzz-core' ),
				'default' => 'YEARLY',
				'label_block' => true,
			),
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'prices_infos',
				'label'   => esc_html__( 'Add Plan', 'finbuzz-core' ),
				'fields' => $repeater->get_controls(),
				'default' => array(
					['title' => 'Basic Plan', ],
					['title' => 'Standard Plan', ],
					['title' => 'Premium Plan', ],
				),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'pricing-tab';

		return $this->rt_template( $template, $data );
	}
}