<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use \RT_Posts;
use FinbuzzTheme;


if ( !class_exists( 'RT_Posts' ) ) {
	return;
}

$post_types = array(
	'finbuzz_team'       => array(
		'title'           => __( 'Team Member', 'finbuzz-core' ),
		'plural_title'    => __( 'Team', 'finbuzz-core' ),
		'menu_icon'       => 'dashicons-businessman',
		'labels_override' => array(
			'menu_name'   => __( 'Team', 'finbuzz-core' ),
		),
		'rewrite'         => FinbuzzTheme::$options['team_slug'],
		'supports'        => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' )
	),
	'finbuzz_service' => array(
		'title'           => __( 'Service', 'finbuzz-core' ),
		'plural_title'    => __( 'Services', 'finbuzz-core' ),
		'menu_icon'       => 'dashicons-book',
		'rewrite'         => FinbuzzTheme::$options['service_slug'],
		'supports'        => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
	),
	'finbuzz_portfolio'  => array(
		'title'           => __( 'Portfolio', 'finbuzz-core' ),
		'plural_title'    => __( 'Portfolios', 'finbuzz-core' ),
		'menu_icon'       => 'dashicons-book',
		'rewrite'         => FinbuzzTheme::$options['portfolio_slug'],
		'supports'        => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' ),
	),
	'finbuzz_testim'     => array(
		'title'           => __( 'Testimonial', 'finbuzz-core' ),
		'plural_title'    => __( 'Testimonials', 'finbuzz-core' ),
		'menu_icon'       => 'dashicons-awards',
		'rewrite'         => FinbuzzTheme::$options['testimonial_slug'],
		'supports'        => array( 'title', 'thumbnail', 'editor', 'page-attributes' )
	),
	'finbuzz_logoshowcase'     => array(
		'title'           => __( 'Logo', 'finbuzz-core' ),
		'plural_title'    => __( 'Logos', 'finbuzz-core' ),
		'menu_icon'       => 'dashicons-slides',
		'rewrite'         => FinbuzzTheme::$options['logoshowcase_slug'],
		'supports'     => array( 'title', 'thumbnail', 'excerpt', 'page-attributes' ),
	),
	'finbuzz_gallery'     => array(
		'title'           => __( 'Gallery', 'finbuzz-core' ),
		'plural_title'    => __( 'Galleries', 'finbuzz-core' ),
		'menu_icon'       => 'dashicons-format-gallery',
		'rewrite'         => FinbuzzTheme::$options['gallery_slug'],
		'supports'     => array( 'title', 'thumbnail', 'editor','excerpt', 'page-attributes' ),
	),
);

$taxonomies = array(
	'finbuzz_team_category' => array(
		'title'        => __( 'Team Category', 'finbuzz-core' ),
		'plural_title' => __( 'Team Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_team',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['team_cat_slug'] ),
	),
	'finbuzz_service_category' => array(
		'title'        => __( 'Service Category', 'finbuzz-core' ),
		'plural_title' => __( 'Services Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_service',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['service_cat_slug'] ),
	),
	'finbuzz_portfolio_category' => array(
		'title'        => __( 'Portfolio Category', 'finbuzz-core' ),
		'plural_title' => __( 'Portfolio Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_portfolio',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['portfolio_cat_slug'] ),
	),
	'finbuzz_testimonial_category' => array(
		'title'        => __( 'Testimonial Category', 'finbuzz-core' ),
		'plural_title' => __( 'Testimonial Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_testim',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['testim_cat_slug'] ),
	),
	'finbuzz_gallery_category' => array(
		'title'        => __( 'Gallery Category', 'finbuzz-core' ),
		'plural_title' => __( 'Gallery Categories', 'finbuzz-core' ),
		'post_types'   => 'finbuzz_gallery',
		'rewrite'      => array( 'slug' => FinbuzzTheme::$options['gallery_cat_slug'] ),
	),
);

$Posts = RT_Posts::getInstance();
$Posts->add_post_types( $post_types );
$Posts->add_taxonomies( $taxonomies );