<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\finbuzz\Customizer\Settings;

use radiustheme\finbuzz\Customizer\FinbuzzTheme_Customizer;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Switch_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Heading_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Image_Radio_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class FinbuzzTheme_Footer_Settings extends FinbuzzTheme_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_footer_controls' ) );
	}

    public function register_footer_controls( $wp_customize ) {
		
		// Footer off & on
		$wp_customize->add_setting( 'footer_area',
            array(
                'default' => $this->defaults['footer_area'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'footer_area',
            array(
                'label' => __( 'Footer On/Off', 'finbuzz' ),
                'section' => 'footer_section',
            )
        ) );

        //Footer Top Logo showcase

        $wp_customize->add_setting( 'footer_top_logo_area',
            array(
                'default' => $this->defaults['footer_top_logo_area'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'footer_top_logo_area',
            array(
                'label' => __( 'Logo Showcase Area On/Off', 'finbuzz' ),
                'section' => 'footer_section',
            )
        ) );
		
        // Footer Style
        $wp_customize->add_setting( 'footer_style',
            array(
                'default' => $this->defaults['footer_style'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization'
            )
        );

        $wp_customize->add_control( new Customizer_Image_Radio_Control( $wp_customize, 'footer_style',
            array(
                'label' => __( 'Footer Layout', 'finbuzz' ),
                'description' => esc_html__( 'You can set default footer form here.', 'finbuzz' ),
                'section' => 'footer_section',
                'choices' => finbuzz_footer_layout()
            )
        ) );
		// Footer column
		$wp_customize->add_setting( 'footer_column_1',
            array(
                'default' => $this->defaults['footer_column_1'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization',
                'active_callback' => 'rttheme_is_footer1_enabled',
            )
        );
        $wp_customize->add_control( 'footer_column_1',
            array(
                'label' => __( 'Number of Columns for Footer', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'select',
                'choices' => array(
                    '1' => esc_html__( '1 Column', 'finbuzz' ),
                    '2' => esc_html__( '2 Columns', 'finbuzz' ),
                    '3' => esc_html__( '3 Columns', 'finbuzz' ),
                    '4' => esc_html__( '4 Columns', 'finbuzz' ),
                ),
                'active_callback' => 'rttheme_is_footer1_enabled',
            )
        );

        // Footer column
		$wp_customize->add_setting( 'footer_column_2',
        array(
            'default' => $this->defaults['footer_column_2'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_radio_sanitization',
            'active_callback' => 'rttheme_is_footer2_enabled',
        )
        );
        $wp_customize->add_control( 'footer_column_2',
            array(
                'label' => __( 'Number of Columns for Footer', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'select',
                'choices' => array(
                    '1' => esc_html__( '1 Column', 'finbuzz' ),
                    '2' => esc_html__( '2 Columns', 'finbuzz' ),
                    '3' => esc_html__( '3 Columns', 'finbuzz' ),
                    '4' => esc_html__( '4 Columns', 'finbuzz' ),
                ),
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );

        // Footer column
		$wp_customize->add_setting( 'footer_column_3',
            array(
                'default' => $this->defaults['footer_column_3'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization',
                'active_callback' => 'rttheme_is_f3_f4_f5_enabled',
            )
        );
        $wp_customize->add_control( 'footer_column_3',
            array(
                'label' => __( 'Number of Columns for Footer', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'select',
                'choices' => array(
                    '1' => esc_html__( '1 Column', 'finbuzz' ),
                    '2' => esc_html__( '2 Columns', 'finbuzz' ),
                    '3' => esc_html__( '3 Columns', 'finbuzz' ),
                    '4' => esc_html__( '4 Columns', 'finbuzz' ),
                ),
                'active_callback' => 'rttheme_is_f3_f4_f5_enabled',
            )
        );
		// Footer bgtype
		$wp_customize->add_setting( 'footer_bgtype',
            array(
                'default' => $this->defaults['footer_bgtype'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization',
                'active_callback' => 'rttheme_is_footer1_footer2_enabled',
            )
        );
        $wp_customize->add_control( 'footer_bgtype',
            array(
                'label' => __( 'Banner Background Type', 'finbuzz' ),
                'section' => 'footer_section',
                'description' => esc_html__( 'This is banner background type.', 'finbuzz' ),
                'type' => 'select',
                'active_callback' => 'rttheme_is_footer1_footer2_enabled',
                'choices' => array(
					'fbgcolor' => esc_html__( 'BG Color', 'finbuzz' ),
                    'fbgimg' => esc_html__( 'BG Image', 'finbuzz' ),
                ),
            )
        );
		// Footer background color
        $wp_customize->add_setting('fbgcolor', 
            array(
                'default' => $this->defaults['fbgcolor'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
                'active_callback' => 'rttheme_footer1_footer2_bgcolor_type_condition',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'fbgcolor',
            array(
                'label' => esc_html__('Footer Background Color', 'finbuzz'),
                'settings' => 'fbgcolor', 
                'section' => 'footer_section', 
                'active_callback' => 'rttheme_footer1_footer2_bgcolor_type_condition',
            )
        ));
        // Footer overley color
        $wp_customize->add_setting('foverlay', 
            array(
                'default' => $this->defaults['foverlay'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
                'active_callback' => 'rtheme_footer3_bg_image_condition',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'foverlay',
            array(
                'label' => esc_html__('Footer Overlay Color', 'finbuzz'),
                'settings' => 'foverlay', 
                'section' => 'footer_section', 
                'active_callback' => 'rtheme_footer3_bg_image_condition',
            )
        ));
		// Footer background image
		$wp_customize->add_setting( 'fbgimg',
            array(
                'default' => $this->defaults['fbgimg'],
                'transport' => 'refresh',
                'sanitize_callback' => 'absint',
                'active_callback' => 'rttheme_footer1_footer2_bgimg_type_condition',
            )
        );
        $wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'fbgimg',
            array(
                'label' => __( 'Footer Background Image', 'finbuzz' ),
                'description' => esc_html__( 'This is the description for the Media Control', 'finbuzz' ),
                'section' => 'footer_section',
                'mime_type' => 'image',
                'button_labels' => array(
                    'select' => __( 'Select File', 'finbuzz' ),
                    'change' => __( 'Change File', 'finbuzz' ),
                    'default' => __( 'Default', 'finbuzz' ),
                    'remove' => __( 'Remove', 'finbuzz' ),
                    'placeholder' => __( 'No file selected', 'finbuzz' ),
                    'frame_title' => __( 'Select File', 'finbuzz' ),
                    'frame_button' => __( 'Choose File', 'finbuzz' ),
                ),
                'active_callback' => 'rttheme_footer1_footer2_bgimg_type_condition',
            )
        ) );

    //footer 3 bg type and bg color and image
    
    // Footer bgtype
        $wp_customize->add_setting( 'footer3_bgtype',
            array(
                'default' => $this->defaults['footer3_bgtype'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization',
                'active_callback' => 'rttheme_is_footer3_enabled',
            )
        );
        $wp_customize->add_control( 'footer3_bgtype',
            array(
                'label' => __( 'Banner Background Type', 'finbuzz' ),
                'section' => 'footer_section',
                'description' => esc_html__( 'This is banner background type.', 'finbuzz' ),
                'type' => 'select',
                'active_callback' => 'rttheme_is_footer3_enabled',
                'choices' => array(
                    'f3bgcolor' => esc_html__( 'BG Color', 'finbuzz' ),
                    'f3bgimg' => esc_html__( 'BG Image', 'finbuzz' ),
                ),
            )
        );
        // Footer background color
        $wp_customize->add_setting('f3bgcolor', 
            array(
                'default' => $this->defaults['f3bgcolor'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
                'active_callback' => 'rtheme_footer3_bg_color_condition',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'f3bgcolor',
            array(
                'label' => esc_html__('Footer Background Color', 'finbuzz'),
                'settings' => 'f3bgcolor', 
                'section' => 'footer_section', 
                'active_callback' => 'rtheme_footer3_bg_color_condition',
            )
        ));
        // Footer background image
		$wp_customize->add_setting( 'f3bgimg',
            array(
                'default' => $this->defaults['f3bgimg'],
                'transport' => 'refresh',
                'sanitize_callback' => 'absint',
                'active_callback' => 'rtheme_footer3_bg_image_condition',
            )
        );
        $wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'f3bgimg',
            array(
                'label' => __( 'Footer Background Image', 'finbuzz' ),
                'description' => esc_html__( 'This is the description for the Media Control', 'finbuzz' ),
                'section' => 'footer_section',
                'mime_type' => 'image',
                'button_labels' => array(
                    'select' => __( 'Select File', 'finbuzz' ),
                    'change' => __( 'Change File', 'finbuzz' ),
                    'default' => __( 'Default', 'finbuzz' ),
                    'remove' => __( 'Remove', 'finbuzz' ),
                    'placeholder' => __( 'No file selected', 'finbuzz' ),
                    'frame_title' => __( 'Select File', 'finbuzz' ),
                    'frame_button' => __( 'Choose File', 'finbuzz' ),
                ),
                'active_callback' => 'rtheme_footer3_bg_image_condition',
            )
        ) );

        // Footer 4,5 background color
        $wp_customize->add_setting('f4bgcolor', 
            array(
                'default' => $this->defaults['f4bgcolor'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
                'active_callback' => 'rttheme_is_footer4_footer5_enabled',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'f4bgcolor',
            array(
                'label' => esc_html__('Footer Background Color', 'finbuzz'),
                'settings' => 'f4bgcolor', 
                'section' => 'footer_section', 
                'active_callback' => 'rttheme_is_footer4_footer5_enabled',
            )
        ));

        // Footer 4 bottom  background color
        $wp_customize->add_setting('f4bg_bottom_color', 
            array(
                'default' => $this->defaults['f4bg_bottom_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
                'active_callback' => 'rttheme_is_footer4_enabled',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'f4bg_bottom_color',
            array(
                'label' => esc_html__('Footer Bottom Background Color', 'finbuzz'),
                'settings' => 'f4bg_bottom_color', 
                'section' => 'footer_section', 
                'active_callback' => 'rttheme_is_footer4_enabled',
            )
        ));
		
		// Footer shape
		$wp_customize->add_setting( 'footer_shape',
            array(
                'default' => $this->defaults['footer_shape'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
				'active_callback' => 'rttheme_is_footer1_footer5_enabled',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'footer_shape',
            array(
                'label' => __( 'Footer Shape', 'finbuzz' ),
                'section' => 'footer_section',
				'active_callback' => 'rttheme_is_footer1_footer5_enabled',
            )
        ) );
		
		$wp_customize->add_setting('footer_title_color', 
            array(
                'default' => $this->defaults['footer_title_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_title_color',
            array(
                'label' => esc_html__('Footer Title Color', 'finbuzz'),
                'section' => 'footer_section', 
            )
        ));
		
		$wp_customize->add_setting('footer_color', 
            array(
                'default' => $this->defaults['footer_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_color',
            array(
                'label' => esc_html__('Footer Text Color', 'finbuzz'),
                'section' => 'footer_section', 
            )
        ));
		
		$wp_customize->add_setting('footer_link_color', 
            array(
                'default' => $this->defaults['footer_link_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_link_color',
            array(
                'label' => esc_html__('Footer Link Color', 'finbuzz'),
                'section' => 'footer_section', 
            )
        ));
		
		$wp_customize->add_setting('footer_link_hover_color', 
            array(
                'default' => $this->defaults['footer_link_hover_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_link_hover_color',
            array(
                'label' => esc_html__('Footer Link Hover Color', 'finbuzz'),
                'section' => 'footer_section', 
            )
        ));

        // Footer Address 1
        $wp_customize->add_setting('address_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
            'active_callback' => 'rttheme_is_footer2_enabled',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'address_heading', array(
            'label' => __( 'Footer Address 1 Information', 'finbuzz' ),
            'section' => 'footer_section',
            'active_callback' => 'rttheme_is_footer2_enabled',
        )));

        $wp_customize->add_setting( 'address1_title',
            array(
                'default' => $this->defaults['address1_title'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );
        $wp_customize->add_control( 'address1_title',
            array(
                'label' => __( 'Footer Address Title', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'text',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );

        $wp_customize->add_setting( 'footer_address1',
            array(
                'default' => $this->defaults['footer_address1'],
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );
        $wp_customize->add_control( 'footer_address1',
            array(
                'label' => __( 'Footer Address', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'textarea',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );

        // Footer Address 2
        $wp_customize->add_setting('address_heading2', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
            'active_callback' => 'rttheme_is_footer2_enabled',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'address_heading2', array(
            'label' => __( 'Footer Address 2 Information', 'finbuzz' ),
            'section' => 'footer_section',
            'active_callback' => 'rttheme_is_footer2_enabled',
        )));

        $wp_customize->add_setting( 'address2_title',
        array(
            'default' => $this->defaults['address2_title'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_text_sanitization',
            'active_callback' => 'rttheme_is_footer2_enabled',
        )
        );
        $wp_customize->add_control( 'address2_title',
            array(
                'label' => __( 'Footer Address Title', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'text',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );
        $wp_customize->add_setting( 'footer_address2',
            array(
                'default' => $this->defaults['footer_address2'],
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_textarea_field',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );
        $wp_customize->add_control( 'footer_address2',
            array(
                'label' => __( 'Footer Address', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'textarea',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );

        // Footer Address 3
        $wp_customize->add_setting('address_heading3', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
            'active_callback' => 'rttheme_is_footer2_enabled',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'address_heading3', array(
            'label' => __( 'Footer Address 3 Information', 'finbuzz' ),
            'section' => 'footer_section',
            'active_callback' => 'rttheme_is_footer2_enabled',
        )));

        $wp_customize->add_setting( 'address3_title',
        array(
            'default' => $this->defaults['address3_title'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_text_sanitization',
            'active_callback' => 'rttheme_is_footer2_enabled',
        )
        );
        $wp_customize->add_control( 'address3_title',
            array(
                'label' => __( 'Footer Address Title', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'text',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );
        $wp_customize->add_setting( 'footer_address3',
            array(
                'default' => $this->defaults['footer_address3'],
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_textarea_field',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );
        $wp_customize->add_control( 'footer_address3',
            array(
                'label' => __( 'Footer Address', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'textarea',
                'active_callback' => 'rttheme_is_footer2_enabled',
            )
        );
        
		// Copyright Text
        $wp_customize->add_setting( 'copyright_text',
            array(
                'default' => $this->defaults['copyright_text'],
                'transport' => 'refresh',
                'sanitize_callback' => 'sanitize_textarea_field'
            )
        );
        $wp_customize->add_control( 'copyright_text',
            array(
                'label' => __( 'Copyright Text', 'finbuzz' ),
                'section' => 'footer_section',
                'type' => 'textarea',
            )
        );

    }

}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new FinbuzzTheme_Footer_Settings();
}
