<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

use Elementor\Plugin; 


function finbuzz_get_maybe_rtl( $filename ){
	$file = get_template_directory_uri() . '/assets/';
	if ( is_rtl() ) {
		return $file . 'rtl-css/' . $filename;
	}
	else {
		return $file . 'css/' . $filename;
	}
}
add_action( 'wp_enqueue_scripts','finbuzz_enqueue_high_priority_scripts', 1500 );
function finbuzz_enqueue_high_priority_scripts() {
	if ( is_rtl() ) {
		wp_enqueue_style( 'rtlcss', FINBUZZ_CSS_URL . 'rtl.css', array(), FINBUZZ_VERSION );
	}
}


//elementor animation dequeue
add_action('elementor/frontend/after_enqueue_scripts', function(){
    wp_deregister_style( 'e-animations' );
    wp_dequeue_style( 'e-animations' );
});



add_action( 'wp_enqueue_scripts', 'finbuzz_register_scripts', 12 );
if ( !function_exists( 'finbuzz_register_scripts' ) ) {
	function finbuzz_register_scripts(){
		wp_deregister_style( 'font-awesome' );
        wp_deregister_style( 'layerslider-font-awesome' );
        wp_deregister_style( 'yith-wcwl-font-awesome' );

		/*CSS*/
				
		wp_register_style( 'magnific-popup',     finbuzz_get_maybe_rtl('magnific-popup.css'), array(), FINBUZZ_VERSION );
		wp_register_style( 'animate',        	 finbuzz_get_maybe_rtl('animate.min.css'), array(), FINBUZZ_VERSION );
		
		//slick slider
		wp_register_style( 'slick',        	 finbuzz_get_maybe_rtl('slick.css'), array(), FINBUZZ_VERSION );
		wp_register_style( 'slick-theme',    finbuzz_get_maybe_rtl('slick-theme.css'), array(), FINBUZZ_VERSION );
	

		
		wp_register_script( 'appear',         	 FINBUZZ_JS_URL . 'appear.min.js', array( 'jquery' ), FINBUZZ_VERSION, true );


		//piechart
		wp_register_script( 'easypiechart', FINBUZZ_JS_URL . 'jquery.easypiechart.min.js', array( 'jquery'), FINBUZZ_VERSION, true );

		wp_register_script( 'rt-parallax',   	 FINBUZZ_JS_URL . 'rt-parallax.js', array( 'jquery' ), FINBUZZ_VERSION, true );

		// magnific popup
		wp_register_script( 'magnific-popup',    FINBUZZ_JS_URL . 'jquery.magnific-popup.min.js', array( 'jquery' ), FINBUZZ_VERSION, true );
		// theia sticky
		wp_register_script( 'theia-sticky',    	 FINBUZZ_JS_URL . 'theia-sticky-sidebar.min.js', array( 'jquery' ), FINBUZZ_VERSION, true );
		
		wp_register_script( 'isotope-pkgd',      FINBUZZ_JS_URL . 'isotope.pkgd.min.js', array( 'jquery' ), FINBUZZ_VERSION, true );
		
		//slick slider
		wp_register_script( 'slick',      FINBUZZ_JS_URL . 'slick.min.js', array( 'jquery' ), FINBUZZ_VERSION, true );

		// wow js
		wp_register_script( 'rt-wow',   		 FINBUZZ_JS_URL . 'wow.min.js', array( 'jquery' ), FINBUZZ_VERSION, true );

		wp_register_script( 'swiper',   		 FINBUZZ_JS_URL . 'swiper.min.js', array( 'jquery' ), FINBUZZ_VERSION, true );
	}
}

add_action( 'wp_enqueue_scripts', 'finbuzz_enqueue_scripts', 15 );
if ( !function_exists( 'finbuzz_enqueue_scripts' ) ) {
	function finbuzz_enqueue_scripts() {
		$dep = array( 'jquery' );
		/*CSS*/
		// Google fonts
		wp_enqueue_style( 'finbuzz-gfonts', 		FinbuzzTheme_Helper::fonts_url(), array(), FINBUZZ_VERSION );
		// Bootstrap CSS  //@rtl
		wp_enqueue_style( 'bootstrap', 			finbuzz_get_maybe_rtl('bootstrap.min.css'), array(), FINBUZZ_VERSION );
		
		// Flaticon CSS
		wp_enqueue_style( 'flaticon-finbuzz',    FINBUZZ_ASSETS_URL . 'fonts/flaticon-finbuzz/flaticon.css', array(), FINBUZZ_VERSION );

		elementor_scripts();
		//Video popup
		wp_enqueue_style( 'magnific-popup' );
		// font-awesome CSS
		wp_enqueue_style( 'font-awesome',       FINBUZZ_CSS_URL . 'font-awesome.min.css', array(), FINBUZZ_VERSION );
		// animate CSS
		wp_enqueue_style( 'animate',            finbuzz_get_maybe_rtl('animate.min.css'), array(), FINBUZZ_VERSION );

		// main CSS // @rtl
		wp_enqueue_style( 'finbuzz-default',    	finbuzz_get_maybe_rtl('default.css'), array(), FINBUZZ_VERSION );
		// vc modules css
		wp_enqueue_style( 'finbuzz-elementor',   finbuzz_get_maybe_rtl('elementor.css'), array(), FINBUZZ_VERSION );


		wp_enqueue_style( 'finbuzz-rt-animate',   finbuzz_get_maybe_rtl('rt-animate.css'), array(), FINBUZZ_VERSION );
			
		// Style CSS
		wp_enqueue_style( 'finbuzz-style',     	finbuzz_get_maybe_rtl('style.css'), array(), FINBUZZ_VERSION );
		
		// Template Style
		wp_add_inline_style( 'finbuzz-style',finbuzz_template_style() );

		/*JS*/
		wp_enqueue_script( 'isotope-pkgd' );

	
		// bootstrap js
		wp_enqueue_script( 'bootstrap',         FINBUZZ_JS_URL . 'bootstrap.min.js', array( 'jquery' ), FINBUZZ_VERSION, true );
		
		// Comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
		
		wp_enqueue_script( 'theia-sticky' );
		wp_enqueue_script( 'magnific-popup' );
		wp_enqueue_script( 'rt-wow' );
		wp_enqueue_script( 'rt-parallax' );
		wp_enqueue_script( 'appear' );
		wp_enqueue_script( 'masonry' );
		wp_enqueue_script( 'easypiechart' );
		wp_enqueue_script( 'swiper' );
		wp_enqueue_script( 'finbuzz-main',    	FINBUZZ_JS_URL . 'main.js', $dep , FINBUZZ_VERSION, true );
		
		if( !empty( FinbuzzTheme::$options['logo'] ) ) {
			$logo_dark = wp_get_attachment_image( FinbuzzTheme::$options['logo'], 'full' );
			$logo = $logo_dark;
		}else {
			$logo = "<img width='92' height='39' loading='lazy' class='logo-small' src='" . FINBUZZ_IMG_URL . 'logo.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "'>"; 
		}
		
		// info menu bar
		$html = '';
		ob_start();
		get_template_part( 'template-parts/header/icon', 'menubar' );
		$html .= ob_get_clean();
		
		// localize script
		$finbuzz_localize_data = array(
			'stickyMenu' 	=> FinbuzzTheme::$options['sticky_menu'],
			'meanWidth'    => FinbuzzTheme::$options['resmenu_width'],
			'siteLogo'   	=> '<a href="' . esc_url( home_url( '/' ) ) . '" alt="' . esc_attr( get_bloginfo( 'title' ) ) . '">' . esc_html ( $logo ) . '</a>' . $html,
			'extraOffset' => FinbuzzTheme::$options['sticky_menu'] ? 70 : 0,
			'extraOffsetMobile' => FinbuzzTheme::$options['sticky_menu'] ? 52 : 0,
			'rtl' => is_rtl()?'yes':'no',
			
			// Ajax
			'ajaxURL' => admin_url('admin-ajax.php'),
			'nonce' => wp_create_nonce( 'finbuzz-nonce' )
		);
		wp_localize_script( 'finbuzz-main', 'finbuzzObj', $finbuzz_localize_data );
	}	
}

function elementor_scripts() {
	
	if ( !did_action( 'elementor/loaded' ) ) {
		return;
	}
	
	if ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
		// do stuff for preview
		wp_enqueue_style(  'slick' );
		wp_enqueue_style(  'slick-theme' );
		wp_enqueue_script( 'appear' );		
		wp_enqueue_script( 'rt-wow' );
		wp_enqueue_script( 'isotope-pkgd' );
		wp_enqueue_script( 'slick' );
		wp_enqueue_script( 'masonry' );
		wp_enqueue_script( 'easypiechart' );
	} 
}

add_action( 'wp_enqueue_scripts', 'finbuzz_high_priority_scripts', 1500);
if ( !function_exists( 'finbuzz_high_priority_scripts' ) ) {
	function finbuzz_high_priority_scripts() {
		// Dynamic style
		FinbuzzTheme_Helper::dynamic_internal_style();
	}
}

function finbuzz_template_style(){
	ob_start();
	?>
	
	.entry-banner {
		<?php if ( FinbuzzTheme::$bgtype == 'bgcolor' ): ?>
			background-color: <?php echo esc_html( FinbuzzTheme::$bgcolor );?>;
		<?php else: ?>
			background-image: url(<?php echo esc_url( FinbuzzTheme::$bgimg );?>);
			background-repeat: no-repeat;
			background-size: cover;
			background-position:bottom;
		<?php endif; ?>
	}

	.content-area {
		padding-top: <?php echo esc_html( FinbuzzTheme::$padding_top );?>px; 
		padding-bottom: <?php echo esc_html( FinbuzzTheme::$padding_bottom );?>px;
	}
	<?php if( isset( FinbuzzTheme::$pagebgimg ) && !empty( FinbuzzTheme::$pagebgimg ) ) { ?>
	#page .content-area {
		background-image: url( <?php echo FinbuzzTheme::$pagebgimg; ?> );
		background-color: <?php echo FinbuzzTheme::$pagebgcolor; ?>;
	}
	<?php } ?>
	.error-page-area .error-page-content {		 
		background-color: <?php echo esc_html( FinbuzzTheme::$options['error_bodybg'] );?>;
	}
	
	<?php
	return ob_get_clean();
}

function load_custom_wp_admin_script_gutenberg() {
	wp_enqueue_style( 'finbuzz-gfonts', FinbuzzTheme_Helper::fonts_url(), array(), FINBUZZ_VERSION );
	// font-awesome CSS
	wp_enqueue_style( 'font-awesome',       FINBUZZ_CSS_URL . 'font-awesome.min.css', array(), FINBUZZ_VERSION );
	// Flaticon CSS
	wp_enqueue_style( 'flaticon-finbuzz',    FINBUZZ_ASSETS_URL . 'fonts/flaticon-finbuzz/flaticon.css', array(), FINBUZZ_VERSION );
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_script_gutenberg', 1 );

function load_custom_wp_admin_script() {
	wp_enqueue_style( 'finbuzz-admin-style',  FINBUZZ_CSS_URL . 'admin-style.css', false, FINBUZZ_VERSION );
	wp_enqueue_script( 'finbuzz-admin-main',  FINBUZZ_JS_URL . 'admin.main.js', false, FINBUZZ_VERSION, true );
	
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_script' );
