<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

global $post;

$finbuzz_team_position 		= get_post_meta( $post->ID, 'finbuzz_team_position', true );
$socials        			= get_post_meta( $post->ID, 'finbuzz_team_socials', true );
$socials        			= array_filter( $socials );
$socials_fields 			= FinbuzzTheme_Helper::team_socials();

$finbuzz_team_contact_form 	= get_post_meta( $post->ID, 'finbuzz_team_contact_form', true );

$thumb_size = 'finbuzz-size5';
?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'team-single' ); ?>>
	<div class="team-content-wrap">
		<div class="rtin-item-wrap">
			<div class="row">
				<div class="col-lg-5 col-12">
					<div class="rtin-item" >
						<div class="rtin-thums">
							<a href="<?php the_permalink();?>">
								<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size );
								}
								else {
									if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
									}
									else {
										echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_400X400.jpg' ) . '" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
									}
								}
								?>
							</a>
							<?php if ( FinbuzzTheme::$options['team_ar_social'] ) { ?>
								<div class="rtin-social">
									<ul class="rtin-social-icon">
										<?php foreach ( $socials as $key => $value ): ?>
											<li><a target="_blank" href="<?php echo esc_url( $value ); ?>"><i class="fab <?php echo esc_attr( $socials_fields[$key]['icon'] );?>"></i></a></li>
										<?php endforeach; ?>
									</ul>
								</div>
							<?php } ?>
						</div>
					</div>
				</div>
				<div class="col-lg-7 col-12">
					<div class="rtin-content single-box">
						<div class="rtin-heading">
						<h2><?php the_title( ); ?></h2>
						<?php if ( FinbuzzTheme::$options['team_ar_position'] ) { ?>
								<div class="rtin-designation"><?php echo esc_html( $finbuzz_team_position );?></div>
							<?php } ?>
						</div>
						<?php the_content();?>
					</div>
				</div>
			</div>	
		</div>
		<div class="row">
			<div class="col-lg-12">
				<?php if( FinbuzzTheme::$options['show_related_team'] == '1' && is_single() && !empty ( finbuzz_related_team() ) ) { ?>
					<div class="related-post">
						<?php echo finbuzz_related_team(); ?>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
	
</div>