<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = FinbuzzTheme_Helper::nav_menu_args();
$finbuzz_socials = FinbuzzTheme_Helper::socials();
// Logo

if( !empty( FinbuzzTheme::$options['logo'] ) ) {
	$logo_dark = wp_get_attachment_image( FinbuzzTheme::$options['logo'], 'full' );
	$finbuzz_dark_logo = $logo_dark;
}else {
	$finbuzz_dark_logo = "<img width='192' height='47' src='" . FINBUZZ_IMG_URL . 'logo-dark.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "' loading='lazy'>"; 
}

if( !empty( FinbuzzTheme::$options['logo_light'] ) ) {
	$logo_lights = wp_get_attachment_image( FinbuzzTheme::$options['logo_light'], 'full' );
	$finbuzz_light_logo = $logo_lights;
}else {
	$finbuzz_light_logo = "<img width='192' height='47' src='" . FINBUZZ_IMG_URL . 'logo-light.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "'>";
}

?>

<div class="masthead-container mobile-menu">
	<div class="header-menu">
		<div class="header-top" id="middleHeader">
			<div class="container">
				<div class="header-top-wrap">
						<div class="align-self-center">
							<div class="site-branding">
								<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_dark_logo, 'allow_link' ); ?></a>
								<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_light_logo, 'allow_link' ); ?></a>
							</div>
						</div>
						<div>
							<?php if(FinbuzzTheme::$options['top_header_text'] || FinbuzzTheme::$options		['header_team_btn'] ): ?>
								<div class="header-top-middle">
									<?php if ( FinbuzzTheme::$options['top_header_text'] ) { ?>
										<p class="item-paragraph">
											<?php echo wp_kses( FinbuzzTheme::$options['top_header_text'] , 'alltext_allow' );?>
										</p>
									<?php } ?>
									<?php if ( FinbuzzTheme::$options['header_team_btn_switch'] == '1' && !empty(FinbuzzTheme::$options['header_team_btn'])) { ?>
										<div class="header-button">
											<a target="_self"  href="<?php echo esc_url( FinbuzzTheme::$options['header_team_button_link']  );?>"><?php echo esc_html( FinbuzzTheme::$options['header_team_btn'] );?><i class="fas fa-long-arrow-alt-right"></i>
										</a>
										</div>
									<?php } ?>
								</div>
							<?php endif; ?>
						</div>
						<div class="">
							<?php if ( FinbuzzTheme::$options['phone'] || FinbuzzTheme::$options['online_button'] == '1' ) { ?> 
								<ul class="header-top-right">
									<?php if ( FinbuzzTheme::$options['phone'] ) { ?>
										<li>
											<div class="media">
												<div class="item-icon"><i class="far fa-comments"></i></div>
												<div class="media-body">
													<?php $header_hotline_txt = finbuzzTheme::$options['header_hotline_txt']; ?>
													<?php if ( !empty( $header_hotline_txt ) ){?>
														<div class="item-label"><?php echo esc_html( $header_hotline_txt ); ?> </div>
													<?php }
													else { esc_html_e( '', 'finbuzz' ); } ?>
													<a href="tel:<?php echo esc_attr( FinbuzzTheme::$options['phone'] );?>" class="item-number">
													<?php echo wp_kses( FinbuzzTheme::$options['phone'] , 'alltext_allow' );?>
													</a>
												</div>
											</div>
										</li>
									<?php } ?> 
									<?php if ( FinbuzzTheme::$options['online_button'] == '1' && !empty(FinbuzzTheme::$options['online_button_text'])) { ?>
										<li>
											<div class="header-right-button">
											<a target="_self" class="header-btn" href="<?php echo esc_url( FinbuzzTheme::$options['online_button_link']  );?>"><?php echo esc_html( FinbuzzTheme::$options['online_button_text'] );?></a>
											</div>
										</li>
								<?php } ?> 
								</ul>
							<?php } ?> 
						</div>
					</div>
			</div>
		</div>
		<div id="rt-sticky-placeholder"></div>
		<nav class="header-style-2-menu" id="header-menu">
			<div class="container">
				<div class="menu-wrap">
					<div id="site-navigation" class="main-navigation">
						<?php wp_nav_menu( $nav_menu_args );?>
					</div>
						<div class="info-wrap">
							<?php get_template_part( 'template-parts/header/icon', 'area' );?>	
						</div>
				</div>
				
			</div>
		</nav>
		
	</div>
</div>