<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = FinbuzzTheme_Helper::nav_menu_args();

// Logo

if( !empty( FinbuzzTheme::$options['logo'] ) ) {
	$logo_dark = wp_get_attachment_image( FinbuzzTheme::$options['logo'], 'full' );
	$finbuzz_dark_logo = $logo_dark;
}else {
	$finbuzz_dark_logo = "<img width='192' height='47' src='" . FINBUZZ_IMG_URL . 'logo-dark.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "' loading='lazy'>"; 
}

if( !empty( FinbuzzTheme::$options['logo_light'] ) ) {
	$logo_lights = wp_get_attachment_image( FinbuzzTheme::$options['logo_light'], 'full' );
	$finbuzz_light_logo = $logo_lights;
}else {
	$finbuzz_light_logo = "<img width='192' height='47' src='" . FINBUZZ_IMG_URL . 'logo-light.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "'>";
}

?>
<div id="rt-sticky-placeholder"></div>
<div class="header-menu menu-layout8" id="header-menu">
    <div class="header-layout8-top">
        <div class="container">
            <div class="header-top-8-wrap">
                <div class="header-top-8-left">
                    <div class="site-branding">
                        <a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_dark_logo, 'allow_link' ); ?></a>
                        <a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_light_logo, 'allow_link' ); ?></a>
                    </div>
                </div>
                <div  class="header-info-wrap">
                        <?php if ( FinbuzzTheme::$options['address'] ) { ?>
                            <div class="info-address  single-info"><span class="info-text"><i class="flaticon-pin"></i><?php echo wp_kses( FinbuzzTheme::$options['address'] , 'alltext_allow' );?></div>
                        <?php } ?>
                        <?php if ( FinbuzzTheme::$options['email'] ) { ?>
                            <div class="info-email single-info"><span class="info-text"><i class="flaticon-big-envelope"></i><a href="mailto:<?php echo esc_attr( FinbuzzTheme::$options['email'] );?>"><?php echo wp_kses( FinbuzzTheme::$options['email'] , 'alltext_allow' );?></a></span></div>
                        <?php } ?>
                        <?php if ( FinbuzzTheme::$options['phone'] ) { ?>
                            <div class="info-phone "><span class="info-text"><i class="flaticon-telephone"></i><a href="tel:<?php echo esc_attr(FinbuzzTheme::$options['phone']) ?>"><?php echo wp_kses( FinbuzzTheme::$options['phone'] , 'alltext_allow' ); ?></a></span></div>
                        <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <nav class="header-style-8-menu">
        <div class="container">
            <div class="menu-wrap">
                <div id="site-navigation" class="main-navigation">
                    <?php wp_nav_menu( $nav_menu_args );?>
                </div>
                <div class="info-wrap">
                    <?php if ( FinbuzzTheme::$options['online_button'] == '1' ) { ?>
                    <div class="header-3-right">
                        <div class="header-button">
                        <i class="flaticon-calendar"></i><a class="button-btn" target="_self" href="<?php echo esc_url( FinbuzzTheme::$options['online_button_link']  );?>"><?php echo esc_html( FinbuzzTheme::$options['online_button_text'] );?></a>
                        </div>
                    </div>
                    <?php } ?>
                    <div class="header-icon-area">
                        <?php	
                            if ( FinbuzzTheme::$options['search_icon'] ) { ?>
                                <div class="search-icon">
                                    <a href="#header-search" title="<?php echo esc_attr('Search','finbuzz'); ?>">
                                        <i class="flaticon-magnifiying-glass"></i>
                                    </a>
                                </div>
                            <?php }
                            if ( FinbuzzTheme::$options['vertical_menu_icon']){
                                get_template_part( 'template-parts/header/icon-menu', '2' );
                            }
                        ?>	
                    </div>
                </div>
            </div>
        </div>
    </nav>
    
</div>
