<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
$finbuzz_socials = FinbuzzTheme_Helper::socials();

// Logo
if ( !empty( FinbuzzTheme::$options['logo'] ) ) {
    $logo_dark = wp_get_attachment_image( FinbuzzTheme::$options['logo'], 'full' );
    $finbuzz_dark_logo = $logo_dark;
} else {
    $finbuzz_dark_logo = "<img width='192' height='47' src='" . FINBUZZ_IMG_URL . 'logo-dark.svg' . "' alt='" . esc_attr( get_bloginfo( 'name' ) ) . "' loading='lazy'>";
}

?>

<div class="additional-menu-area">
	<div class="sidenav">
		<a href="#" class="closebtn"><i class="fas fa-times"></i></a>
		<div class="additional-logo">
			<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php echo wp_kses( $finbuzz_dark_logo, 'allow_link' ); ?></a>
		</div>
		<?php if(is_active_sidebar( 'offcanvas' )){
				dynamic_sidebar( 'offcanvas' );
			  }
		?>
		<div class="sidenav-address">
			<?php if ( $finbuzz_socials ) {?>
				<h4><?php esc_html_e( 'Follow Me', 'finbuzz' );?></h4>
				<div class="sidenav-social">
					<?php foreach ( $finbuzz_socials as $finbuzz_social ): ?>
						<span><a target="_blank" href="<?php echo esc_url( $finbuzz_social['url'] ); ?>"><i class="fab <?php echo esc_attr( $finbuzz_social['icon'] ); ?>"></i></a></span>
					<?php endforeach;?>
				</div>
			<?php }
		?>
		</div>
	</div>
	<span class="side-menu-open side-menu-trigger">
        <span></span>
		<span></span>
		<span></span>
		<span></span>
	</span>
</div>