<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
}
//image
if ( $attr ) {
  $getimg = '<a ' . $attr . '>' .Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'rt_image' ).'</a>';
}
else {
	$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'rt_image' );
}

$mouse_follow_effect="";
if($data['mouse_follow']=='yes'){
    $mouse_follow_effect="motion-effects-wrap";
}
?>

<div class="image-default rt-animate wow fadeInDown image-<?php echo esc_attr( $data['style'] );?> <?php echo esc_attr( $mouse_follow_effect); ?>" data-wow-delay=".2s">
	<div class="image-box">
		<ul class="image-shape d-none d-xl-block">
			<li class="motion-effects2">
				<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape12.png'; ?>" width="376" height="77" alt="">
			</li>
            <li class="motion-effects3">
				<img src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape13.png'; ?>" width="131" height="122" alt="">
			</li>
		</ul>
		<?php echo wp_kses_post($getimg);?>
	</div>
</div>