<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
}
//title url

$title_attr = '';
if ( !empty( $data['title_url']['url'] ) ) {
	$title_attr  = 'href="' . $data['title_url']['url'] . '"';
	$title_attr .= !empty( $data['title_url']['is_external'] ) ? ' target="_blank"' : '';
	$title_attr .= !empty( $data['title_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $title_attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
}

// icon , image
if ( $attr ) {
  $getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'icon_image');
}
else {
	$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'icon_image' );
}

$final_icon_class       = " fas fa-thumbs-up";
$final_icon_image_url   = '';
if ( is_string( $icon_class['value'] ) && $dynamic_icon_class =  $icon_class['value']  ) {
  $final_icon_class     = $dynamic_icon_class;
}
if ( is_array( $icon_class['value'] ) ) {
  $final_icon_image_url = $icon_class['value']['url'];
}

?>
<div class="info-box info-<?php echo esc_attr( $data['style'] );?>">
	<div class="info-item  media-<?php echo esc_attr( $data['icontype'] );?>">
		<div class="info-content media-body">
		   <div class="icon-circle-box">
			   <div class="circle-image">
			   		<svg width="180" height="180" viewBox="0 0 180 180" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path fill-rule="evenodd" clip-rule="evenodd" d="M90 177C138.049 177 177 138.049 177 90C177 41.9512 138.049 3 90 3C41.9512 3 3 41.9512 3 90C3 138.049 41.9512 177 90 177ZM90 180C139.706 180 180 139.706 180 90C180 40.2944 139.706 0 90 0C40.2944 0 0 40.2944 0 90C0 139.706 40.2944 180 90 180Z" fill="#FE5514"/>
					<path d="M153 22C153 25.866 149.866 29 146 29C142.134 29 139 25.866 139 22C139 18.134 142.134 15 146 15C149.866 15 153 18.134 153 22Z" fill="#FE5514"/>
					<path fill-rule="evenodd" clip-rule="evenodd" d="M146 29C149.866 29 153 25.866 153 22C153 18.134 149.866 15 146 15C142.134 15 139 18.134 139 22C139 25.866 142.134 29 146 29ZM146 32C151.523 32 156 27.5228 156 22C156 16.4772 151.523 12 146 12C140.477 12 136 16.4772 136 22C136 27.5228 140.477 32 146 32Z" fill="white"/>
					<path d="M27 144C27 147.866 23.866 151 20 151C16.134 151 13 147.866 13 144C13 140.134 16.134 137 20 137C23.866 137 27 140.134 27 144Z" fill="#FE5514"/>
					<path fill-rule="evenodd" clip-rule="evenodd" d="M20 151C23.866 151 27 147.866 27 144C27 140.134 23.866 137 20 137C16.134 137 13 140.134 13 144C13 147.866 16.134 151 20 151ZM20 154C25.5228 154 30 149.523 30 144C30 138.477 25.5228 134 20 134C14.4772 134 10 138.477 10 144C10 149.523 14.4772 154 20 154Z" fill="white"/>
					</svg>
					<?php if ( !empty( $data['icontype']== 'image') ) { ?>
					<?php if($getimg){ ?>	
						<div class="icon-image">  
								<span class="info-img"><?php echo wp_kses_post($getimg);?></span>  
						</div>
					<?php }  ?>	
					<?php } else{?> 	
						<div class="icon-body">
							<?php if ( $final_icon_image_url ): ?>
								<span class="info-icon"><img src="<?php echo esc_url( $final_icon_image_url ); ?>" alt="SVG Icon"></span>
							<?php else: ?>
								<span class="info-icon"><i class="<?php  echo esc_attr( $final_icon_class ); ?>"></i></span>
							<?php endif ?>
						</div>
					<?php }  ?>
			   </div>
			</div>		
			<?php if ( !empty( $data['title'] ) ) { ?>
				<h3 class="info-title"><?php echo wp_kses_post( $title );?></h3>
			<?php } ?>
			<?php if ( !empty( $data['content'] && $data['info_excerpt_display']=='yes' ) ) { ?>
				<p class="info-text">
					<?php echo wp_kses_post( $data['content'] ); ?>
			    </p>
			<?php  } ?>
		</div>
	</div>
</div>