<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}

$number_of_post = $data['itemnumber'];
$post_soserviceg = $data['orderby'];
$post_ordering = $data['post_ordering'];
$title_count = $data['title_count'];	
$cat_single_grid = $data['cat_single'];
$args = array(
	'post_type' 		=> 'finbuzz_service',
	'post_status' 		=> 'publish',
	'orderby' 			=> $post_soserviceg,
	'order' 			=> $post_ordering,
	'posts_per_page' 	=> $number_of_post,
	'paged'          	=> $paged,
);

if ( $cat_single_grid != 0 ) {
	$args['tax_query'] = array (
		array (
			'taxonomy' => 'finbuzz_service_category',
			'field'    => 'ID',
			'terms'    => $cat_single_grid,
		)
	);
}
$thumb_size = 'finbuzz-size5';

$query = new WP_Query( $args );

$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );

$col_class = "col-xl-{$data['col_xl']} col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col']}";

?>

<div class="service-default service-grid-<?php echo esc_attr( $data['layout'] );?>">
	<div class="row" >	
		<?php
			$i = $data['delay']; $j = $data['duration'];
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
				$query->the_post();			
				$service_title 		= wp_trim_words( get_the_title(), $title_count, '' );
				$finbuzz_service_icon   = get_post_meta( get_the_ID(), 'finbuzz_service_icon', true );		
		?>
		<div class="<?php echo esc_attr( $col_class ) ?> rt-grid-item ">
			<div class="service-item rt-animate <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $i );?>s" data-wow-duration="<?php echo esc_attr( $j );?>s">
				<div class="service-figure">
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
						} else {
							if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
								echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
							} else {
								echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_390X340.jpg' ) . '" alt="'.get_the_title().'">';
							}
						}
					?>
				</div>
				<div class="service-box-content">
					<div class="service-content">
						<h3 class="service-title"><a href="<?php the_permalink();?>"><?php echo esc_html($service_title);?></a></h3>
						
						<?php if($data['icon_display']){ ?>
							<div class="icon">
								<i class="<?php echo wp_kses_post( $finbuzz_service_icon );?>"></i>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<?php  $i = $i + 0.2; $j = $j + 0.2; } ?>
	<?php } ?>
	</div>
	<?php  if ( $data['more_button_display']  == 'yes' ) : ?>
		<?php if ( $data['more_button'] == 'show' ) { ?>
			<?php if ( !empty( $data['see_button_text'] ) ) { ?>
				<div class="service-more-button"><a class="btn-style1" href="<?php echo esc_url( $data['see_button_link'] );?>"><?php 	echo esc_html( $data['see_button_text'] );?></a>
				</div>
			<?php } ?>
		<?php } else { ?>
			<?php FinbuzzTheme_Helper::pagination(); ?>
		<?php } ?>
	<?php endif ; ?>	
		<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>