<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$prefix      = FINBUZZ_CORE_THEME_PREFIX;
$thumb_size  = 'full';

if ( get_query_var('paged') ) {
	$paged = get_query_var('paged');
}
else if ( get_query_var('page') ) {
	$paged = get_query_var('page');
}
else {
	$paged = 1;
}

$args = array(
	'post_type'      => 'finbuzz_team',
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
	'paged' => $paged
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'finbuzz_team_category',
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );
$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );
$col_class = "col-lg-{$data['col_lg']} col-md-{$data['col_md']} col-sm-{$data['col_sm']} col-{$data['col_xs']} col-{$data['col_mobile']}";
?>
<div class="team-default team-multi-layout-5 team-grid-<?php echo esc_attr( $data['style'] );?>">
	<div class="row auto-clear">
		<?php 
		$i = $data['delay']; $j = $data['duration'];
		if ( $query->have_posts() ) {
			while ( $query->have_posts() ) {
				$query->the_post();
				$id            = get_the_id();
				$position   	= get_post_meta( $id, 'finbuzz_team_position', true );
				$socials       = get_post_meta( $id, 'finbuzz_team_socials', true );
				$social_fields = FinbuzzTheme_Helper::team_socials();
				$content = apply_filters( 'the_content', get_the_content() );
				$content = wp_trim_words( $content, $data['count'], '' );
				$content = "<p>$content</p>";
				?>
				<div class="<?php echo esc_attr( $col_class );?>" >
					<div class="rtin-item">
						<div class="rtin-content-wrap rt-animate <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $i );?>s" data-wow-duration="<?php echo esc_attr( $j );?>s">
							<div class="rtin-thums">
							<a href="<?php the_permalink();?>">
								<?php
								if ( has_post_thumbnail() ){
									the_post_thumbnail( $thumb_size );
								}
								else {
									if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
										echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
									}
									else {
										echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_400X400.jpg' ) . '" alt="'.get_the_title().'">';
									}
								}
								?>
							</a>
								<?php if ( !empty( $socials ) && $data['social_display']  == 'yes' ) { ?>
									<ul class="rtin-social">
										<li>
											<a href="#"><i class="fas fa-share-alt"></i></a>
											<ul class="rtin-social-icon">
												<?php foreach ( $socials as $key => $social ): ?>
													<?php if ( !empty( $social ) ): ?>
														<li><a target="_blank" href="<?php echo esc_url( $social );?>"><i class="fab <?php echo esc_attr( $social_fields[$key]['icon'] );?>" aria-hidden="true"></i></a></li>
													<?php endif; ?>
												<?php endforeach; ?>
											</ul>
										</li>
									</ul>
								<?php } ?>
							</div>
							<div class="mask-wrap">
								<div class="rtin-content">
									<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
									<?php if ( $position && $data['designation_display']  == 'yes' ) { ?>
										<div class="rtin-designation"><?php echo esc_html( $position );?></div>
									<?php } ?>
									<?php if ( $data['content_display']  == 'yes' ) { ?>
										<?php echo wp_kses_post( $content );?>
									<?php } ?>	
								</div>
							</div>
						</div>
					</div>
				</div>
			<?php $i = $i + 0.2; $j = $j + 0.2; } ?>
		<?php } ?>
		<?php ?>
	</div>
	<?php  if ( $data['more_button_display']  == 'yes' ) : ?>	
		<?php if ( $data['more_button'] == 'show' ) { ?>
			<?php if ( !empty( $data['see_button_text'] ) ) { ?>
			<div class="team-button"><a class="btn-style1" href="<?php echo esc_url( $data['see_button_link'] );?>"><?php echo esc_html( $data['see_button_text'] );?></a></div>
			<?php } ?>
		<?php } else { ?>
			<?php FinbuzzTheme_Helper::pagination(); ?>
		<?php } ?>
	<?php endif; ?>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>