<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme;
use FinbuzzTheme_Helper;
use \WP_Query;

$prefix      = FINBUZZ_CORE_THEME_PREFIX;
$thumb_size  = 'finbuzz-size8';

$args = array(
	'post_type'      => 'finbuzz_team',
	'posts_per_page' => $data['number'],
	'orderby'        => $data['orderby'],
);

if ( !empty( $data['cat'] ) ) {
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'finbuzz_team_category',
			'field' => 'term_id',
			'terms' => $data['cat'],
		)
	);
}

switch ( $data['orderby'] ) {
	case 'title':
	case 'menu_order':
	$args['order'] = 'ASC';
	break;
}

$query = new WP_Query( $args );


if($data['slider_autoplay']=='yes'){
	$data['slider_autoplay']=true;
}
else{
	$data['slider_autoplay']=false;
}

$swiper_data = array(
	'slidesPerView' 	=>2,
	'loop'				=>$data['slider_loop']=='yes' ? true:false,
	'spaceBetween'		=>$data['space']['size'],
	'slidesPerGroup'	=>$data['slider_per_group']['size'],
	'centeredSlides'	=>$data['centered_slide']=='yes' ? true:false ,
	'slideToClickedSlide' =>true,
	'autoplay'				=>array(
		'delay'  => $data['autoplayspeed']['size'],
	),
	'speed'      =>$data['speed']['size'],
	'breakpoints' =>array(
		'0'    =>array('slidesPerView' =>1),
		'576'    =>array('slidesPerView' =>$data['item_mobile']['size']),
		'768'    =>array('slidesPerView' =>$data['item_tablet']['size']),
		'992'    =>array('slidesPerView' =>$data['medium_item']['size']),
		'1200'    =>array('slidesPerView' =>$data['item']['size']),				
		'1600'    =>array('slidesPerView' =>$data['item']['size'])
	),
	'auto'   =>$data['slider_autoplay']
);
$swiper_data = json_encode( $swiper_data );

$temp = FinbuzzTheme_Helper::wp_set_temp_query( $query );
?>
<div class="team-default team-multi-layout-2 team-grid-<?php echo esc_attr( $data['style'] );?>" >
    <div class="rt-related-slider" data-xld = '<?php echo $swiper_data ;?>'>
		<?php 
		$i = $data['delay']; $j = $data['duration'];
		if ( $query->have_posts() ) { ?>
			<div class="swiper-wrapper">
				<?php	while ( $query->have_posts() ) {
					$query->the_post();
					$id            = get_the_id();
					$position   	= get_post_meta( $id, 'finbuzz_team_position', true );
					$content = apply_filters( 'the_content', get_the_content() );
					$content = wp_trim_words( $content, $data['count'], '' );
					$content = "<p>$content</p>";
					?>
					<div class="swiper-slide">
						<div class="rtin-item rt-animate <?php echo esc_attr( $data['animation'] );?> <?php echo esc_attr( $data['animation_effect'] );?>" data-wow-delay="<?php echo esc_attr( $i );?>s" data-wow-duration="<?php echo esc_attr( $j );?>s">
							<div class="rtin-content-wrap">
								<div class="rtin-thums">
									<a href="<?php the_permalink();?>">
										<?php
										if ( has_post_thumbnail() ){
											the_post_thumbnail( $thumb_size );
										}
										else {
											if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
												echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
											}
											else {
												echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_400X400.jpg' ) . '" alt="'.get_the_title().'">';
											}
										}
										?>
									</a>
								</div>
								<div class="rtin-content">
									<h3 class="rtin-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
									<?php if ( $position && $data['designation_display']  == 'yes' ) { ?>
										<div class="rtin-designation"><?php echo esc_html( $position );?></div>
									<?php } ?>
									<?php if ( $data['content_display']  == 'yes' ) { ?>
										<?php echo wp_kses_post( $content );?>
									<?php } ?>
									<?php if($data['read_more_button_display']  == 'yes'){ ?>
										<div class="item-button">
											<a href="<?php the_permalink();?>" class="btn-style4">+ <span>Read More</span></a>
										</div>
									<?php } ?>	
								</div>
							</div>
						</div>
					</div>
				<?php $i = $i + 0.2; } ?>
			</div>
			<?php if($data['slider_pagination']=='yes'){ ?>
				<div class="swiper-pagination"></div>
			<?php } ?>
		<?php } ?>
		<?php ?>
	</div>
	<?php FinbuzzTheme_Helper::wp_reset_temp_query( $temp ); ?>
</div>