<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use FinbuzzTheme_Helper;
use Elementor\Group_Control_Image_Size;

//title url

$attr = '';
if ( !empty( $data['title_url']['url'] ) ) {
	$attr  = 'href="' . $data['title_url']['url'] . '"';
	$attr .= !empty( $data['title_url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['title_url']['nofollow'] ) ? ' rel="nofollow"' : '';
	$title = '<a ' . $attr . '>' . $data['title'] . '</a>';
	
}
else {
	$title = $data['title'];
}

// image
$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'video_image' );

?>
<div class="rt-video video-<?php echo esc_attr( $data['style'] );?>">
	<div class="rtin-video">
		<?php if($data['shape_display']=='yes'){?>
			<ul class="video-element-list d-none d-xl-block">
				<li>
					<img class="wow fadeInDown" data-wow-delay="400ms" data-wow-duration="1200ms" src="<?php echo FINBUZZ_ASSETS_URL . 'element/video-shape3.png'; ?>" alt="video-shape3" width="304" height="186">
				</li>
				<li>
					<img class="wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1200ms" src="<?php echo FINBUZZ_ASSETS_URL . 'element/video-shape4.png'; ?>" alt="video-shape4" width="270" height="132">
				</li>
			</ul>
		<?php } ?>
		<div class="item-img">
		<?php echo wp_kses_post($getimg);?>
		</div>
		<div class="item-content">
			<div class="title">
				<h2><?php echo wp_kses_post( $title );?></h2>
			</div>
			<a href="<?php echo esc_url($data['videourl']['url'] );?>" class="play-btn rt-video-popup">
            	<span class="play-text"><i class="fas fa-play-circle"></i><?php echo esc_attr($data['video_title']); ?></span>
        	</a>
		</div>
	</div>
</div>