<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;

class Contact_Info extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Contact Info', 'finbuzz-core' );
		$this->rt_base = 'rt-info';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'address_icon',
			 [
				'type'  => Controls_Manager::ICONS,
				'label' => esc_html__( 'Icon', 'consalty-core' ),
				'label_block' => true,
				'default' => array(
					'value' => 'fas fa-map-marker-alt',
					'library' => 'fa-solid',
				),	
				
			]
		);
		$repeater->add_control(
			'address_infos', [
				'type'  => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'label'   => esc_html__( 'Contact Info', 'finbuzz-core' ),
				'default' => '12/A, Pk House New York, US',
			]
		);
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Address Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1' , 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type' => Controls_Manager::CHOOSE,
				'id'      => 'content_align',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Alignment', 'finbuzz-core' ),
				'options' => array(
					'left' => array(
						'title' => __( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					),
					'right' => array(
						'title' => __( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					),
				),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				),
				'condition'   => array('style' => array('style1')),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'    => 'address_title',
				'label'   => esc_html__( 'Contact Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Our Office Address', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'icon',
				'label'   => esc_html__( 'Contact Icon', 'consalty-core' ),
				'default' => array(
			      'value' => 'fas fa-envelope',
			      'library' => 'fa-solid',
				),
				'condition'   => array('style' => array('style2')),
			),			
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'address_info',
				'label'   => esc_html__( 'Add Address', 'finbuzz-core' ),
				'fields' => $repeater->get_controls(),
			),
			array(
				'mode' => 'section_end',
			),			
			/*Style Option*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),			
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Contact Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .contact-info-default .contact-title',
				'condition'   => array( 'style' => array( 'style1','style2')),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Contact Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .contact-info-default .contact-title' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style1','style2')),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .contact-info-default.info-style2 .contact-info .contact-icon span i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rtin-contact-info-default.info-style3 .list-item .list-icon i' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2','style3') ),
			),			
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'info_typo',
				'label'   => esc_html__( 'Contact Info Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .contact-info-default .contact-info .list-item span ',
				'condition'   => array( 'style' => array( 'style1','style2')),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'info_color',
				'label'   => esc_html__( 'Contact Info Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .contact-info-default .contact-info .list-item span' => 'color: {{VALUE}}',
					'{{WRAPPER}} .contact-info-default .contact-info .list-item span a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rtin-contact-info-default.info-style3 .list-item .list-content' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rtin-contact-info-default.info-style3 .list-item .list-content span' => 'color: {{VALUE}}',
				),
			),
			array(
				'id'      => 'icon_f_heading',
				'type' =>        Controls_Manager::HEADING,
				'label'   => __( 'Hover', 'consalty-core' ),
				'separator' => 'before',
				'condition'   => array( 'style' => array( 'style3')),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'info_hover_color',
				'label'   => esc_html__( 'Info Hover Color', 'consalty-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rtin-contact-info-default.info-style3 .list-item:hover .list-content' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rtin-contact-info-default.info-style3 .list-item:hover .list-content span' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style3')),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_hover_color',
				'label'   => esc_html__( 'Icon Hover Color', 'consalty-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rtin-contact-info-default.info-style3 .list-item:hover .list-icon i' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style3')),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}
		
	protected function render() {
			
		$data = $this->get_settings();
		
		switch ( $data['style'] ) {
			case 'style3':
			$template = 'contact-info-3';
			break;
			case 'style2':
			$template = 'contact-info-2';
			break;
			default:
			$template = 'contact-info-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}