<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class Info_Box extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Info Box', 'finbuzz-core' );
		$this->rt_base = 'rt-info-box';
		parent::__construct( $data, $args );
	}
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
					'style4' => esc_html__( 'Style 4', 'finbuzz-core' ),
					'style5' => esc_html__( 'Style 5', 'finbuzz-core' ),
					'style6' => esc_html__( 'Style 6', 'finbuzz-core' ),
					'style7' => esc_html__( 'Style 7', 'finbuzz-core' ),
					'style8' => esc_html__( 'Style 8', 'finbuzz-core' ),
					'style9' => esc_html__( 'Style 9', 'finbuzz-core' ),
					'style10' => esc_html__( 'Style 10', 'finbuzz-core' ),
					'style11' => esc_html__( 'Style 11', 'finbuzz-core' ),
					'style12' => esc_html__( 'Style 12', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			/*Icon Start*/
			array(					 
			   'type'    => Controls_Manager::CHOOSE,
			   'options' => array(
			     'icon' => array(
			       'title' => esc_html__( 'Left', 'finbuzz-core' ),
			       'icon' => 'fa fa-smile',
			     ),
			     'image' => array(
			       'title' => esc_html__( 'Center', 'finbuzz-core' ),
			       'icon' => 'fa fa-image',
			     ),		     
			   ),
			   'id'      => 'icontype',
			   'label'   => esc_html__( 'Media Type', 'finbuzz-core' ),
			   'default' => 'icon',
			   'label_block' => false,
			   'toggle' => false,
			   'condition'   => array( 'style' => array('style2','style3','style4','style6','style7','style8','style9','style10','style12') ),
			),
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'icon_class',
				'label'   => esc_html__( 'Icon', 'finbuzz-core' ),
				'default' => array(
			      'value' => 'flaticon-suitcase',
			      'library' => 'fa-solid',
				),	
			  	'condition'   => array('icontype' => array( 'icon' ), 'style' => array('style2', 'style3','style4','style6','style7','style8','style9','style10','style12') ),
			),	
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'icon_image',
				'label'   => esc_html__( 'Image', 'finbuzz-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
				'condition'   => array('icontype' => array( 'image' ), 'style' => array('style2','style3','style4','style6','style7','style8','style9','style10','style12')),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',		
				'condition'   => array('icontype' => array( 'image' ), 'style' => array('style2','style3','style4','style6','style7','style8','style9','style10','style12') ),
			),
			array(
				'type' => Controls_Manager::CHOOSE,
				'id'      => 'content_align',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Alignment', 'finbuzz-core' ),
				'options' => array(
					'left' => array(
						'title' => __( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					),
					'right' => array(
						'title' => __( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					),
					'justify' => array(
						'title' => __( 'Justified', 'elementor' ),
						'icon' => 'eicon-text-align-justify',
					),
				),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				),
				'condition'   => array( 'style' => array('style2','style8','style10')),
			),
			/*Icon end*/

			//Info box 11 Options

			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'info_year',
				'label'   => esc_html__( 'Year', 'finbuzz-core' ),
				'default' => 25,
				'condition'   => array('style' => array('style11')),
			),

			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'info_5_title',
				'label_block' =>true,
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' =>"We’ve Year Of Experiences ",
				'condition'   => array('style' => array('style11')),
			),

			//Info box 4 Options start

			array(
				'type' => Controls_Manager::SELECT2,
				'id'      => 'border_right',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Info box border right', 'finbuzz-core' ),
				'options' => array(
					'hide' =>'Hide',
					'show' =>'Show',
				),
				'default' => 'show',
				'condition'   => array( 'style' => array('style4')),
			),
			
			//Info box 4 Options end
	
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'label_block' =>true,
				'default' => esc_html__( 'Business Investment', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'cat',
				'label_block' =>true,
				'label'   => esc_html__( 'Category', 'finbuzz-core' ),
				'default' => esc_html__( 'Business Strategy', 'finbuzz-core' ),
				'condition'   => array('style' => array('style5')),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'finbuzz-core' ),
				'default' => esc_html__( 'Your logo is the very heart of your identity designers deliver the perfect.', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style1','style2','style3','style4','style6','style7','style8','style9','style11') ),
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'info_excerpt_display',
				'label'       => esc_html__( 'Content Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
				'condition'   => array( 'style' => array('style6','style8','style9')),
			),

			/* Number Option Start*/

			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'info_number',
				'label'   => esc_html__( 'Info Number', 'finbuzz-core' ),
				'default' => esc_html__( '1', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style1','style12') ),
			),
			
			/* Number Option End*/

			/* Phone Number Option Start*/
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'phone',
				'label'   => esc_html__( 'Phone', 'finbuzz-core' ),
				'default' => esc_html__( '+1(212) 255-5511', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style10' ) ),
			),

			/* Number Option Start*/

			/**title url */
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'title_url',
				'label'   => esc_html__( 'Title URL (Optional)', 'finbuzz-core' ),
				'placeholder' => 'https://title-link.com',
				'condition'   => array( 'style' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9','style10','style12')),
			),

			/**category url */
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'cat_url',
				'label'   => esc_html__( 'Category URL (Optional)', 'finbuzz-core' ),
				'placeholder' => 'https://title-link.com',
				'condition'   => array( 'style' => array('style5' ) ),
			),

			/* Info box image background*/

			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'info_bg_image',
				'label'   => esc_html__( 'Info Image', 'finbuzz-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style1','style9') ),
			),

			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'info_bg_image_size', 
				'separator' => 'none',
				'condition'   => array( 'style' => array('style1','style9') ),		
			),

			/* Info box image background End*/
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'button_display',
				'label'       => esc_html__( 'Button Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => false,
				'description' => esc_html__( 'Show or Hide Content. Default: off', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style1','style2','style3','style4','style5','style6','style7','style9','style12') ),
			),
			array(
				'type'  => Controls_Manager::URL,
				'id'    => 'url',
				'label' => esc_html__( 'Link (Optional)', 'finbuzz-core' ),
				'placeholder' => 'https://your-link.com',
				'condition'   => array( 'button_display' => array( 'yes' ) ),
				'condition'   => array( 'style' => array('style1','style2','style3','style4','style5','style6','style7','style9','style12') ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'buttontext',
				'label'   => esc_html__( 'Button Text', 'finbuzz-core' ),
				'default' => esc_html__( 'Read More', 'finbuzz-core' ),
				'condition'   => array( 'button_display' => array( 'yes' ),'style' => array( 'style1','style2','style3','style6','style7','style9','style12') ),
			),			
		    //info box 4 circle image option
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'info_circle_image',
				'label'   => esc_html__( 'Circle Image', 'finbuzz-core' ),
				'description' => esc_html__( 'Recommended image size 81 width and 81 height and if image is not uploaded,then default will be uploaded', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style4') ),
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'info_circle_hover_image',
				'label'   => esc_html__( 'Circle Hover Image', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style4') ),
				'description' => esc_html__( 'Recommended image size 81 width and 81 height and if image is not uploaded,then default will be uploaded', 'finbuzz-core' ),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'info_circle_image_size', 
				'separator' => 'none',		
				'condition'   => array( 'style' => array('style4') ),
			),

			//info box 4 circle image option end
			 
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'info_5_image',
				'label'   => esc_html__( 'Info Image ', 'finbuzz-core' ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'condition'   => array( 'style' => array('style5' ) ),
				
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'info_5_image_size', 
				'separator' => 'none',
				'condition'   => array( 'style' => array( 'style5' ) ),		
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'info_padding',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Info Box Padding', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .info-box.info-style1 .info-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => array( 'style' => array( 'style1')),
			),
			array(
				'mode' => 'section_end',
			),
	
			/*Style Option*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_style',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9','style10','style12')),
			),
			array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .info-box .info-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .info-box .info-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .info-box .info-title a' => 'color: {{VALUE}}',
					
				),
			),
			array(
				'mode' => 'section_end',
			),

			array(
				'mode'    => 'section_start',
				'id'      => 'box_size_sec_style',
				'label'   => esc_html__( 'Info Box Size', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style8')),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'info8_box_size_width',
				'label'   => esc_html__( 'Box Size Width', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'max' => 300,
						'min' => 180,
					],
				],
				'condition'   => array( 'style' => array('style8') ),
				'selectors' => [
					'{{WRAPPER}} .info-style8 .info-item .icon-circle-box .circle-image svg' => 'width: {{SIZE}}px',
				],
				
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'info8_box_size_height',
				'label'   => esc_html__( 'Box Size Height', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'max' => 300,
						'min' => 180,
					],
				],
				'condition'   => array( 'style' => array('style8') ),
				'selectors' => [
					'{{WRAPPER}} .info-style8 .info-item .icon-circle-box .circle-image svg' => 'height: {{SIZE}}px',
				],
				
			),
			array(
				'mode' => 'section_end',
			),
			//category styel

			array(
				'mode'    => 'section_start',
				'id'      => 'sec_cat_style',
				'label'   => esc_html__( 'Category', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style5') ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'cat_typo',
				'label'   => esc_html__( 'Category Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .info-box .info-category',
				'condition'   => array( 'style' => array('style5') ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'cat_color',
				'label'   => esc_html__( 'Category Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .info-box .info-category' => 'color: {{VALUE}}',
					'{{WRAPPER}} .info-box .info-category a' => 'color: {{VALUE}}',
					
				),
				'condition'   => array( 'style' => array('style5') ),
			),
			
			array(
				'mode' => 'section_end',
			),

			// Content text style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_sub_title',
				'label'   => esc_html__( 'Content Text', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style1','style2','style3','style4','style6','style7','style8','style9','style11')),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'sub_title_typo',
				'label'   => esc_html__( 'Content Text Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .info-box .info-item .info-text',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'conent_color',
				'label'   => esc_html__( 'Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .info-box .info-item .info-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service-grid-layout1 .rtin-content .service-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .info-style11 .info-item .info-content .info-heading .ex-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .info-style11 .info-item .info-content .info-content p' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array('style1','style2','style3','style4','style6','style7','style8','style11') ),
			),
			
			array(
				'mode' => 'section_end',
			),

			//Icon Box style

			array(
				'mode'    => 'section_start',
				'id'      => 'icon_box',
				'label'   => esc_html__( 'Icon Box Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style2') ),
			),

			
			array(
				'type'    => Controls_Manager::HEADING,
				'id'      => 'heading2',
				'label'   => esc_html__( 'Use same height and width box size', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style2') )
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'icon_box_height',
				'label'       => esc_html__( 'Icon Box Height', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 150,
                        'step' => 10,
                    ],
                ],
                'size_units' => [ 'px'],
				'selectors' => array(
					'{{WRAPPER}} .info-box.info-style2 .info-item .info-media' => 'height:{{SIZE}}{{UNIT}}',
				),
				'condition'   => array( 'style' => array('style2') )
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'icon_box_width',
				'label'       => esc_html__( 'Icon Box Width', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 150,
                        'step' => 10,
                    ],
                ],
                'size_units' => [ 'px'],
				'selectors' => array(
					'{{WRAPPER}} .info-box.info-style2 .info-item .info-media' => 'width: {{SIZE}}{{UNIT}}',
				),
				'condition'   => array( 'style' =>array('style2') ),
			),	

			array(
				'mode' => 'section_end',
			),

			// Icon style
			
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_icon',
				'label'   => esc_html__( 'Icon Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style2','style3','style4','style7','style9','style10','style12') ),
			),
					
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'icon_size',
				'label'   => esc_html__( 'Icon Size', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .info-box .info-item .info-icon i' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .info-box .info-item .info-icon i:before' => 'font-size: {{VALUE}}px',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .info-box .info-item .info-icon i' => 'color: {{VALUE}}',
				),
			),
			
			array(
				'mode' => 'section_end',
			),
			// Phone text style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_phone',
				'label'   => esc_html__( 'Phone Text', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style10' ) )
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'phone_typo',
				'label'   => esc_html__( 'Phone Text Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .info-box .info-item .info-text',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'phone_text_color',
				'label'   => esc_html__( 'Phone Text Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .info-box .info-item .info-text' => 'color: {{VALUE}}',
				),
			),
			
			array(
				'mode' => 'section_end',
			),

			//info box 6 style

			// Icon style
			array(
				'mode'    => 'section_start',
				'id'      => 'info6_sec_icon',
				'label'   => esc_html__( 'Icon Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style6') ),
			),			
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'info6_icon_size',
				'label'   => esc_html__( 'Icon Size', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'max' => 50,
						'min' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .info-style6 .info-item .rtin-media .rtin-icon i' => 'font-size: {{SIZE}}px',
				],
				'condition'   => array( 'style' => array('style6')),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'info6_icon_color',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .info-style6 .info-item .rtin-media .rtin-icon i' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_box_color',
				'label'   => esc_html__( 'Icon Box Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .info-style6 .info-item .rtin-media' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			//info box 11 style
			array(
				'mode'    => 'section_start',
				'id'      => 'info_11_title_style',
				'label'   => esc_html__( 'Year Text', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style11') ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'year_typo',
				'label'   => esc_html__( 'Year Text Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .info-style11 .info-item .info-content .info-heading .ex-year',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'info_11_title_color',
				'label'   => esc_html__( 'Year Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .info-style11 .info-item .info-content .info-heading .ex-year' => 'color: {{VALUE}}',
				),	
			),
			array(
				'mode' => 'section_end',
			),

			//info box 11 shape positioning
			array(
				'mode'    => 'section_start',
				'id'      => 'info11_shape1_position',
				'label'   => esc_html__( 'Image Shape Position 1', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style11')),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'info11_left_positon',
				'label'       => esc_html__( 'Left Shape Position', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
                'default' => [
					'unit' => 'px',
					
				],
				'selectors' => array(
					'{{WRAPPER}} .info-style11 .info-item .info-box-memo li:nth-child(1)' => 'left: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'info11_top_positon',
				'label'       => esc_html__( 'Top Shape Position', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
				'selectors' => array(
					'{{WRAPPER}} .info-style11 .info-item .info-box-memo li:nth-child(1)' => 'top: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'info11_shape2_position',
				'label'   => esc_html__( 'Image Shape Position 2', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style11')),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'info11_shape2_left_positon',
				'label'       => esc_html__( 'Left Shape Position', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
                'default' => [
					'unit' => 'px',
					
				],
				'selectors' => array(
					'{{WRAPPER}} .info-style11 .info-item .info-box-memo li:nth-child(2)' => 'left: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'info11_shape2_top_positon',
				'label'       => esc_html__( 'Top Shape Position', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
				'selectors' => array(
					'{{WRAPPER}} .info-style11 .info-item .info-box-memo li:nth-child(2)' => 'top: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'info11_shape3_position',
				'label'   => esc_html__( 'Image Shape Position 3', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array( 'style11')),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'info11_shape3_right_positon',
				'label'       => esc_html__( 'Right Shape Position', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
                'default' => [
					'unit' => 'px',
					
				],
				'selectors' => array(
					'{{WRAPPER}} .info-style11 .info-item .info-box-memo li:nth-child(3)' => 'right: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'info11_shape3_top_positon',
				'label'       => esc_html__( 'Top Shape Position', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => -200,
                        'max' => 1000, 
                    ],
					'%' => [
						'min' => -50,
						'max' => 100,
					],
                ],
				'selectors' => array(
					'{{WRAPPER}} .info-style11 .info-item .info-box-memo li:nth-child(3)' => 'top: {{SIZE}}{{UNIT}}',
				),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		switch ( $data['style'] ) {
			case 'style12':
			$template = 'info-box-12';
			break;
			case 'style11':
			$template = 'info-box-11';
			break;
			case 'style10':
			$template = 'info-box-10';
			break;
			case 'style9':
			$template = 'info-box-9';
			break;
			case 'style8':
			$template = 'info-box-8';
			break;
			case 'style7':
			$template = 'info-box-7';
			break;
			case 'style6':
			$template = 'info-box-6';
			break;
			case 'style5':
			$template = 'info-box-5';
			break;
			case 'style4':
			$template = 'info-box-4';
			break;
			case 'style3':
			$template = 'info-box-3';
			break;
			case 'style2':
			$template = 'info-box-2';
			break;
			default:
			$template = 'info-box-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}