<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Portfolio extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Portfolio', 'finbuzz-core' );
		$this->rt_base = 'rt-portfolio';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => esc_html__( '1 Col', 'finbuzz-core' ),
				'6'  => esc_html__( '2 Col', 'finbuzz-core' ),
				'4'  => esc_html__( '3 Col', 'finbuzz-core' ),
				'3'  => esc_html__( '4 Col', 'finbuzz-core' ),
				'2'  => esc_html__( '6 Col', 'finbuzz-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_style(  'swiper-slider' );
		wp_enqueue_script('swiper-slider');
	}
	private function rt_load_scripts2(){
		wp_enqueue_script('isotope-pkgd');
	}
	public function rt_fields(){
		
		$terms  = get_terms( array( 'taxonomy' => 'finbuzz_portfolio_category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'Please Selecet category', 'finbuzz-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}
		
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'finbuzz-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Portfolio Layout 1', 'finbuzz-core' ),
					'layout2' => esc_html__( 'Portfolio Layout 2', 'finbuzz-core' ),
					'layout3' => esc_html__( 'Portfolio Layout 3', 'finbuzz-core' ),
					'layout4' => esc_html__( 'Portfolio Layout 4', 'finbuzz-core' ),
					'layout5' => esc_html__( 'Portfolio Layout 5', 'finbuzz-core' ),
					'layout6' => esc_html__( 'Portfolio Layout 6', 'finbuzz-core' ),
					'layout7' => esc_html__( 'Portfolio Layout 7', 'finbuzz-core' ),
					'layout8' => esc_html__( 'Portfolio Layout 8', 'finbuzz-core' ),
				),
				'default' => 'layout1',
			),
			array (
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'cat_single',
				'label'     => esc_html__( 'Categories', 'finbuzz-core' ),
				'options'   => $category_dropdown,
				'default'   => '0',
				'multiple'  => false,
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => esc_html__( 'Post Ordering', 'finbuzz-core' ),
				'options' => array(
					'DESC'	=> esc_html__( 'Desecending', 'finbuzz-core' ),
					'ASC'	=> esc_html__( 'Ascending', 'finbuzz-core' ),
				),
				'default' => 'DESC',
				'condition'   => array( 'layout' => array( 'layout1','layout2','layout4','layout5','layout6','layout7','layout8') ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Post Sorting', 'finbuzz-core' ),				
				'options' => array(
					'recent' 		=> esc_html__( 'Recent Post', 'finbuzz-core' ),
					'rand' 			=> esc_html__( 'Random Post', 'finbuzz-core' ),
					'menu_order' 	=> esc_html__( 'Custom Order', 'finbuzz-core' ),
					'title' 		=> esc_html__( 'By Name', 'finbuzz-core' ),
				),
				'default' => 'recent',
				'condition'   => array( 'layout' => array( 'layout1','layout2','layout4','layout5','layout6','layout7','layout8') ),
			),			
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_not_in',
				'label'   => esc_html__( 'Enter Post ID that will not display', 'finbuzz-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::NUMBER,
						'name'    => 'post_not_in',
						'label'   => esc_html__( 'Post ID', 'finbuzz-core' ),
						'default' => '0',
					),
				),
				'condition'   => array( 'layout' => array( 'layout1','layout2') ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'item_space',
				'label'   => esc_html__( 'Item Space', 'neeon-core' ),
				'options' => array(
					'g-0' => esc_html__( 'Gutters 0', 'neeon-core' ),
					'g-1' => esc_html__( 'Gutters 1', 'neeon-core' ),
					'g-2' => esc_html__( 'Gutters 2', 'neeon-core' ),
					'g-3' => esc_html__( 'Gutters 3', 'neeon-core' ),
					'g-4' => esc_html__( 'Gutters 4', 'neeon-core' ),
					'g-5' => esc_html__( 'Gutters 5', 'neeon-core' ),
				),
				'default' => 'g-4',
				'condition'=>array( 'layout' => array('layout1','layout2','layout3','layout6')),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'itemnumber',
				'label'   => esc_html__( 'Item Number', 'finbuzz-core' ),
				'default' => -1,
				'description' => esc_html__( 'Use -1 for showing all items( Showing items per category )', 'finbuzz-core' ),
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'port_ser_display',
				'label'       => esc_html__( 'Portfolio Serial Number Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
				'condition'   => array( 'layout' => array('layout2','layout3')),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_count',
				'label'   => esc_html__( 'Title Word count', 'finbuzz-core' ),
				'default' => 5,
				'description' => esc_html__( 'Maximum number of words', 'finbuzz-core' ),				
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'cat_display',
				'label'       => esc_html__( 'Category Name Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'excerpt_display',
				'label'       => esc_html__( 'Excerpt/Content Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
				'condition'   => array( 'layout' => array('layout2','layout3','layout5','layout7','layout8')),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'excerpt_count',
				'label'   => esc_html__( 'Word count', 'finbuzz-core' ),
				'default' => 15,
				'description' => esc_html__( 'Maximum number of words', 'finbuzz-core' ),
				'condition'   => array( 'excerpt_display' =>'yes','layout'=>array('layout2','layout3','layout5','layout6','layout7','layout8') ),
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'view_display',
				'label'       => esc_html__( 'PopUp Display', 'consalty-core' ),
				'label_on'    => esc_html__( 'Show', 'consalty-core' ),
				'label_off'   => esc_html__( 'Hide', 'consalty-core' ),
				'default'     => 'yes',
				'condition'   => array( 'layout' =>'layout6' ),
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'view_portfolio_link_btn',
				'label'       => esc_html__( 'Show Link Button', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Item Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .portfolio-default .rtin-item .rtin-content h3',
				'condition'   => array( 'layout' => array( 'layout1','layout2','layout6') ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'more_button_display',
				'label'       => esc_html__( 'More Button Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide More Button . Default: On', 'finbuzz-core' ),
				'condition'   => array( 'layout' => array( 'layout1','layout2','layout6') ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'more_button',
				'label'   => esc_html__( 'More Button', 'finbuzz-core' ),
				'options' => array(
					'show'        => esc_html__( 'Show Read More', 'finbuzz-core' ),
					'hide'        => esc_html__( 'Show Pagination', 'finbuzz-core' ),
				),
				'condition'   => array('more_button_display'=>'yes','layout'=>array('layout1','layout2','layout6') ),
				'default' => 'show',				
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_text',
				'label'   => esc_html__( 'Button Text', 'finbuzz-core' ),
				'default' => esc_html__( 'ALL Portfolio', 'finbuzz-core' ),
				'condition'   => array( 'more_button' => array( 'show' ),'more_button_display'=>array('yes'),'layout'=>array('layout1','layout2','layout6') ),
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_link',
				'label'   => esc_html__( 'Button Link', 'finbuzz-core' ),
				'condition'   => array( 'more_button' => array( 'show' ),'more_button_display'=>array('yes'),'layout'=>array('layout1','layout2','layout6') ),
			),
			array(
				'mode' => 'section_end',
			),

			// Style
			array(
				'mode'    => 'section_start',
				'id'      => 'layout_4_style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_title_color',
				'label'   => esc_html__( 'Portfolio Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .portfolio-default  .rtin-item .rtin-content  h3 a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_cat_color',
				'label'   => esc_html__( 'Portfolio Category Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .portfolio-default .rtin-item .rtin-content .cat-list a ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio-multi-layout-6 .rtin-item .rtin-content .rtin-cat' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio-multi-layout-6 .rtin-item .rtin-content .rtin-cat a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio-multi-layout-7 .rtin-item .rtin-content .rtin-cat' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio-multi-layout-7 .rtin-item .rtin-content .rtin-cat a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio-multi-layout-8 .rtin-item .rtin-content .rtin-cat' => 'color: {{VALUE}}',
					'{{WRAPPER}} .portfolio-multi-layout-8 .rtin-item .rtin-content .rtin-cat a' => 'color: {{VALUE}}',
				),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_content_color',
				'label'   => esc_html__( 'Portfolio Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .portfolio-default  .rtin-item .rtin-content p' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array('layout2','layout3','layout5','layout6','layout7','layout8') ),
			),	
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_bg_color',
				'label'   => esc_html__( 'Icon Background Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .portfolio-multi-layout-1 .rtin-item .link-shape:after' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array('layout1') ),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon  Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .portfolio-multi-layout-1 .rtin-item .link-shape .portfolio-btn a' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array('layout1') ),
			),
			array (
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_bg-hover_icon_color',
				'label'   => esc_html__( 'Icon  Hover Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .portfolio-multi-layout-1 .rtin-item .link-shape .portfolio-btn a:hover' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'layout' => array('layout1' )),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'portfolio_content_padding',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Content Padding', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio-multi-layout-5 .rtin-item .rtin-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => array( 'layout' => array('layout5')),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'portfolio_cat_spaceing',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Category Spacing', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio-multi-layout-5 .rtin-item .rtin-content .cat-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => array( 'layout' => array('layout5' )),
			),					
			array(
				'mode' => 'section_end',
			),

			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
				'condition'=>array( 'layout' => array('layout1','layout2','layout4','layout5') ),
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'finbuzz-core' ),
					'hide'        => esc_html__( 'Off', 'finbuzz-core' ),
				),
				'default' => 'wow',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'finbuzz-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'finbuzz-core' ),
					'bounce' => esc_html__( 'bounce', 'finbuzz-core' ),
					'flash' => esc_html__( 'flash', 'finbuzz-core' ),
					'pulse' => esc_html__( 'pulse', 'finbuzz-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'finbuzz-core' ),
					'shakeX' => esc_html__( 'shakeX', 'finbuzz-core' ),
					'shakeY' => esc_html__( 'shakeY', 'finbuzz-core' ),
					'headShake' => esc_html__( 'headShake', 'finbuzz-core' ),
					'swing' => esc_html__( 'swing', 'finbuzz-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'finbuzz-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'finbuzz-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'finbuzz-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'finbuzz-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'finbuzz-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'finbuzz-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'finbuzz-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'finbuzz-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'finbuzz-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'finbuzz-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'finbuzz-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'finbuzz-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'finbuzz-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'finbuzz-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'finbuzz-core' ),
				'default' => '0.2',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'finbuzz-core' ),
				'default' => '.8',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'mode' => 'section_end',
			),
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'finbuzz-core' ),
				'condition'   => array( 'layout' => array('layout4','layout5','layout7','layout8') ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'centered_slide',
				'label'       => esc_html__( 'Center Slide', 'finbuzz-core' ),
				'default'     => 'false',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'navigation',
				'label'       => esc_html__( 'Navigation', 'finbuzz-core' ),
				'default'     => 'yes',
				'condition'   =>array('layout'=>array('layout5','layout7','layout8'))
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'position1',
				'mode'        =>'responsive',
				'label'       => esc_html__( 'Navigation Positon Left', 'finbuzz-core' ),
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['%','px'],
                'default' => [
					'unit' => '%',
					'size' => '',
				 ],
				'selectors' => array(
					'{{WRAPPER}} .portfolio-multi-layout-5 .swiper-button-prev' => 'left:{{SIZE}}{{UNIT}}',
				),
				'condition'   => array( 'navigation' => 'yes','layout' =>'layout5'),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'position2',
				'mode'        =>'responsive',
				'label'       => esc_html__( 'Navigation Positon Right', 'finbuzz-core' ),
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['%','px'],
                'default' => [
					'unit' => '%',
					'size' => '',
				 ],
				'selectors' => array(
					'{{WRAPPER}} .portfolio-multi-layout-5 .swiper-button-next' => 'right:{{SIZE}}{{UNIT}}',
				),
				'condition'   => array( 'navigation' => 'yes','layout' =>'layout5'),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'slider_per_group',
				'label'       => esc_html__( 'Slides Per Group', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'autoplayspeed',
				'label'       => esc_html__( 'Autoplay speed', 'finbuzz-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'speed',
				'label'       => esc_html__( 'Slider Speed', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'space',
				'label'       => esc_html__( 'Inter slider spacing', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 30,
                ],
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item',
				'label'       => esc_html__( 'Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'medium_item',
				'label'       => esc_html__( 'Medium Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_tablet',
				'label'       => esc_html__( 'Tablet items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2,
                ],
				
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_mobile',
				'label'       => esc_html__( 'Mobile items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				
			),
			array(
				'mode' => 'section_end',
			),
			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'finbuzz-core' ),
				'condition'=>array( 'layout' => array('layout1','layout2','layout3','layout6')),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xl',
				'label'   => esc_html__( 'Desktops: > 1199px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 991px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Tablets: > 767px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Phones: > 576px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col',
				'label'   => esc_html__( 'Phones: < 576px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
			
		switch ( $data['layout'] ) {
			case 'layout8':
			$template = 'portfolio-8';
			$this->rt_load_scripts();
			break;
			case 'layout7':
			$template = 'portfolio-7';
			$this->rt_load_scripts();
			break;
			case 'layout6':
			$this->rt_load_scripts2();
			$template = 'portfolio-6';
			break;
			case 'layout5':
			$template = 'portfolio-5';
			$this->rt_load_scripts();
			break;
			case 'layout4':
			$this->rt_load_scripts();
			$template = 'portfolio-4';
			break;
			case 'layout3':
			$template = 'portfolio-3';
			break;
			case 'layout2':
			$template = 'portfolio-2';
			break;
			default:
			$template = 'portfolio-1';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}