<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
if ( ! defined( 'ABSPATH' ) ) exit;

class Progress_Bar extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'RT Progress Bar', 'finbuzz-core' );
		$this->rt_base = 'rt-progress-bar';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_style( 'animate' );
	}

	public function rt_fields(){
		$repeater = new \Elementor\Repeater();
		$repeater2 = new \Elementor\Repeater();

		$repeater->add_control(
			'progress2_number',
			 [
				'type'    => Controls_Manager::SLIDER,
				'label'   => esc_html__( 'Percentage', 'finbuzz-core' ),
				'default' => array( 'size' => 80 ),
			]
		);
		$repeater->add_control(
			'progress2_number_height',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Percentage Height', 'finbuzz-core' ),
				'default' => '6',
			]
		);
		$repeater2->add_control(
			'progress_style2_title',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => 'Consulting',
			]
		);
		$repeater2->add_control(
			'progress_style2_number',
			 [
				'type'    => Controls_Manager::SLIDER,
				'label'   => esc_html__( 'Percentage', 'finbuzz-core' ),
				'default' => array( 'size' => 80 ),
			]
		);
		$repeater2->add_control(
			'progress_style2_number_height',
			 [
				'type'    => Controls_Manager::TEXT,
				'label'   => esc_html__( 'Percentage Height', 'finbuzz-core' ),
				'default' => '6',
			]
		);
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Global Insights', 'finbuzz-core' ),
				'condition'   =>array('style'=>array('style1'))
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'title_url',
				'label'   => esc_html__( 'Title URL (Optional)', 'finbuzz-core' ),
				'placeholder' => 'https://title-link.com',
				'condition'   =>array('style'=>array('style1'))
			),
			array(					 
				'type'    => Controls_Manager::CHOOSE,
				'options' => array(
				  'icon' => array(
					'title' => esc_html__( 'Left', 'finbuzz-core' ),
					'icon' => 'fa fa-smile',
				  ),
				  'image' => array(
					'title' => esc_html__( 'Center', 'finbuzz-core' ),
					'icon' => 'fa fa-image',
				  ),		     
				),
				'condition'   =>array('style'=>array('style1')),
				'id'      => 'icontype',
				'label'   => esc_html__( 'Media Type', 'finbuzz-core' ),
				'default' => 'icon',
				'label_block' => false,
				'toggle' => false,
				
			),
			array(
				'type'    => Controls_Manager::ICONS,
				'id'      => 'style2_icon_class',
				'label'   => esc_html__( 'Icon', 'finbuzz-core' ),
				'default' => array(
			      'value' => 'flaticon-suitcase',
			      'library' => 'fa-solid',
				),	
			  	'condition'   => array('icontype' => array( 'icon'),'style'=>'style1'),
			),	
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'style2_icon_image',
				'label'   => esc_html__( 'Icon Image', 'finbuzz-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'description' => esc_html__( 'Recommended full image', 'finbuzz-core' ),
				'condition'   => array('icontype' => array( 'image' ),'style'=>'style1'),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',
                'condition'   => array('icontype' => array( 'image' ),'style'=>'style1'),		
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'mouse_follow',
				'label'       => esc_html__( 'Mouse Follow Effect', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'finbuzz-core' ),
				'condition'   =>array('style'=>array('style1'))
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'progress_icon_display',
				'label'       => esc_html__( 'Icon', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'finbuzz-core' ),
				'condition'   =>array('style'=>array('style1'))
			),
			array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'progress2_bars',
				'label'   => esc_html__( 'Add Progress Bar', 'finbuzz-core' ),
				'fields' => $repeater->get_controls(),
				'condition'   =>array('style'=>array('style1'))
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'progress_style2_bars',
				'label'   => esc_html__( 'Add Item', 'finbuzz-core' ),
				'fields' => $repeater2->get_controls(),
				'condition'   =>array('style'=>array('style2'))
			),			
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_colors',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .rtin-progress-bar .rtin-item .rtin-title h3',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'bgcolor_color',
				'label'   => esc_html__( 'Bgcolor', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( '{{WRAPPER}} .progress' => 'background-color: {{VALUE}}' ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'fgcolor_color',
				'label'   => esc_html__( 'Fgcolor', 'finbuzz-core' ),
				'default' => '#fa360a',
				'selectors' => array( '{{WRAPPER}} .progress .progress-bar' => 'background-color: {{VALUE}}' ),
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'item_bg_color',
				'label'   => esc_html__( 'Progress Box Color', 'finbuzz-core' ),
				'default' => '#fff',
				'selectors' => array( '{{WRAPPER}} .rtin-progress-bar .rtin-item' => 'background-color: {{VALUE}}' ),
				'condition'   =>array('style'=>array('style1'))
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .rtin-progress-bar .progress-bar-wrap .progress-bar-content .rtin-title h3 a' => 'color: {{VALUE}}',
				    '{{WRAPPER}} .rtin-progress-bar .progress-bar-wrap .progress-bar-content .rtin-title h3' => 'color: {{VALUE}}',
			 	),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'icon_color',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array( 
					'{{WRAPPER}} .rtin-progress-bar .progress-bar-wrap .progress-bar-icon' => 'color: {{VALUE}}',
				    
			 	),
				'condition'   =>array('style'=>array('style1'))
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'progress_icon_size',
				'label'   => esc_html__( 'Icon Size', 'finbuzz-core' ),
				'range' => [
					'px' => [
						'max' => 60,
						'min' => 40,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rtin-progress-bar.progress-bar-style1 .progress-bar-wrap .progress-bar-icon i' => 'font-size: {{SIZE}}px',
				],
				'condition'   => array( 'style' => array('style1')),
			),
			array(
				'mode' => 'section_end',
			),
			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   =>array('style'=>array('style1'))
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'finbuzz-core' ),
					'hide'        => esc_html__( 'Off', 'finbuzz-core' ),
				),
				'default' => 'wow',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'finbuzz-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'finbuzz-core' ),
					'bounce' => esc_html__( 'bounce', 'finbuzz-core' ),
					'flash' => esc_html__( 'flash', 'finbuzz-core' ),
					'pulse' => esc_html__( 'pulse', 'finbuzz-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'finbuzz-core' ),
					'shakeX' => esc_html__( 'shakeX', 'finbuzz-core' ),
					'shakeY' => esc_html__( 'shakeY', 'finbuzz-core' ),
					'headShake' => esc_html__( 'headShake', 'finbuzz-core' ),
					'swing' => esc_html__( 'swing', 'finbuzz-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'finbuzz-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'finbuzz-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'finbuzz-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'finbuzz-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'finbuzz-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'finbuzz-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'finbuzz-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'finbuzz-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'finbuzz-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'finbuzz-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'finbuzz-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'finbuzz-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'finbuzz-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'finbuzz-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'finbuzz-core' ),
				'default' => '0.8',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'finbuzz-core' ),
				'default' => '1.2',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		switch ( $data['style'] ) {
			case 'style2':
			$template = 'progress-bar-2';
			break;
			default:
			$template = 'progress-bar';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}