<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Group_Control_Image_Size;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Banner_Slider extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Banner Slider', 'finbuzz-core' );
		$this->rt_base = 'rt-banner-slider';
		parent::__construct( $data, $args );
	}

    private function rt_load_scripts(){
		wp_enqueue_script( 'magnific-popup' );
		wp_enqueue_style(  'swiper-slider' );
		wp_enqueue_script('swiper-slider');
	}

	public function rt_fields(){
        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
            'sub-title',
            [
                'type' => Controls_Manager::TEXT,
                'label' =>   esc_html__('Sub title', 'finbuzz-core'),
                'label_block' => true, 
                'default' =>'We Creat Digitul Product'
            ]
        );

		$repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label' =>   esc_html__('Title', 'finbuzz-core'),
                'label_block' => true,
                'default' =>'Business Solutions For All Enterprises' 
            ]
        );

		$repeater->add_control(
            'desc',
            [
                'type' => Controls_Manager::TEXTAREA,
                'label' =>   esc_html__('Description', 'finbuzz-core'),
                'label_block' => true,
                'default' =>'Bhen an unknown printer took a galley of type and scrambled ype specimen book. It has survived .'  
            ]
        );

		$repeater->add_control(
            'btn',
            [
                'type' => Controls_Manager::TEXT,
                'label' =>   esc_html__('Button Text', 'finbuzz-core'),
                'label_block' => true,
                'default' =>'Free Consulting' 
            ]
        );

		$repeater->add_control(
            'url',
            [
                'type' => Controls_Manager::URL,
                'label' =>   esc_html__('Button Link', 'finbuzz-core'),
                'label_block' => true, 
            ]
        );

		$repeater->add_control(
            'video_url',
            [
                'type' => Controls_Manager::URL,
                'label' =>   esc_html__('Video Link', 'finbuzz-core'),
                'label_block' => true, 
            ]
        );
		$repeater->add_control(
            'img',
            [
                'type' => Controls_Manager::MEDIA,
                'label' =>   esc_html__('Image', 'finbuzz-core'),
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],                
            ]
        );

		$fields=array(
            array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'Banner Slider', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Image Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Slider Style 1' , 'finbuzz-core' ),
					'style2' => esc_html__( 'Slider Style 2' , 'finbuzz-core' ),
					'style3' => esc_html__( 'Slider Style 3' , 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
            array (
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'items',
				'label'   => esc_html__( 'Slider Items', 'finbuzz-core' ),
				'fields' => $repeater->get_controls(),	
			),
            array(
                'type'    => Controls_Manager::MEDIA,
				'id'      => 'shape1',
				'label'   => __( 'Animation shape 1', 'finbuzz-core' ),
                'description' => esc_html__( 'If not uploaded, default will be used  & recommended full image', 'finbuzz-core' ),
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
            ),
			array(
                'type'        => Controls_Manager::MEDIA,
				'id'          => 'shape2',
				'label'       => __( 'Animation shape 2', 'finbuzz-core' ),
                'description' => esc_html__( 'If not uploaded, default will be used  & recommended full image', 'finbuzz-core' ),
				'default'     => [
					'url'     => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition'   =>array('style'=>array('style1','style2'))
            ),
            array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'shape1_display',
				'label'       => esc_html__( 'Shape Image  Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'follow_display',
				'label'       => esc_html__( 'Social Icon  Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'no',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style2') ),
			),
            array(
				'mode' => 'section_end',
			),
            // Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'finbuzz-core' ),
				
			),
			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'no',
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'display_arrow',
				'label'       => esc_html__( 'Navigation Arrow', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Navigation Arrow. Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style1') ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'display_dots',
				'label'       => esc_html__( 'Pagination Dots', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Pagination Dots. Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style2') ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_delay',
				'label'   => esc_html__( 'Autoplay Slide Delay', 'finbuzz-core' ),
				'default' => 5000,
				'description' => esc_html__( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'finbuzz-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
				
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => esc_html__( 'Autoplay Slide Speed', 'finbuzz-core' ),
				'default' => 2000,
				'description' => esc_html__( 'Set any value for example .8 seconds to play it in every 2 seconds. Default: .8 Seconds', 'finbuzz-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
				
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Loop to first item. Default: On', 'finbuzz-core' ),

			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'position1',
				'mode'        =>'responsive',
				'label'       => esc_html__( 'Navigation Positon Bottom', 'finbuzz-core' ),
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['%'],
                'default' => [
					'unit' => '%',
					'size' => 5,
				 ],
				'selectors' => array(
					'{{WRAPPER}} .banner-slider-addon  .main-banner-slider .swiper-navigation' => 'bottom:{{SIZE}}{{UNIT}}',
				),
				'condition'   => array( 'display_arrow' => 'yes','style' =>'style1' ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'position2',
				'mode'        =>'responsive',
				'label'       => esc_html__( 'Navigation Positon Left', 'finbuzz-core' ),
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['%'],
                'default' => [
					'unit' => '%',
					'size' => 5,
				 ],
				'selectors' => array(
					'{{WRAPPER}} .banner-slider-addon  .main-banner-slider .swiper-navigation' => 'left:{{SIZE}}{{UNIT}}',
				),
				'condition'   => array( 'display_arrow' => 'yes','style' =>'style1'),
			),
			
			//Slider style 2 options start
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'slider2_position1',
				'mode'        =>'responsive',
				'label'       => esc_html__( 'Pagination Positon Bottom', 'finbuzz-core' ),
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['%'],
                'default' => [
					'unit' => '%',
					'size' => 5,
				 ],
				'selectors' => array(
					'{{WRAPPER}} .main-banner-slider .swiper-pagination-bullets' => 'bottom:{{SIZE}}{{UNIT}}',
				),
				'condition'   => array( 'display_dots' => 'yes','style' =>'style2' ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'slider2_position2',
				'mode'        =>'responsive',
				'label'       => esc_html__( 'Pagination Positon Right', 'finbuzz-core' ),
                'range' => [
					'px' => [
						'min' => 50,
						'max' => 1000,
					],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['%'],
                'default' => [
					'unit' => '%',
					'size' =>50
				 ],
				'selectors' => array(
					'{{WRAPPER}} .main-banner-slider .swiper-pagination-bullets' => 'left:{{SIZE}}{{UNIT}}',
				),
				'condition'   => array( 'display_dots' => 'yes','style' =>'style2' ),
			),
			//Slider style 2 options end

			array(
				'mode' => 'section_end',
			),
            // Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .banner-slider-addon .main-banner-slider .banner-content .banner-title',
			),
            array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-slider-addon .main-banner-slider .banner-content .banner-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-slider-addon.slider-style3 .main-banner-slider3 .single-slider .banner-content .banner-title' => 'color: {{VALUE}}',
				),
			),
            array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'title_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Title Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .banner-slider-addon .main-banner-slider .banner-content .banner-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .banner-slider-addon.slider-style3 .main-banner-slider3 .single-slider .banner-content .banner-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
            array(
				'mode' => 'section_end',
			),
            // SubTitle style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_subtitle_style',
				'label'   => esc_html__( 'Subtitle Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'subtitle_typo',
				'label'   => esc_html__( 'Sub Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .banner-slider-addon .main-banner-slider .banner-content .subtitle',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'subtitle_color',
				'label'   => esc_html__( 'Subtitle Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-slider-addon .main-banner-slider .banner-content .subtitle' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-slider-addon.slider-style3 .main-banner-slider3 .single-slider .banner-content .banner-subtitle' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-slider-addon.slider-style3 .main-banner-slider3 .single-slider .banner-content .banner-subtitle::after' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'subtitle_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Subtitle Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .banner-slider-addon .main-banner-slider .banner-content .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .banner-slider-addon.slider-style3 .main-banner-slider3 .single-slider .banner-content .banner-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'mode' => 'section_end',
			),
            // Content style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_content_style',
				'label'   => esc_html__( 'Content Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'content_typo',
				'label'   => esc_html__( 'Content Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .banner-slider-addon .main-banner-slider .banner-content p ',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => esc_html__( 'Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-slider-addon .main-banner-slider .banner-content p ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-slider-addon.slider-style3 .main-banner-slider3 .banner-content p' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'content_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Content Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .banner-slider-addon .main-banner-slider .banner-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .banner-slider-addon.slider-style3 .main-banner-slider3 .banner-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'mode' => 'section_end',
			),

			// Button style 1
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button_style',
				'label'   => esc_html__( 'Button Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition' =>array('style'=>array('style1','style2'))
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'button_typo',
				'label'   => esc_html__( 'Button Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .banner-slider-addon  .banner-content .banner-btn-list li a',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_text_color',
				'label'   => esc_html__( 'Button Text Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-slider-addon  .banner-content .banner-btn-list li a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-slider-addon .banner-content .banner-btn-list li a i ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-slider-addon .banner-content .banner-btn-list li a svg path ' => 'fill: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_text_hover_color',
				'label'   => esc_html__( 'Button Text Hover Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-slider-addon  .banner-content .banner-btn-list li a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-slider-addon .banner-content .banner-btn-list li a:hover i ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-slider-addon .banner-content .banner-btn-list li a:hover svg path ' => 'fill: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_bg_color',
				'label'   => esc_html__( 'Button Background Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-slider-addon  .banner-content .banner-btn-list li a' => 'background-color: {{VALUE}}',
				),
			),	
			
            array(
				'type'    => Controls_Manager::HEADING,
				'id'      => 'heading',
				'label'   => esc_html__( 'Background Hover Color', 'finbuzz-core' ),
                'separator' => 'before',
			),
            array(
				'name'      => 'btn2_bg_color',
				'mode'     => 'group',
				'type'     => Group_Control_Background::get_type(),
				'label'    => __( 'Background Hover', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .banner-slider-addon  .banner-content .banner-btn-list li a:hover',
			),	
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'button_space',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Button Padding', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .banner-slider-addon  .banner-content .banner-btn-list li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'button_radius',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Button Radius', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .banner-slider-addon  .banner-content .banner-btn-list li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .banner-slider-addon .banner-content .banner-btn-list li a:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			),
			array(
				'mode' => 'section_end',
			),
        );

		return $fields;
	}

	protected function render() {

		$data = $this->get_settings();
        $this->rt_load_scripts();
        if($data['slider_autoplay']=='yes'){
			$data['slider_autoplay']=true;
		}
		else{
			$data['slider_autoplay']=false;
		}
		$swiper_data=array(
			'slidesPerView' 	=>1,
			'loop'				=>$data['slider_loop']=='yes' ? true:false,
			'slideToClickedSlide' =>true,
			'autoplay'				=>array(
				'delay'  => $data['slider_autoplay_delay'],
			),
			'speed'      =>$data['slider_autoplay_speed'],
			'auto'   =>$data['slider_autoplay']
		);

		switch ( $data['style'] ) {
			case 'style3':
			$template = 'banner-slider-3';
			break;
            case 'style2':
            $template = 'banner-slider-2';
            break;
			default:
			$template = 'banner-slider';
			break;
		}
        $data['swiper_data'] = json_encode( $swiper_data );   
		return $this->rt_template( $template, $data );
	}
}