<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Banner extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Banner', 'finbuzz-core' );
		$this->rt_base = 'rt-banner';
		parent::__construct( $data, $args );
	}
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
					'style4' => esc_html__( 'Style 4', 'finbuzz-core' ),
					'style5' => esc_html__( 'Style 5', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Boost Your Business Up To High Level', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'sub_title',
				'label'   => esc_html__( 'Subtitle', 'finbuzz-core' ),
				'default' => esc_html__( 'WE CREAT DIGITAL PRODUCT', 'finbuzz-core' ),
				'condition'   =>array('style'=>array('style1','style2'))
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'finbuzz-core' ),
				'default' => esc_html__( 'Business contents insurance is type of business insurance ossessions and equipment.', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'banner_content_bg',
				'label'   => esc_html__( 'Banner Content BG Color', 'consalty-core' ),
				'default' => '#ffffff',
				'description' => esc_html__( 'Default Color White', 'consalty-core' ),
				'selectors' => [
					'{{WRAPPER}} .banner-content.style-3' => 'background-color:{{VALUE}}',
				],
				'condition'   => array( 'style' => array( 'style5')),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'banner_1_height',
				'label'   => esc_html__( 'Min Height', 'finbuzz-core' ),
				'mode'	=>'responsive',
				'description' => esc_html__( 'Size Unit Px', 'finbuzz-core' ),
				'default'    => [
					'unit' => 'px',
					'size' => 750,
				],
				'range' => [
					'px' => [
						'max' => 1000,
						'min' => 200,
					],
					
				],
				
				'selectors' => [
					'{{WRAPPER}} .banner-addon ' => 'min-height: {{SIZE}}px;',
					
	
				],
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'banner_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Banner Content Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .banner-content-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'buttontext',
				'label'   => esc_html__( 'Button Text', 'finbuzz-core' ),
				'default' => esc_html__( 'Free Consalty', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'videotext',
				'label'   => esc_html__( 'Video Text', 'finbuzz-core' ),
				'default' => esc_html__( 'Watch The Video', 'finbuzz-core' ),
				'condition'   =>array('style'=>array('style2'))
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'url',
				'label'   => esc_html__( 'Button URL', 'finbuzz-core' ),
				'placeholder' => 'https://button-link.com',
				
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'video_url',
				'label'   => esc_html__( 'Video URL', 'finbuzz-core' ),
				'placeholder' => 'https://video-link.com',
				'condition'   =>array('style'=>array('style2'))
			),
			array(
				'type'    => Controls_Manager::MEDIA,
				'id'      => 'rt_image',
				'label'   => esc_html__( 'Banner Image', 'finbuzz-core' ),
				'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
				'description' => esc_html__( 'Recommended 1041 × 718 px image', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style3')),
			),
			array(
				'type'    => Group_Control_Image_Size::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'image size', 'finbuzz-core' ),	
				'name' => 'icon_image_size', 
				'separator' => 'none',
				'condition'   => array( 'style' => array( 'style3')),		
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'mouse_follow',
				'label'       => esc_html__( 'Mouse Follow Effect', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array( 'style3','style4','style5')),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'button_style',
				'label'   => esc_html__( 'Button Style', 'finbuzz-core' ),
				'options' => array(
					'finbuzz-button-1' => esc_html__( 'Button 1', 'finbuzz-core' ),
					'finbuzz-button-2' => esc_html__( 'Button 2', 'finbuzz-core' ),
				),
				'condition'   => array( 'style' => array( 'style3','style5')),
				'default' => 'finbuzz-button-1',
			),
            array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'follow_display',
				'label'       => esc_html__( 'Social Icon  Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'no',
				'description' => esc_html__( 'Show or Hide Content. Default: On', 'finbuzz-core' ),
				'condition'   =>array('style'=>array('style1'))
			),
            array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'shape_display',
				'label'       => esc_html__( 'Shape Image  Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => false,
				'description' => esc_html__( 'Show or Hide Content. Default: Off', 'finbuzz-core' ),
				'condition'   =>array('style'=>array('style1'))
			),
            array(
                'type'    => Controls_Manager::MEDIA,
				'id'      => 'shape1',
				'label'   => __( 'Animation shape 1', 'finbuzz-core' ),
                'description' => esc_html__( 'If not uploaded, default will be used  & recommended full image', 'finbuzz-core' ),
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
                'condition' =>array('style'=>array('style1'),'shape_display'=>'yes')
            ),
			array(
                'type'    => Controls_Manager::MEDIA,
				'id'      => 'shape2',
				'label'   => __( 'Animation shape 2', 'finbuzz-core' ),
                'description' => esc_html__( 'If not uploaded, default will be used  & recommended full image', 'finbuzz-core' ),
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
                'condition' =>array('style'=>array('style1'),'shape_display'=>'yes')
            ),
            
			array(
				'mode' => 'section_end',
			),
			
			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .banner-content .banner-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-content .banner-title' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'title_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Title Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .banner-content .banner-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'mode' => 'section_end',
			),
			// SubTitle style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_subtitle_style',
				'label'   => esc_html__( 'Subtitle Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   =>array('style'=>array('style1','style2','style4'))
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'subtitle_typo',
				'label'   => esc_html__( 'Subtitle Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .banner-addon .subtitle',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'subtitle_color',
				'label'   => esc_html__( 'Subtitle Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-addon .subtitle' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'subtitle_border_color',
				'label'   => esc_html__( 'Subtitle Border Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-addon.style2 .subtitle' => 'border-color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'subtitle_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Subtitle Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .banner-addon .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'mode' => 'section_end',
			),
			// Content style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_content_style',
				'label'   => esc_html__( 'Content Style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'content_typo',
				'label'   => esc_html__( 'Content Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .banner-addon .banner-content p ',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => esc_html__( 'Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-addon .banner-content p ' => 'color: {{VALUE}}',
					'{{WRAPPER}} .banner-addon.style2 span.play-text' => 'color: {{VALUE}}'
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'content_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Content Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .banner-addon .banner-content p ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'video_text_color',
				'label'   => esc_html__( 'Video Text Border Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .banner-addon.style2 .play-text:after' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .banner-addon.style2 .play-text' => 'border-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2')),
			),
			array(
				'mode' => 'section_end',
			),
			/**banner style 3 shape options */
			array(
				'mode'    => 'section_start',
				'id'      => 'shape1_positioning',
				'label'   => esc_html__( 'Shape Image 1', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style3','style4','style5') ),
				
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'shape1_display',
				'label'       => esc_html__( 'Shape Image 1 Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => false,
				'description' => esc_html__( 'Show or Hide Content. Default: off', 'finbuzz-core' ),
			),
			
			array(
				'mode' => 'section_end',
			),
			//banner 1 shape 2 positon start
			array(
				'mode'    => 'section_start',
				'id'      => 'shape2_positioning',
				'label'   => esc_html__( 'Shape Image 2', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style3','style4','style5') ),
				
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'banner_1_shape2_display',
				'label'       => esc_html__( 'Shape Image 2 Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => false,
				'description' => esc_html__( 'Show or Hide Content. Default: off', 'finbuzz-core' ),
			),
			
			array(
				'mode' => 'section_end',
			),
			//banner 1 shape 2 positon end

			//banner 1 shape 3 positon start
			array(
				'mode'    => 'section_start',
				'id'      => 'shape3_positioning',
				'label'   => esc_html__( 'Shape Image 3', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style3','style5')),
				
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'banner_1_shape3_display',
				'label'       => esc_html__( 'Shape Image 3 Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => false,
				'description' => esc_html__( 'Show or Hide Content. Default: off', 'finbuzz-core' ),
			),
			
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		switch ( $data['style'] ) {
			case 'style5':
			$template = 'banner-5';
			break;
			case 'style4':
			$template = 'banner-4';
			break;
			case 'style3':
			$template = 'banner-3';
			break;
			case 'style2':
			$template = 'banner-2';
			break;
			default:
			$template = 'banner';
			break;
		}
		return $this->rt_template( $template, $data );
	}
}