<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Service extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Service', 'finbuzz-core' );
		$this->rt_base = 'rt-service';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => esc_html__( '1 Col', 'finbuzz-core' ),
				'6'  => esc_html__( '2 Col', 'finbuzz-core' ),
				'4'  => esc_html__( '3 Col', 'finbuzz-core' ),
				'3'  => esc_html__( '4 Col', 'finbuzz-core' ),
				'2'  => esc_html__( '6 Col', 'finbuzz-core' ),
			),
		);
		parent::__construct( $data, $args );
	}
	private function rt_load_scripts(){
		wp_enqueue_style(  'swiper-slider' );
		wp_enqueue_script('swiper-slider');
	}
	public function rt_fields(){
		
		$terms  = get_terms( array( 'taxonomy' => 'finbuzz_service_category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => __( 'Please Selecet category', 'finbuzz-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}
		
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'layout',
				'label'   => esc_html__( 'Layout', 'finbuzz-core' ),
				'options' => array(
					'layout1' => esc_html__( 'Service 1', 'finbuzz-core' ),
					'layout2' => esc_html__( 'Service 2', 'finbuzz-core' ),
					'layout3' => esc_html__( 'Service 3', 'finbuzz-core' ),
					'layout4' => esc_html__( 'Service 4', 'finbuzz-core' ),
					'layout5' => esc_html__( 'Service 5', 'finbuzz-core' ),
					'layout6' => esc_html__( 'Service 6', 'finbuzz-core' ),
					'layout7' => esc_html__( 'Service 7', 'finbuzz-core' ),
				),
				'default' => 'layout1',
			),
			array (
				'type'      => Controls_Manager::SELECT2,
				'id'        => 'cat_single',
				'label'     => esc_html__( 'Categories', 'finbuzz-core' ),
				'options'   => $category_dropdown,
				'default'   => '0',
				'multiple'  => false,
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => esc_html__( 'Post Ordering', 'finbuzz-core' ),
				'options' => array(
					'DESC'	=> esc_html__( 'Desecending', 'finbuzz-core' ),
					'ASC'	=> esc_html__( 'Ascending', 'finbuzz-core' ),
				),
				'default' => 'DESC',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Post Sorting', 'finbuzz-core' ),				
				'options' => array(
					'recent' 		=> esc_html__( 'Recent Post', 'finbuzz-core' ),
					'rand' 			=> esc_html__( 'Random Post', 'finbuzz-core' ),
					'menu_order' 	=> esc_html__( 'Custom Order', 'finbuzz-core' ),
					'title' 		=> esc_html__( 'By Name', 'finbuzz-core' ),
				),
				'default' => 'recent',
			),			
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_not_in',
				'label'   => esc_html__( 'Enter Post ID that will not display', 'finbuzz-core' ),
				'fields'  => array(
					array(
						'type'    => Controls_Manager::NUMBER,
						'name'    => 'post_not_in',
						'label'   => esc_html__( 'Post ID', 'finbuzz-core' ),
						'default' => '0',
					),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'column_no_gutters',
				'label'   => esc_html__( 'Display column gap', 'finbuzz-core' ),
				'options' => array(
					'show'        => esc_html__( 'Gap', 'finbuzz-core' ),
					'hide'        => esc_html__( 'No Gap', 'finbuzz-core' ),
				),
				'default' => 'show',
				'condition'   => array( 'layout' => array( 'layout1','layout2','layout3') ),
			),
			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'itemnumber',
				'label'   => esc_html__( 'Item Number', 'finbuzz-core' ),
				'default' => -1,
				'description' => esc_html__( 'Use -1 for showing all items( Showing items per category )', 'finbuzz-core' ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Item Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .service-default .service-item h3',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_count',
				'label'   => esc_html__( 'Title Word count', 'finbuzz-core' ),
				'default' => 5,
				'description' => esc_html__( 'Maximum number of words', 'finbuzz-core' ),				
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'excerpt_display',
				'label'       => esc_html__( 'Excerpt/Content Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
				'condition'   => array( 'layout' => array('layout1','layout2','layout3','layout4','layout6') ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'excerpt_count',
				'label'   => esc_html__( 'Word count', 'finbuzz-core' ),
				'default' => 9,
				'description' => esc_html__( 'Maximum number of words', 'finbuzz-core' ),
				'condition'   => array( 'layout' => array('layout1','layout2','layout3','layout4','layout5','layout6')),
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'read_display',
				'label'       => esc_html__( 'Read More Button Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
				'condition'   => array( 'layout' => array('layout1','layout2','layout4','layout6') ),
			),
			
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'icon_display',
				'label'       => esc_html__( 'Icon Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'Show', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Hide', 'finbuzz-core' ),
				'default'     => 'yes',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'more_button_display',
				'label'       => esc_html__( 'More Button Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide More Button . Default: On', 'finbuzz-core' ),
				'condition'   => array( 'layout' => array('layout1','layout2','layout3','layout4','layout6','layout7') ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'more_button',
				'label'   => esc_html__( 'More Button', 'finbuzz-core' ),
				'options' => array(
					'show'        => esc_html__( 'Show Read More', 'finbuzz-core' ),
					'hide'        => esc_html__( 'Show Pagination', 'finbuzz-core' ),
				),
				'default' => 'show',
				'condition'   => array('more_button_display'=>'yes' )				
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_text',
				'label'   => esc_html__( 'Button Text', 'finbuzz-core' ),
				'condition'   => array( 'more_button' => array( 'show' ) ),
				'default' => esc_html__( 'MORE SERVICES', 'finbuzz-core' ),
				'condition'   => array('more_button_display'=>'yes' )	
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_link',
				'label'   => esc_html__( 'Button Link', 'finbuzz-core' ),
				'condition'   => array( 'more_button' => array( 'show' ),'more_button_display'=>'yes' ),
			),
			array(
				'mode' => 'section_end',
			),

			/*Style Option*/
			array(
				'mode'    => 'section_start',
				'id'      => 'service_title_style',
				'label'   => esc_html__( 'Service Title', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'service_title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .service-default .service-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'service_title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .service-default .service-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .service-default .service-title a' => 'color: {{VALUE}}',
				),
				
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'service_title_hover_color',
				'label'   => esc_html__( 'Title Hover Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .service-default .service-item:hover .service-content .service-title a' => 'color: {{VALUE}}',
				),
				
			),
			
			array(
				'mode' => 'section_end',
			),

			// Content text style
			array(
				'mode'    => 'section_start',
				'id'      => 'service_sec_content',
				'label'   => esc_html__( 'Content Text', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'=>array('layout'=>array('layout1','layout2','layout3','layout4','layout5','layout6'))
			),
			
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'service_content_typo',
				'label'   => esc_html__( 'Content Text Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .service-default .service-item .service-content p',
				
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'service_conent_color',
				'label'   => esc_html__( 'Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .service-default .service-item .service-content p' => 'color: {{VALUE}}',
				),
				
			),
			
			array(
				'mode' => 'section_end',
			),

			// Icon  style
			array(
				'mode'    => 'section_start',
				'id'      => 'service_sec_icon',
				'label'   => esc_html__( 'Icon', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'=>array('layout'=>array('layout4','layout5'))
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'service_conent_icon_color',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .service-default .service-item .service-content .icon i' => 'color: {{VALUE}}',
				),
				
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'service_conent_icon_box_color',
				'label'   => esc_html__( 'Icon Box Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .service-default .service-item .service-content .icon' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .service-default .service-item .service-content .service-img-wrap' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .service-layout5 .service-item .service-content .service-hover-img' => 'background-color: {{VALUE}}',
				),
				
			),
			array(
				'mode' => 'section_end',
			),
			// Icon style
			array(
				'mode'    	=> 'section_start',
				'id'      	=> 'service_sec_icon_7',
				'label'   	=> esc_html__( 'Icon Style', 'finbuzz-core' ),
				'tab'     	=> Controls_Manager::TAB_STYLE,
				'condition'	=>array('layout'=>array('layout7'))
			),			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'service_icon_size_7',
				'label'   => esc_html__( 'Icon Size', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .service-default .service-item .service-content .icon i' => 'font-size: {{VALUE}}px',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'service_icon_color_7',
				'label'   => esc_html__( 'Icon Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .service-default .service-item .service-content .icon i' => 'color: {{VALUE}}',
				),
			),
			
			array(
				'mode' => 'section_end',
			),
			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'finbuzz-core' ),
					'hide'        => esc_html__( 'Off', 'finbuzz-core' ),
				),
				'default' => 'hide',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'finbuzz-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'finbuzz-core' ),
					'bounce' => esc_html__( 'bounce', 'finbuzz-core' ),
					'flash' => esc_html__( 'flash', 'finbuzz-core' ),
					'pulse' => esc_html__( 'pulse', 'finbuzz-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'finbuzz-core' ),
					'shakeX' => esc_html__( 'shakeX', 'finbuzz-core' ),
					'shakeY' => esc_html__( 'shakeY', 'finbuzz-core' ),
					'headShake' => esc_html__( 'headShake', 'finbuzz-core' ),
					'swing' => esc_html__( 'swing', 'finbuzz-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'finbuzz-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'finbuzz-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'finbuzz-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'finbuzz-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'finbuzz-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'finbuzz-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'finbuzz-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'finbuzz-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'finbuzz-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'finbuzz-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'finbuzz-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'finbuzz-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'finbuzz-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'finbuzz-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'finbuzz-core' ),
				'default' => '0.3',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'finbuzz-core' ),
				'default' => '1.2',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'mode' => 'section_end',
			),
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'finbuzz-core' ),
				'condition'   => array( 'layout' => array('layout5' ) ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'centered_slide',
				'label'       => esc_html__( 'Center Slide', 'finbuzz-core' ),
				'default'     => 'false',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'pagination',
				'label'       => esc_html__( 'Pagination', 'finbuzz-core' ),
				'default'     => 'yes',
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'slider_per_group',
				'label'       => esc_html__( 'Slides Per Group', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'autoplayspeed',
				'label'       => esc_html__( 'Autoplay speed', 'finbuzz-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'speed',
				'label'       => esc_html__( 'Slider Speed', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'space',
				'label'       => esc_html__( 'Inter slider spacing', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 30,
                ],
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item',
				'label'       => esc_html__( 'Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 3,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'medium_item',
				'label'       => esc_html__( 'Medium Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_tablet',
				'label'       => esc_html__( 'Tablet items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2,
                ],
				
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_mobile',
				'label'       => esc_html__( 'Mobile items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				
			),
			
			array(
				'mode' => 'section_end',
			),
			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'finbuzz-core' ),
				'condition'   => array( 'layout' => array('layout1','layout2','layout3','layout4','layout6','layout7') ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xl',
				'label'   => esc_html__( 'Desktops: > 1199px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 991px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Tablets: > 767px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Phones: > 576px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col',
				'label'   => esc_html__( 'Phones: < 576px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		switch ( $data['layout'] ) {
			case 'layout7':
			$template = 'service-7';
			break;
			case 'layout6':
			$template = 'service-6';
			break;
			case 'layout5':
			$this->rt_load_scripts();	
			$template = 'service-5';
			break;
			case 'layout4':
			$template = 'service-4';
			break;
			case 'layout3':
			$template = 'service-3';
			break;
			case 'layout2':
			$template = 'service-2';
			break;
			default:
			$template = 'service-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}