<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
if ( ! defined( 'ABSPATH' ) ) exit;

class Text_With_Button extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Title Text With Button', 'finbuzz-core' );
		$this->rt_base = 'rt-text-with-button';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Text Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Text Style 1' , 'finbuzz-core' ),
					'style2' => esc_html__( 'Text Style 2', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type' => Controls_Manager::CHOOSE,
				'id'      => 'content_align',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Alignment', 'finbuzz-core' ),
				'options' => array(
					'left' => array(
						'title' => __( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					),
					'right' => array(
						'title' => __( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					),
					'justify' => array(
						'title' => __( 'Justified', 'elementor' ),
						'icon' => 'eicon-text-align-justify',
					),
				),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				),
				'condition'   => array( 'style' => array('style1','style2') ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'showhide',
				'label'   => esc_html__( 'Sub Title Bar', 'finbuzz-core' ),
				'options' => array(
					'barshow'        => esc_html__( 'Show', 'finbuzz-core' ),
					'barhide'        => esc_html__( 'Hide', 'finbuzz-core' ),
				),
				'default' => 'barshow',
				'condition'   => array( 'style' => array('style1','style2') ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'subtitle-style',
				'label'   => esc_html__( 'Subtitle Style', 'consalty-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1' , 'consalty-core' ),
					'style2' => esc_html__( 'Style 2', 'consalty-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Wellcome To Finbuzz', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'sub_title',
				'label'   => esc_html__( 'Sub Title', 'finbuzz-core' ),
				'default' => esc_html__('About Us', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style1','style2') ),
			),
			array(
				'type'    => Controls_Manager::WYSIWYG,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'finbuzz-core' ),
				'default' => esc_html__('Lorem Ipsum has been the industrys standard dummy text ever since printer took a galley. Rimply dummy text of the printing and typesetting industry', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style1','style2') ),
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button',
				'label'   => esc_html__( 'Button', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'button_display',
				'label'       => esc_html__( 'Button Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => false,
				'description' => esc_html__( 'Show or Hide Content. Default: off', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'button_style',
				'label'   => esc_html__( 'Button Style', 'finbuzz-core' ),
				'options' => array(
					'finbuzz-button-1'   => esc_html__( 'Button 1', 'finbuzz-core' ),
					'finbuzz-button-2'   => esc_html__( 'Button 2', 'finbuzz-core' ),
				),
				'default' => 'finbuzz-button-1',
				'condition'   => array( 'button_display' => array( 'yes' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'button_one',
				'label'   => esc_html__( 'Button Text', 'finbuzz-core' ),
				'default' => esc_html__( 'Read More', 'finbuzz-core' ),
				'condition'   => array( 'button_display' => array( 'yes' ) ),
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'one_buttonurl',
				'label'   => esc_html__( 'Button URL', 'finbuzz-core' ),
				'placeholder' => 'https://your-link.com',
				'condition'   => array( 'button_display' => array( 'yes' ) ),
			),	
			array(
				'mode' => 'section_end',
			),
			
			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Style', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .title-text-button .section-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .title-text-button .section-title' => 'color: {{VALUE}}',
				),
			),			
			array(
				'mode' => 'section_end',
			),
			
			// Sub Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_sub_title',
				'label'   => esc_html__( 'Sub Title', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style1','style2') ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'sub_title_typo',
				'label'   => esc_html__( 'Sub Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .title-text-button .subtitle',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sub_title_color',
				'label'   => esc_html__( 'Sub Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .title-text-button .subtitle' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sub_title_border_color',
				'label'   => esc_html__( 'Sub Title Border Color', 'consalty-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .title-text-button .subtitle.style2' => 'border-color: {{VALUE}}',
				),
				'condition'   => array( 'subtitle-style' => array('style2') ),
			),				
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'sub_title_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Sub Title Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .title-text-button .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'mode' => 'section_end',
			),

			// Text style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_text_style',
				'label'   => esc_html__( 'Text style', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
				'condition'   => array( 'style' => array('style1','style2') ),
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'text_typo',
				'label'   => esc_html__( 'Text Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .title-text-button .section-content',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => esc_html__( 'Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .title-text-button .section-content' => 'color: {{VALUE}}',
					'{{WRAPPER}} .title-text-button ul li' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array('style1','style2')),
			),		
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'content_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Content Space', 'finbuzz-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .title-text-button .section-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => array( 'style' => array('style1','style2') ),
			),
			
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		
		switch ( $data['style'] ) {
			case 'style2':
			$template = 'text-with-button-2';
			break;
			default:
			$template = 'text-with-button-1';
			break;
		}
	
		return $this->rt_template( $template, $data );
	}
}