<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\finbuzz\Customizer\Settings;

use radiustheme\finbuzz\Customizer\FinbuzzTheme_Customizer;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Switch_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Heading_Control;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Image_Radio_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class FinbuzzTheme_Header_Settings extends FinbuzzTheme_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_header_controls' ) );
	}

    public function register_header_controls( $wp_customize ) {
		
		// Top Bar Style
		$wp_customize->add_setting( 'top_bar',
            array(
                'default' => $this->defaults['top_bar'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'top_bar',
            array(
                'label' => __( 'Top Bar On/Off', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );
		
        $wp_customize->add_setting( 'top_bar_style',
            array(
                'default' => $this->defaults['top_bar_style'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization'
            )
        );
        $wp_customize->add_control( new Customizer_Image_Radio_Control( $wp_customize, 'top_bar_style',
            array(
                'label' => __( 'Top Bar Layout', 'finbuzz' ),
                'description' => esc_html__( 'You can override this settings only Mobile', 'finbuzz' ),
                'section' => 'header_section',
                'choices' => array(
                    '1' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/topbar.jpg',
                        'name' => __( 'Layout 1', 'finbuzz' )
                    ),
                    '2' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/topbar-2.jpg',
                        'name' => __( 'Layout 2', 'finbuzz' )
                    ),
                    '3' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/topbar-2.jpg',
                        'name' => __( 'Layout 3', 'finbuzz' )
                    ),
                    '4' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/topbar-4.jpg',
                        'name' => __( 'Layout 4', 'finbuzz' )
                    ),                   
                )
            )
        ) );
		// Topbar one option
		$wp_customize->add_setting('top_bar_bgcolor', 
            array(
                'default' => $this->defaults['top_bar_bgcolor'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'top_bar_bgcolor',
            array(
                'label' => esc_html__('Top Bar Background Color', 'finbuzz'),
                'section' => 'header_section', 
				
            )
        ));
		
		$wp_customize->add_setting('top_bar_color', 
            array(
                'default' => $this->defaults['top_bar_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'top_bar_color',
            array(
                'label' => esc_html__('Top Bar Text Color', 'finbuzz'),
                'section' => 'header_section', 
            )
        ));
		$wp_customize->add_setting('top_bar_icon_color', 
            array(
                'default' => $this->defaults['top_bar_icon_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'top_bar_icon_color',
            array(
                'label' => esc_html__('Top Bar Icon Color', 'finbuzz'),
                'section' => 'header_section', 
            )
        ));
        $wp_customize->add_setting('top_barbtn_text_color', 
            array(
                'default' => $this->defaults['top_barbtn_text_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
				'active_callback'   => 'rttheme_is_topbar1_enabled', 	
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'top_barbtn_text_color',
            array(
                'label' => esc_html__('Top Bar Button Text Color', 'finbuzz'),
                'section' => 'header_section', 
				'active_callback'   => 'rttheme_is_topbar1_enabled', 	
            )
        ));
        $wp_customize->add_setting( 'top_bar_phone_show',
            array(
                'default' => $this->defaults['top_bar_phone_show'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
                'active_callback'   => 'rttheme_is_topbar2_3_enabled',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'top_bar_phone_show',
            array(
                'label' => __( 'Topbar Phone', 'finbuzz' ),
                'section' => 'header_section',
                'active_callback'   => 'rttheme_is_topbar2_3_enabled',
            )
        ) );
        /**
         * Heading for Header Variation
         */
        $wp_customize->add_setting('header_variation_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'header_variation_heading', array(
            'label' => __( 'Header Variation', 'finbuzz' ),
            'section' => 'header_section',
        )));
		
		$wp_customize->add_setting( 'mobile_header_menu',
            array(
                'default' => $this->defaults['mobile_header_menu'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'mobile_header_menu',
            array(
                'label' => __( 'Sticky Header', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );
		
		$wp_customize->add_setting( 'tr_header',
            array(
                'default' => $this->defaults['tr_header'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'tr_header',
            array(
                'label' => __( 'Transparent Header', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );
		
		$wp_customize->add_setting( 'header_opt',
            array(
                'default' => $this->defaults['header_opt'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'header_opt',
            array(
                'label' => __( 'Header On/Off', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );
		
        

        // Header Style
        $wp_customize->add_setting( 'header_style',
            array(
                'default' => $this->defaults['header_style'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_radio_sanitization'
            )
        );
        $wp_customize->add_control( new Customizer_Image_Radio_Control( $wp_customize, 'header_style',
            array(
                'label' => __( 'Header Layout', 'finbuzz' ),
                'description' => esc_html__( 'You can override this settings only Mobile', 'finbuzz' ),
                'section' => 'header_section',
                'choices' => array(
                    '1' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/header-1.jpg',
                        'name' => __( 'Layout 1', 'finbuzz' )
                    ),                  
                    '2' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/header-2.jpg',
                        'name' => __( 'Layout 2', 'finbuzz' )
                    ),
                    '3' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/header-3.jpg',
                        'name' => __( 'Layout 3', 'finbuzz' )
                    ),
                    '4' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/header-4.jpg',
                        'name' => __( 'Layout 4', 'finbuzz' )
                    ),
                    '5' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/header-5.jpg',
                        'name' => __( 'Layout 5', 'finbuzz' )
                    ),
                    '6' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/header-6.jpg',
                        'name' => __( 'Layout 6', 'finbuzz' )
                    ),
                    '7' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/header-7.jpg',
                        'name' => __( 'Layout 7', 'finbuzz' )
                    ),
                    '8' => array(
                        'image' => trailingslashit( get_template_directory_uri() ) . 'assets/img/header-8.jpg',
                        'name' => __( 'Layout 8', 'finbuzz' )
                    ),         
                )
            )
        ) );
        

        // Header Info
		$wp_customize->add_setting( 'top_header_text',
        array(
            'default' => $this->defaults['top_header_text'],
            'transport' => 'refresh',
            'sanitize_callback' => 'sanitize_textarea_field',
            )
        );
        $wp_customize->add_control( 'top_header_text',
            array(
                'label' => __( 'Header Text', 'finbuzz' ),
                'section' => 'header_section',
                'type' => 'textarea',
            )
        );
		
        //Header Action
		$wp_customize->add_setting( 'search_icon',
            array(
                'default' => $this->defaults['search_icon'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'search_icon',
            array(
                'label' => __( 'Search Icon', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );
		
		$wp_customize->add_setting( 'vertical_menu_icon',
            array(
                'default' => $this->defaults['vertical_menu_icon'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'vertical_menu_icon',
            array(
                'label' => __( 'Vertical Menu Icon', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );
		      
		$wp_customize->add_setting( 'online_button',
            array(
                'default' => $this->defaults['online_button'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'online_button',
            array(
                'label' => __( 'Make a Claim Button', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );
		
		$wp_customize->add_setting( 'online_button_text',
            array(
                'default' => $this->defaults['online_button_text'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
				'active_callback'   => 'rttheme_is_claim_enabled',
            )
        );
        $wp_customize->add_control( 'online_button_text',
            array(
                'label' => __( 'Button Text', 'finbuzz' ),
                'section' => 'header_section',
                'type' => 'text',
				'active_callback'   => 'rttheme_is_claim_enabled',
            )
        );
		
		$wp_customize->add_setting( 'online_button_link',
            array(
                'default' => $this->defaults['online_button_link'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
				'active_callback'   => 'rttheme_is_claim_enabled',
            )
        );
        $wp_customize->add_control( 'online_button_link',
            array(
                'label' => __( 'Button Link', 'finbuzz' ),
                'section' => 'header_section',
                'type' => 'url',
				'active_callback'   => 'rttheme_is_claim_enabled',
            )
        );

        $wp_customize->add_setting( 'header_team_btn_switch',
            array(
                'default' => $this->defaults['header_team_btn_switch'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'header_team_btn_switch',
            array(
                'label' => __( 'Join Team Button', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );
        $wp_customize->add_setting( 'header_team_btn',
            array(
                'default' => $this->defaults['header_team_btn'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization',
                'active_callback'   => 'rttheme_is_team_btn_enabled',
            )
        );
        $wp_customize->add_control( 'header_team_btn',
            array(
                'label' => __( 'Join Team Button Text', 'finbuzz' ),
                'section' => 'header_section',
                'type' => 'text',
                'active_callback'   => 'rttheme_is_team_btn_enabled',
            )
        );
        $wp_customize->add_setting( 'header_team_button_link',
            array(
                'default' => $this->defaults['header_team_button_link'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_url_sanitization',
				'active_callback'   => 'rttheme_is_team_btn_enabled',
            )
        );
        $wp_customize->add_control( 'header_team_button_link',
            array(
                'label' => __( 'Button Link', 'finbuzz' ),
                'section' => 'header_section',
                'type' => 'url',
				'active_callback'   => 'rttheme_is_team_btn_enabled',
            )
        );

        $wp_customize->add_setting( 'header_hotline_txt',
        array(
            'default' => $this->defaults['header_hotline_txt'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_text_sanitization',
            )
        );
        $wp_customize->add_control( 'header_hotline_txt',
            array(
                'label' => __( 'Header "Call" Text', 'finbuzz' ),
                'section' => 'header_section',
                'type' => 'text',
            )
        );


		$wp_customize->add_setting('resmenu_width',
			array(
				'default'           => $this->defaults['resmenu_width'],
				'transport'         => 'refresh',
				'sanitize_callback' => 'rttheme_text_sanitization'
			)
        );
        $wp_customize->add_control('resmenu_width',
			array(
				'label'   => esc_html__('Mobile Menu Width', 'finbuzz'),
				'section' => 'header_section',
				'type'    => 'text'
			)
        );

        //Header Mobile

        $wp_customize->add_setting('header_mobile_heading', array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        ));
        $wp_customize->add_control(new Customizer_Heading_Control($wp_customize, 'header_mobile_heading', array(
            'label' => __( 'Mobile Header', 'finbuzz' ),
            'section' => 'header_section',
        )));

        $wp_customize->add_setting( 'mobile_header_menu',
            array(
                'default' => $this->defaults['mobile_header_menu'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'mobile_header_menu',
            array(
                'label' => __( 'Mobile Header', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );

       
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'mobile_header_text',
            array(
                'label' => __( 'Header Text', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );

        $wp_customize->add_setting( 'mobile_header_phone',
            array(
                'default' => $this->defaults['mobile_header_phone'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'mobile_header_phone',
            array(
                'label' => __( 'Header Phone', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );


        $wp_customize->add_setting( 'mobile_header_social',
            array(
                'default' => $this->defaults['mobile_header_social'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'mobile_header_social',
            array(
                'label' => __( 'Header Social', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );

        $wp_customize->add_setting( 'mobile_header_make_claim',
            array(
                'default' => $this->defaults['mobile_header_make_claim'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_switch_sanitization',
            )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'mobile_header_make_claim',
            array(
                'label' => __( 'Header Make a Claim Button', 'finbuzz' ),
                'section' => 'header_section',
            )
        ) );
        

    }

}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new FinbuzzTheme_Header_Settings();
}
