<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size = 'finbuzz-size4';
$id 		= get_the_ID();
$content 	= get_the_content();
$content 	= apply_filters( 'the_content', $content );
$content 	= wp_trim_words( get_the_excerpt(), FinbuzzTheme::$options['portfolio_arexcerpt_limit'], '' );

?>
<article id="post-<?php the_ID(); ?>">
	<div class="rtin-item">
		<div class="rtin-figure">
			<a href="<?php the_permalink(); ?>">
				<?php
					if ( has_post_thumbnail() ){
						the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
					} else {
						if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
							echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
						} else {
							echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
						}
					}
				?>
			</a>
		</div>
		<div class="rtin-content">
			<?php if ( FinbuzzTheme::$options['portfolio_ar_category'] ) { ?>
				<?php
					$i = 1;
					$term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
					if($term_lists){ ?>
					   <div class="cat-list">
						<?php foreach ( $term_lists as $term_list ){ 
						$link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php $i++; } ?>
						</div>	
						
			<?php } }?>					
			<h3>
				<a href="<?php echo the_permalink(); ?>">
				<span><?php the_title();?></span>
				</a>
			</h3>
		</div>
		<?php if ( FinbuzzTheme::$options['portfolio_ar_link'] ) { ?>
			<div class="link-shape-box">
				<div class="link-shape">
					<div class="portfolio-btn">
						<?php if ( FinbuzzTheme::$options['portfolio_ar_link'] ) { ?>
						<a href="<?php the_permalink();?>" class="read-more-btn"><i class="fas fa-link"></i></a>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php } ?>
	</div>
</article>