<?php
/**
 * Template Name: Blog 1
 * 
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

// Layout class
if ( FinbuzzTheme::$layout == 'full-width' ) {
	$finbuzz_layout_class = 'col-sm-12 col-12';
}
else{
	$finbuzz_layout_class = FinbuzzTheme_Helper::has_active_widget();
}

$args = array(
	'post_type' => "post",
);

if ( get_query_var('paged') ) {
	$args['paged'] = get_query_var('paged');
}
elseif ( get_query_var('page') ) {
	$args['paged'] = get_query_var('page');
}
else {
	$args['paged'] = 1;
}

$query = new WP_Query( $args );

global $wp_query;
$wp_query = NULL;
$wp_query = $query;
 
get_header(); ?>
<div id="primary" class="content-area">
	<div class="container">
		<div class="row">
			<?php if ( FinbuzzTheme::$layout == 'left-sidebar' ) { get_sidebar(); } ?>
			<div class="<?php echo esc_attr( $finbuzz_layout_class );?>">
				<main id="main" class="site-main">
					<div class="rt-sidebar-sapcer">						
						<?php if ( have_posts() ) :?>
							<?php
								echo '<div class="blog-layout-1 row">';
								while ( have_posts() ) : the_post();
									get_template_part( 'template-parts/content-1', get_post_format() );
								endwhile;
								echo '</div>';
							?>
							<div class="mt50"><?php FinbuzzTheme_Helper::pagination();?></div>
						<?php else:?>
							<?php get_template_part( 'template-parts/content', 'none' );?>
						<?php endif;?>
					</div>
				</main>
			</div>
			<?php if ( FinbuzzTheme::$layout == 'right-sidebar' ) { get_sidebar(); }	?>
		</div>
	</div>
</div>
<?php get_footer(); ?>