<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */
namespace radiustheme\finbuzz\Customizer\Settings;

use radiustheme\finbuzz\Customizer\FinbuzzTheme_Customizer;
use radiustheme\finbuzz\Customizer\Controls\Customizer_Switch_Control;
use WP_Customize_Media_Control;
use WP_Customize_Color_Control;
/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class FinbuzzTheme_Error_Settings extends FinbuzzTheme_Customizer {

	public function __construct() {
	    parent::instance();
        $this->populated_default_data();
        // Add Controls
        add_action( 'customize_register', array( $this, 'register_error_controls' ) );
	}

    public function register_error_controls( $wp_customize ) {
        // Error Page Banner Title
        $wp_customize->add_setting( 'error_title',
            array(
                'default' => $this->defaults['error_title'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'error_title',
            array(
                'label' => __( 'Page Title', 'finbuzz' ),
                'section' => 'error_section',
                'type' => 'text',
            )
        );
		
		$wp_customize->add_setting('error_bodybg', 
            array(
                'default' => $this->defaults['error_bodybg'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'error_bodybg',
            array(
                'label' => esc_html__('Body Background Color', 'finbuzz'),
                'section' => 'error_section', 
            )
        ));
		
		// Background Image
        $wp_customize->add_setting( 'error_bodybanner',
            array(
                'default' => $this->defaults['error_bodybanner'],
                'transport' => 'refresh',
                'sanitize_callback' => 'absint',
            )
        );
        $wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'error_bodybanner',
            array(
                'label' => __( 'Error Body Banner Image', 'finbuzz' ),
                'description' => esc_html__( 'This is the description for the Media Control', 'finbuzz' ),
                'section' => 'error_section',
                'mime_type' => 'image',
                'button_labels' => array(
                    'select' => __( 'Select File', 'finbuzz' ),
                    'change' => __( 'Change File', 'finbuzz' ),
                    'default' => __( 'Default', 'finbuzz' ),
                    'remove' => __( 'Remove', 'finbuzz' ),
                    'placeholder' => __( 'No file selected', 'finbuzz' ),
                    'frame_title' => __( 'Select File', 'finbuzz' ),
                    'frame_button' => __( 'Choose File', 'finbuzz' ),
                )
            )
        ) );
		
         //Error Hide show
		$wp_customize->add_setting( 'error_bg_show',
        array(
            'default' => $this->defaults['error_bg_show'],
            'transport' => 'refresh',
            'sanitize_callback' => 'rttheme_switch_sanitization',
        )
        );
        $wp_customize->add_control( new Customizer_Switch_Control( $wp_customize, 'error_bg_show',
            array(
                'label' => __( 'Error Body  Banner Image', 'finbuzz' ),
                'section' => 'error_section',
            )
        ) );

        // Error Text
		$wp_customize->add_setting( 'ops_text',
            array(
                'default' => $this->defaults['ops_text'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'ops_text',
            array(
                'label' => __( 'OPS Text', 'finbuzz' ),
                'section' => 'error_section',
                'type' => 'text',
            )
        );
        $wp_customize->add_setting( 'error_text1',
            array(
                'default' => $this->defaults['error_text1'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'error_text1',
            array(
                'label' => __( 'Error Text 1', 'finbuzz' ),
                'section' => 'error_section',
                'type' => 'text',
            )
        );
        $wp_customize->add_setting( 'error_text2',
            array(
                'default' => $this->defaults['error_text2'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'error_text2',
            array(
                'label' => __( 'Error Text 2', 'finbuzz' ),
                'section' => 'error_section',
                'type' => 'text',
            )
        );
        // Button Text
        $wp_customize->add_setting( 'error_buttontext',
            array(
                'default' => $this->defaults['error_buttontext'],
                'transport' => 'refresh',
                'sanitize_callback' => 'rttheme_text_sanitization'
            )
        );
        $wp_customize->add_control( 'error_buttontext',
            array(
                'label' => __( 'Button Text', 'finbuzz' ),
                'section' => 'error_section',
                'type' => 'text',
            )
        );
		
		$wp_customize->add_setting('error_text1_color', 
            array(
                'default' => $this->defaults['error_text1_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'error_text1_color',
            array(
                'label' => esc_html__('Error Text 1 Color', 'finbuzz'),
                'section' => 'error_section', 
            )
        ));
		
		$wp_customize->add_setting('error_text2_color', 
            array(
                'default' => $this->defaults['error_text2_color'],
                'type' => 'theme_mod', 
                'capability' => 'edit_theme_options', 
                'transport' => 'refresh', 
                'sanitize_callback' => 'sanitize_hex_color',
            )
        );
        $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'error_text2_color',
            array(
                'label' => esc_html__('Error Text 2 Color', 'finbuzz'),
                'section' => 'error_section', 
            )
        ));
		
		
    }

}

/**
 * Initialise our Customizer settings only when they're required
 */
if ( class_exists( 'WP_Customize_Control' ) ) {
	new FinbuzzTheme_Error_Settings();
}
