<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if( ! function_exists( 'finbuzz_related_service' )){	
	function finbuzz_related_service(){
		$post_id = get_the_id();	
		$number_of_avail_post = '';
		$current_post = array( $post_id );
		# Making ready to the Query ...
		$query_type = FinbuzzTheme::$options['related_post_query'];
		
		$title_length = FinbuzzTheme::$options['related_service_title_limit'] ? FinbuzzTheme::$options['related_service_title_limit'] : '';
		$related_post_number = FinbuzzTheme::$options['related_service_number'];

		$args = array(
			'post_type'				 => 'finbuzz_service',
			'post__not_in'           => $current_post,
			'posts_per_page'         => $related_post_number,
			'no_found_rows'          => true,
			'post_status'            => 'publish',
			'ignore_sticky_posts'    => true,
			'update_post_term_cache' => false,
		);

		# Checking Related Posts Order ----------
		if( FinbuzzTheme::$options['related_post_sort'] ){

			$post_order = FinbuzzTheme::$options['related_post_sort'];

			if( $post_order == 'rand' ){
				$args['orderby'] = 'rand';
			}
			elseif( $post_order == 'views' ){
				$args['orderby']  = 'meta_value_num';
				$args['meta_key'] = 'finbuzz_views';
			}
			elseif( $post_order == 'popular' ){
				$args['orderby'] = 'comment_count';
			}
			elseif( $post_order == 'modified' ){
				$args['orderby'] = 'modified';
				$args['order']   = 'ASC';
			}
			elseif( $post_order == 'recent' ){
				$args['orderby'] = '';
				$args['order']   = '';
			}
		}


		# Get related posts by author ----------
		if( $query_type == 'author' ){
			$args['author'] = get_the_author_meta( 'ID' );
		}

		# Get related posts by tags ----------
		elseif( $query_type == 'tag' ){
			$tags_ids  = array();
			$post_tags = get_the_terms( $post_id, 'post_tag' );

			if( ! empty( $post_tags ) ){
				foreach( $post_tags as $individual_tag ){
					$tags_ids[] = $individual_tag->term_id;
				}
				$args['tag__in'] = $tags_ids;
			}
		}
		# Get related posts by categories ----------
		else{			
			$terms = get_the_terms( $post_id, 'finbuzz_service_category' );
			if($terms){

				if ( $terms && ! is_wp_error( $terms ) ) {			 
					$port_cat_links = array();			 
					foreach ( $terms as $term ) {
						$port_cat_links[] = $term->term_id;
					}
				}			
				$args['tax_query'] = array (
					array (
						'taxonomy' => 'finbuzz_service_category',
						'field'    => 'ID',
						'terms'    => $port_cat_links,
					)
				);
			}


		}

		# Get the posts ----------
		$related_query = new wp_query( $args );
		/*the_carousel*/
		
		
		$count_post = $related_query->post_count;
		if ( $count_post < 4 ) {
			$number_of_avail_post = false;
		} else {
			$number_of_avail_post = true;
		}
		$swiper_data=array(
			'slidesPerView' 	=>2,
			'centeredSlides'	=>false,
			'loop'				=>true,
			'spaceBetween'		=>20,
			'slideToClickedSlide' =>true,
			'slidesPerGroup' => 1,
			'autoplay'				=>array(
				'delay'  => 1,
			),
			'speed'      =>500,
			'breakpoints' =>array(
				'0'    =>array('slidesPerView' =>1),
				'576'    =>array('slidesPerView' =>2),
				'768'    =>array('slidesPerView' =>2),
				'992'    =>array('slidesPerView' =>2),
				'1200'    =>array('slidesPerView' =>3),				
				'1600'    =>array('slidesPerView' =>3)				
			),
			'auto'   =>false
		);

		$swiper_data = json_encode( $swiper_data );
		
		if( $related_query->have_posts() ) { ?>		
		<div class=" rt-related-service zoom-gallery">
			
			<div class="rt-related-slider" data-xld = '<?php echo esc_attr($swiper_data) ;?>'>
				<div class="section-title">
					<?php if ( FinbuzzTheme::$options['service_related_title'] ) { ?>
						<h3 class="related-title"><?php echo wp_kses( FinbuzzTheme::$options['service_related_title'] , 'alltext_allow' );?></h3>
					<?php } ?>
					<?php if ( $count_post > 3 ){ ?>
						<div class="swiper-button">
							<div class="swiper-button-prev"><i class="fas fa-chevron-left"></i></div>
							<div class="swiper-button-next"><i class="fas fa-chevron-right"></i></div>
						</div>
					<?php } ?>
				</div>
				<div class="swiper-wrapper">
					<?php
						while ( $related_query->have_posts() ) {
						$related_query->the_post();
						$trimmed_title = wp_trim_words( get_the_title(), $title_length, '' );
					?>
						<div class="swiper-slide">
							<div class="rtin-item">						
								<div class="rtin-figure">
									<a href="<?php the_permalink(); ?>">
										<?php
											$id = get_the_ID();
											$thumbnail = false;
											if ( has_post_thumbnail() ){
												$post_thumbnail_id = get_post_thumbnail_id( $id );
												$image_attributes = wp_get_attachment_image_src( $post_thumbnail_id , 'finbuzz-size7'  );
												if ( $image_attributes ) : ?>
													<img src="<?php echo esc_attr( $image_attributes[0] ); ?>" width="<?php echo esc_attr( $image_attributes[1] ); ?>" height="<?php echo esc_attr( $image_attributes[2] ); ?>" />
												<?php endif; 
											} else {
												$thumbnail = '<img class="" src="'.FINBUZZ_IMG_URL.'noimage_370X328.jpg" alt="'. the_title_attribute(array('echo'=> false)) .'">';
											}
											echo wp_kses( $thumbnail , 'alltext_allow' );
										?>
									</a>
								</div>
								<div class="rtin-content">							
									<h3><a href="<?php the_permalink(); ?>"><?php echo wp_kses( $trimmed_title , 'alltext_allow' ); ?></a></h3>
								</div>
							</div>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
		<?php }
		wp_reset_postdata();
	}
}
?>