<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

/*-------------------------------------
INDEX
=======================================
#. Container
#. Typography
#. Top Bar
#. Header
#. Banner
#. Footer
#. Widgets
#. Inner Contents
#. Error 404
#. comment
#. Buttons
#. Gradient
#. Single Content
#. Archive Contents
#. Pagination
#. Contact Form 7
#. Single Team

#. Miscellaneous
-------------------------------------*/

$primary_color         = FinbuzzTheme::$options['primary_color']; // #df1c2b
$primary_rgb           = FinbuzzTheme_Helper::hex2rgb( $primary_color ); // 255, 3, 2
$secondary_color       = FinbuzzTheme::$options['secondary_color']; // #fdc902
$secondary_rgb         = FinbuzzTheme_Helper::hex2rgb( $secondary_color ); // 253, 201, 2
$gradient_dark_color   = FinbuzzTheme::$options['gradient_dark_color'];
$gradient_light_color  = FinbuzzTheme::$options['gradient_light_color'];


$container_width	   = FinbuzzTheme::$options['container_width']; // Grid Container width
$menu_offcanvas_color=FinbuzzTheme::$options['menu_offcanvas_color'];
$menu_icon_color=FinbuzzTheme::$options['icon_color'];
$menu_offcanvas_color_tr=FinbuzzTheme::$options['menu_offcanvas_color_tr'];
$menu_icon_color_tr=FinbuzzTheme::$options['search_color_tr'];
$menu_color            = FinbuzzTheme::$options['menu_color'];
$menu_color_tr         = FinbuzzTheme::$options['menu_color_tr'];
$menu_hover_color      = FinbuzzTheme::$options['menu_hover_color'];
$submenu_color         = FinbuzzTheme::$options['submenu_color'];
$submenu_bgcolor       = FinbuzzTheme::$options['submenu_bgcolor'];
$submenu_hover_color   = FinbuzzTheme::$options['submenu_hover_color'];
$submenu_hover_bgcolor = FinbuzzTheme::$options['submenu_hover_bgcolor'];
	

$finbuzz_typo_body     = FinbuzzTheme::$options['typo_body'];
$finbuzz_typo_h1       = FinbuzzTheme::$options['typo_h1'];
$finbuzz_typo_h2       = FinbuzzTheme::$options['typo_h2'];
$finbuzz_typo_h3       = FinbuzzTheme::$options['typo_h3'];
$finbuzz_typo_h4       = FinbuzzTheme::$options['typo_h4'];
$finbuzz_typo_h5       = FinbuzzTheme::$options['typo_h5'];
$finbuzz_typo_h6       = FinbuzzTheme::$options['typo_h6'];


/* = Body Typo Area
=======================================================*/
$typo_body = json_decode( FinbuzzTheme::$options['typo_body'], true );
if ($typo_body['font'] == 'Inherit') {
	$typo_body['font'] = 'Roboto';
} else {
	$typo_body['font'] = $typo_body['font'];
}

/* = Menu Typo Area
=======================================================*/
$typo_menu = json_decode( FinbuzzTheme::$options['typo_menu'], true );
if ($typo_menu['font'] == 'Inherit') {
	$typo_menu['font'] = 'Source Sans Pro';
} else {
	$typo_menu['font'] = $typo_menu['font'];
}

/* = Heading Typo Area
=======================================================*/
$typo_heading = json_decode( FinbuzzTheme::$options['typo_heading'], true );
if ($typo_heading['font'] == 'Inherit') {
	$typo_heading['font'] = 'Source Sans Pro';
} else {
	$typo_heading['font'] = $typo_heading['font'];
}
$typo_h1 = json_decode( FinbuzzTheme::$options['typo_h1'], true );
if ($typo_h1['font'] == 'Inherit') {
	$typo_h1['font'] = '';
} else {
	$typo_h1['font'] = $typo_h1['font'];
}
$typo_h2 = json_decode( FinbuzzTheme::$options['typo_h2'], true );
if ($typo_h2['font'] == 'Inherit') {
	$typo_h2['font'] = '';
} else {
	$typo_h2['font'] = $typo_h2['font'];
}
$typo_h3 = json_decode( FinbuzzTheme::$options['typo_h3'], true );
if ($typo_h3['font'] == 'Inherit') {
	$typo_h3['font'] = '';
} else {
	$typo_h3['font'] = $typo_h3['font'];
}
$typo_h4 = json_decode( FinbuzzTheme::$options['typo_h4'], true );
if ($typo_h4['font'] == 'Inherit') {
	$typo_h4['font'] = '';
} else {
	$typo_h4['font'] = $typo_h4['font'];
}
$typo_h5 = json_decode( FinbuzzTheme::$options['typo_h5'], true );
if ($typo_h5['font'] == 'Inherit') {
	$typo_h5['font'] = '';
} else {
	$typo_h5['font'] = $typo_h5['font'];
}
$typo_h6 = json_decode( FinbuzzTheme::$options['typo_h6'], true );
if ($typo_h6['font'] == 'Inherit') {
	$typo_h6['font'] = '';
} else {
	$typo_h6['font'] = $typo_h6['font'];
}

?>
<?php
/*-------------------------------------
#. Container
---------------------------------------*/
?>
@media ( min-width:1400px ) {
	.container {
		max-width: <?php echo esc_html( $container_width ); ?>px!important;
	}
}
a {
	color: <?php echo esc_html( $primary_color ); ?>;
}


.primary-color {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.secondary-color {
	color: <?php echo esc_html( $secondary_color ); ?>;
}


<?php
/*-------------------------------------
#. Typography
---------------------------------------*/
?>
body {
	color: <?php echo esc_html( FinbuzzTheme::$options['body_color'] ); ?>;
	font-family: '<?php echo esc_html( $typo_body['font'] ); ?>', sans-serif;
	font-size: <?php echo esc_html( FinbuzzTheme::$options['typo_body_size'] ) ?>;
	line-height: <?php echo esc_html( FinbuzzTheme::$options['typo_body_height'] ); ?>;
	font-weight : <?php echo esc_html( $typo_body['regularweight'] ) ?>;
	font-style: normal;
}
h1,h2,h3,h4,h5,h6 {
	font-family: '<?php echo esc_html( $typo_heading['font'] ); ?>', sans-serif;
	font-weight : <?php echo esc_html( $typo_heading['regularweight'] ); ?>;
}

<?php if (!empty($typo_h1['font'])){ ?>
h1 {
	font-family: '<?php echo esc_html( $typo_h1['font'] ); ?>', sans-serif;
	font-weight : <?php echo esc_html( $typo_h1['regularweight'] ); ?>;
}
<?php } ?>
h1 {
	font-size: <?php echo esc_html( FinbuzzTheme::$options['typo_h1_size'] ); ?>;
	line-height: <?php echo esc_html(  FinbuzzTheme::$options['typo_h1_height'] ); ?>;
	font-style: normal;
}
<?php if (!empty($typo_h2['font'])) { ?>
h2 {
	font-family: '<?php echo esc_html( $typo_h2['font'] ); ?>', sans-serif;
	font-weight : <?php echo esc_html( $typo_h2['regularweight'] ); ?>;
}
<?php } ?>
h2 {
	font-size: <?php echo esc_html( FinbuzzTheme::$options['typo_h2_size'] ); ?>;
	line-height: <?php echo esc_html( FinbuzzTheme::$options['typo_h2_height'] ); ?>;
	font-style: normal;
}
<?php if (!empty($typo_h3['font'])) { ?>
h3 {
	font-family: '<?php echo esc_html( $typo_h3['font'] ); ?>', sans-serif;
	font-weight : <?php echo esc_html( $typo_h3['regularweight'] ); ?>;
}
<?php } ?>
h3 {
	font-size: <?php echo esc_html( FinbuzzTheme::$options['typo_h3_size'] ); ?>;
	line-height: <?php echo esc_html(  FinbuzzTheme::$options['typo_h3_height'] ); ?>;
	font-style: normal;
}
<?php if (!empty($typo_h4['font'])) { ?>
h4 {
	font-family: '<?php echo esc_html( $typo_h4['font'] ); ?>', sans-serif;
	font-weight : <?php echo esc_html( $typo_h4['regularweight'] ); ?>;
}
<?php } ?>
h4 {
	font-size: <?php echo esc_html( FinbuzzTheme::$options['typo_h4_size'] ); ?>;
	line-height: <?php echo esc_html(  FinbuzzTheme::$options['typo_h4_height'] ); ?>;
	font-style: normal;
}
<?php if (!empty($typo_h5['font'])) { ?>
h5 {
	font-family: '<?php echo esc_html( $typo_h5['font'] ); ?>', sans-serif;
	font-weight : <?php echo esc_html( $typo_h5['regularweight'] ); ?>;
}
<?php } ?>
h5 {
	font-size: <?php echo esc_html( FinbuzzTheme::$options['typo_h5_size'] ); ?>;
	line-height: <?php echo esc_html(  FinbuzzTheme::$options['typo_h5_height'] ); ?>;
	font-style: normal;
}
<?php if (!empty($typo_h6['font'])) { ?>
h6 {
	font-family: '<?php echo esc_html( $typo_h6['font'] ); ?>', sans-serif;
	font-weight : <?php echo esc_html( $typo_h6['regularweight'] ); ?>;
}
<?php } ?>
h6 {
	font-size: <?php echo esc_html( FinbuzzTheme::$options['typo_h6_size'] ); ?>;
	line-height: <?php echo esc_html(  FinbuzzTheme::$options['typo_h6_height'] ); ?>;
	font-style: normal;
}

<?php
/*-------------------------------------
#. Top Bar
---------------------------------------*/
?>
.topbar-style-2 .header-top-bar,
.topbar-style-3 .header-top-bar{
	background-color: <?php echo esc_html( FinbuzzTheme::$options['primary_color'] ); ?>;
}
<?php if(!empty(FinbuzzTheme::$options['top_bar_bgcolor'])){ ?>
	.topbar-style-1 .header-top-bar,
	.topbar-style-2 .header-top-bar,
	.topbar-style-3 .header-top-bar,
	.topbar-style-4 .header-top-bar{
		background-color: <?php echo esc_html( FinbuzzTheme::$options['top_bar_bgcolor'] ); ?>;
	}
<?php } ?>
<?php if(!empty(FinbuzzTheme::$options['top_bar_color'])){ ?>
	.topbar-style-1 .header-top-bar,
	.topbar-style-2 .header-top-bar,
	.topbar-style-3 .header-top-bar,
	.topbar-style-4 .header-top-bar{
		color: <?php echo esc_html( FinbuzzTheme::$options['top_bar_color'] ); ?>;
	}
<?php } ?>

<?php if(!empty(FinbuzzTheme::$options['top_bar_color'])){ ?>
	.topbar-style-1 .header-top-bar .topbar-left .item-paragraph,
	.topbar-style-2 .header-top-bar  .header-item,
	.topbar-style-2 .header-top-bar .header-item a,
	.topbar-style-3 .header-top-bar  .header-item,
	.topbar-style-3 .header-top-bar .header-item a,
	.topbar-style-4 .header-top-bar a
	{
		color: <?php echo esc_html( FinbuzzTheme::$options['top_bar_color'] ); ?>;
	}
<?php } ?>
<?php if(!empty(FinbuzzTheme::$options['top_bar_icon_color'])){ ?>
	.topbar-right ul .topbar-social a,
	.mobile-top-bar .header-button i,
	.topbar-style-2 .header-top-bar .topbar-right ul .topbar-social a,
	.topbar-style-2 .header-top-bar .header-item i,
	.topbar-style-3 .header-top-bar .topbar-right ul .topbar-social a,
	.topbar-style-3 .header-top-bar .header-item i,
	.topbar-style-4 .header-top-bar .tophead-left .address i,
	.topbar-style-4 .tophead-right .email i,
	.topbar-style-4 .tophead-right .info-phone  i
	{
		color: <?php echo esc_html( FinbuzzTheme::$options['top_bar_icon_color'] ); ?>;
	}
<?php } ?>
.topbar-left .header-button a,
.topbar-style-1 .header-top-bar  .topbar-right .header-right-button .header-btn
{
	color: <?php echo esc_html( FinbuzzTheme::$options['top_barbtn_text_color'] ); ?>;
}
.topbar-style-1 .header-top-bar .topbar-right .header-right-button .header-btn,
.header-style-2 .header-top-right li .header-right-button .header-btn,
.accordion-style-3 .accordion-button.collapsed:before,
.header-style-4 .info-wrap .header-right-button a{
	background-image: linear-gradient(to right, <?php echo esc_html( $gradient_light_color );?> , <?php echo esc_html( $gradient_dark_color );?>);
}
.topbar-style-1 .header-top-bar .topbar-right .header-right-button .header-btn:hover,
.header-style-2 .header-top-right li .header-right-button .header-btn:hover,
.header-style-4 .info-wrap .header-right-button a:hover,
.header-style-4 .info-wrap .header-right-button a:hover
{
	background-image: linear-gradient(to right, <?php echo esc_html(  $gradient_dark_color);?> , <?php echo esc_html( $gradient_light_color );?>);
}
.mobile-top-bar .header-social li a:hover,
.topbar-style-4 .tophead-right .header-button:after{
	background:<?php echo esc_html( $primary_color ); ?>
}
.topbar-right ul .topbar-social a:hover,
.topbar-left .header-button a i,
.header-style-2 .header-top .header-top-middle .header-button a i,
.header-style-4 .info-wrap .search-btn i:hover{
	color:<?php echo esc_html( $primary_color ); ?>
}
.mobile-top-bar .header-button a{
	background-image: linear-gradient(to right, <?php echo esc_html( $gradient_light_color );?> , <?php echo esc_html( $gradient_dark_color );?>);
}

.topbar-style-4 .tophead-left i,
.topbar-style-4 .tophead-right i{
	color:<?php echo esc_html( $primary_color ); ?>
}
<?php
/*-------------------------------------
#. Header
---------------------------------------*/
?>

<?php
/*-------------------------------------
#. Offcanvas menu  icon color
---------------------------------------*/
?>
<?php if(!empty($menu_offcanvas_color)){ ?>
.header-style-1  .header-menu .additional-menu-area span.side-menu-trigger span,
.header-style-2  .header-menu .additional-menu-area span.side-menu-trigger span,
.header-style-2 .additional-menu-area span.side-menu-trigger span::before,
.header-style-3  .header-menu .additional-menu-area span.side-menu-trigger span,
.header-style-5  .header-menu .additional-menu-area span.side-menu-trigger span,
.header-style-3 .additional-menu-area span.side-menu-trigger span::before,
.header-style-1 .additional-menu-area span.side-menu-trigger span::before
{
	background-color: <?php echo esc_html( $menu_offcanvas_color);?>;
}
.header-style-1 .header-icon-area:before,
.header-style-2 .header-icon-area:before
{
	background:<?php echo esc_html( $menu_offcanvas_color);?>;
}
<?php } ?>
<?php if(!empty($menu_offcanvas_color)){ ?>
	.header-style-6  .header-menu .additional-menu-area span.side-menu-trigger span,
	.header-style-7 .additional-menu-area span.side-menu-trigger span,
	.header-style-8 .additional-menu-area span.side-menu-trigger span
	{
		border-color:<?php echo esc_html( $menu_offcanvas_color);?>;
	}
<?php } ?>

<?php if(!empty($menu_offcanvas_color)){ ?>
	.header-style-6 .header-icon-area:before
	{
		background:<?php echo esc_html( $menu_offcanvas_color);?>;
	}
<?php } ?>

<?php
/*-------------------------------------
#. Offcanvas menu transparent icon color
---------------------------------------*/
?>
<?php if(!empty($menu_offcanvas_color_tr)){ ?>
.header-style-1.trheader  .header-menu .additional-menu-area span.side-menu-trigger span,
.header-style-2.trheader  .header-menu .additional-menu-area span.side-menu-trigger span,
.header-style-5.trheader  .header-menu .additional-menu-area span.side-menu-trigger span,
.header-style-2.trheader .additional-menu-area span.side-menu-trigger span::before,
.header-style-3.trheader  .header-menu .additional-menu-area span.side-menu-trigger span,
.header-style-3.trheader .additional-menu-area span.side-menu-trigger span::before,
.header-style-1.trheader  .additional-menu-area span.side-menu-trigger span::before
{
	background-color: <?php echo esc_html( $menu_offcanvas_color_tr );?>;
}
<?php } ?>

<?php if(!empty($menu_offcanvas_color_tr)){ ?>
	.header-style-6.trheader  .header-menu .additional-menu-area span.side-menu-trigger span,
	.header-style-7.trheader  .header-menu .additional-menu-area span.side-menu-trigger span,
	.header-style-8.trheader  .header-menu .additional-menu-area span.side-menu-trigger span
	{
		border-color: <?php echo esc_html( $menu_offcanvas_color_tr );?>;
	}
<?php } ?>
<?php if(!empty($menu_offcanvas_color_tr)){ ?>
	.header-style-6.trheader .header-icon-area:before,
	.header-style-7.trheader .header-icon-area:before,
	.header-style-8.trheader .header-icon-area:before
	{
		background:<?php echo esc_html( $menu_offcanvas_color_tr);?>;
	}
<?php } ?>

<?php
/*-------------------------------------
#. Flat Icon  Color
---------------------------------------*/
?>
<?php if(!empty($menu_icon_color)){ ?>
.header-style-1 .info-wrap li.search-btn i:before,
.header-style-3 .info-wrap li.search-btn i:before,
.header-style-2 .menu-wrap .info-wrap .header-icon-area .search-icon i,
.main-navigation .menu .menu-item-has-children:after,
.header-style-4 .info-wrap .search-btn i,
.header-style-6 .header-icon-area .search-icon a i,
.header-style-5 .menu-full-wrap .info-wrap .search-icon a,
.header-style-7 .info-wrap .info .info-text i,
.header-style-7 .header-icon-area .search-icon a,
.header-style-8 .info-wrap .header-3-right .header-button i,
.header-style-8 .header-style-8-menu .menu-wrap .info-wrap .header-icon-area .search-icon a i
{
	color:<?php echo esc_html( $menu_icon_color); ?>;
}
<?php } ?>

<?php
/*-------------------------------------
#. Flat Icon Transparent Color
---------------------------------------*/
?>
<?php if(!empty($menu_icon_color_tr)){ ?>
.trheader .header-icon-area:before,
.header-style-1.trheader .info-wrap .search-btn i:before,
.header-style-4.trheader .info-wrap .search-btn i,
.header-style-3.trheader .info-wrap .search-btn i:before,
.header-style-2.trheader .menu-wrap .info-wrap .header-icon-area .search-icon i,
.header-style-1.trheader ul.info-wrap .header-number .media .item-icon,
.trheader .header-top-right li .media .item-icon,
.trheader.header-style-5 .menu-full-wrap .info-wrap .search-icon a,
.header-style-6.trheader .header-icon-area .search-icon a i,
.header-style-7.trheader .header-icon-area .search-icon a,
.header-style-7.trheader .info-wrap .info .info-text i,
.header-style-8.trheader .info-wrap .header-3-right .header-button i,
.header-style-8.trheader .header-style-8-menu .menu-wrap .info-wrap .header-icon-area .search-icon a i
{
	color:<?php echo esc_html( $menu_icon_color_tr); ?>;
}
<?php } ?>

.header-style-7 .menu-layout7,
.header-style-8 .header-style-8-menu .menu-wrap,
.rt-sticky .header-style-8-menu
{
	background-color:<?php echo esc_html( $primary_color ); ?>;
}
.header-style-8.trheader .header-area .header-menu.rt-sticky{
	background:transparent;
	box-shadow:none
}
.header-style-7 .menu-layout7.rt-sticky {
	background: rgba(<?php echo esc_html( $primary_rgb );?>, 0.95);
}
.trheader.header-style-7 .menu-layout7.rt-sticky{
	background: rgba(<?php echo esc_html( $primary_rgb );?>, 0.95);
}
.header-style-8 .header-top-8-wrap .header-info-wrap i{
	color:<?php echo esc_html( $primary_color ); ?>;
}
<?php // Main Menu ?>
.site-header .main-navigation nav ul li a {
	font-family: '<?php echo esc_html( $typo_menu['font'] ); ?>', sans serif;
	font-size: <?php echo esc_html( FinbuzzTheme::$options['typo_menu_size'] ) ?>;
	line-height: <?php echo esc_html( FinbuzzTheme::$options['typo_menu_height'] ); ?>;
	font-weight : <?php echo esc_html( $typo_menu['regularweight'] ) ?>;
	<?php if(!empty($menu_color)){ ?>
	color: <?php echo esc_html( $menu_color ); ?>;
	<?php } ?>
	font-style: normal;
}
<?php if(!empty($menu_hover_color)){ ?>
.site-header .main-navigation ul li.mega-menu ul:after
{
	background:<?php echo esc_html( $menu_hover_color );?>;
}
<?php } ?>
.site-header .main-navigation ul li ul li a {
	font-family: '<?php  echo esc_html( $typo_menu['font'] ); ?>', sans serif;
	font-size: <?php  echo esc_html( FinbuzzTheme::$options['typo_submenu_size'] ) ?>;
	line-height: <?php  echo esc_html( FinbuzzTheme::$options['typo_submenu_height'] ); ?>;

	color: <?php  echo esc_html( $submenu_color ); ?>;
	font-style: normal;
}
.mean-container .mean-nav ul li a {
	font-family: '<?php  echo esc_html( $typo_menu['font'] ); ?>', sans serif;
	font-size: <?php  echo esc_html( FinbuzzTheme::$options['typo_submenu_size'] ) ?>;
	line-height: <?php  echo esc_html( FinbuzzTheme::$options['typo_submenu_height'] ); ?>;
	font-weight : <?php  echo esc_html( $typo_menu['regularweight'] ) ?>;
	font-style: normal;
}

<?php if(!empty($menu_hover_color)) { ?>
	.rt-slide-nav .offscreen-navigation li.current-menu-item > a,
	.rt-slide-nav .offscreen-navigation li.current-menu-parent > a,
	.rt-slide-nav .offscreen-navigation nav > ul > li ul.sub-menu li:hover a, 
	.rt-slide-nav .offscreen-navigation li:hover > a
	{
		color: <?php echo esc_html( $menu_hover_color );?>;
	}
	.rt-slide-nav .offscreen-navigation ul li:hover > a:before{
		background-color: <?php echo esc_html( $menu_hover_color );?>;
	}
<?php } ?>

<?php if(!empty($menu_color)){ ?>
.header-style-1 .site-header .rt-sticky-menu .main-navigation nav > ul > li > a,
.header-style-6 .site-header .rt-sticky-menu .main-navigation nav > ul > li > a,
.header-style-8 .header-style-8-menu .menu-wrap .info-wrap .header-3-right a
{
	color: <?php echo esc_html( $menu_color ); ?>;
}
<?php } ?>

<?php if(!empty($menu_color)){ ?>
	.header-menu .info-wrap .info-text a,
	.header-style-7 .site-header  .main-navigation nav > ul > li > a,
	.header-style-8 .site-header  .main-navigation nav > ul > li > a
	{
		color: <?php echo esc_html( $menu_color ); ?>;
	}
<?php } ?>

<?php if(!empty($menu_hover_color)){ ?>
.header-style-1 .site-header .rt-sticky-menu .main-navigation nav > ul > li > a:hover,
.header-style-3 .site-header .rt-sticky-menu .main-navigation nav > ul > li > a:hover,
.header-style-4 .site-header .rt-sticky-menu .main-navigation nav > ul > li > a:hover,
.header-style-5 .site-header .rt-sticky-menu .main-navigation nav > ul > li > a:hover,
.header-style-6 .site-header .rt-sticky-menu .main-navigation nav > ul > li > a:hover,
.header-style-7 .site-header .rt-sticky .main-navigation ul.menu > li.current-menu-item > a,
.header-style-2 .site-header .rt-sticky-menu .main-navigation nav > ul > li > a:hover{
	color: <?php echo esc_html( $menu_hover_color ); ?>;
}
<?php } ?>
<?php if(!empty($menu_hover_color)) { ?>
	.site-header .main-navigation nav ul li a.active,
	.header-style-7 .site-header  .main-navigation nav > ul > li > a:hover,
	.header-style-8 .site-header  .main-navigation nav > ul > li > a:hover,
	.header-style-7 .site-header .main-navigation nav > ul > li.current-menu-item > a,
	.header-style-8 .site-header .main-navigation nav > ul > li.current-menu-item > a{
		color: <?php echo esc_html( $menu_hover_color );?>;
	}
<?php } ?>

.trheader .site-header .main-navigation .menu > li > a,
.header-style-1.trheader ul.info-wrap .header-number .media .media-body .item-label,
.header-style-1.trheader ul.info-wrap .header-number .media .media-body .item-number,
.trheader .header-top-middle .item-paragraph,
.header-style-5.trheader .header-number .media .media-body a,
.header-style-5.trheader .header-number .media .media-body .item-label,
.header-style-2.trheader .header-top .header-top-middle .header-button a,
.header-style-2.trheader .header-top-right li .media .media-body .item-label,
.header-style-7 .header-menu .info-wrap .info-text a,
.header-style-8.trheader .header-top-8-wrap .header-info-wrap span,
.header-style-8.trheader .header-top-8-wrap .header-info-wrap a,
.header-style-2.trheader .header-top-right li .media .media-body a{
	color: <?php echo esc_html( $menu_color_tr );?>!important;
}

.trheader .main-navigation .menu .menu-item-has-children:after{
	color:<?php echo esc_html( $menu_color_tr );?>;
}
.header-style-4 .info-wrap .search-btn i:hover{
	color: <?php echo esc_html( $primary_color ); ?>;
}
<?php if(!empty($menu_color)){ ?>
.header-style-1 .site-header  .main-navigation nav > ul > li > a
{
	color: <?php echo esc_html( $menu_color ); ?>;
}
<?php } ?>
<?php if(!empty($menu_hover_color)) { ?>
.header-style-1 .site-header  .main-navigation nav > ul > li > a:hover,
.header-style-2 .site-header  .main-navigation nav > ul > li > a:hover,
.header-style-3 .site-header  .main-navigation nav > ul > li > a:hover,
.header-style-4 .site-header  .main-navigation nav > ul > li > a:hover,
.header-style-5 .site-header  .main-navigation nav > ul > li > a:hover,
.header-style-6 .site-header  .main-navigation nav > ul > li > a:hover,
.header-style-7 .site-header  .main-navigation nav > ul > li > a:hover,
.header-style-8 .site-header  .main-navigation nav > ul > li > a:hover
{
	color: <?php echo esc_html( $menu_hover_color ); ?>;
}
<?php } ?>
<?php if(!empty($menu_hover_color)) { ?>
.site-header .main-navigation ul.menu > li.current-menu-item > a::before{
	background-color: <?php echo esc_html( $menu_hover_color ); ?>;
}
<?php } ?>
<?php if(!empty($menu_color)){ ?>
.site-header .main-navigation nav ul li a
{
	color: <?php echo esc_html( $menu_color ); ?>;
}
<?php } ?>
.site-header .main-navigation ul li ul li a
{
	color: <?php echo esc_html( $submenu_color ); ?>;
}
.additional-menu-area .sidenav-social span a:hover i,
.additional-menu-area .sidenav ul li a:hover,
.additional-menu-area .sidenav .closebtn{
	color: <?php echo esc_html( $primary_color ); ?>;
}

.header-style-5.trheader .header-area .header-menu.rt-sticky{
	background:<?php echo esc_html( $primary_color ); ?>;
}
.header-style-5 .header-area .header-menu.rt-sticky{
	background:<?php echo esc_html( $primary_color ); ?>;
}
<?php // Submenu ?>
.site-header .main-navigation ul li ul li,
.site-header .main-navigation ul li ul{
	background-color: <?php echo esc_html( $submenu_bgcolor ); ?>;
}
.site-header .main-navigation ul.menu li ul.sub-menu li:hover {
	background-color: <?php echo esc_html( $submenu_hover_bgcolor ); ?>;
}
.site-header .main-navigation ul.menu li ul.sub-menu li:hover:after{
	color:#111111;
}
.site-header .main-navigation ul li.mega-menu ul.sub-menu li a:hover,
.site-header .main-navigation ul li ul li a:hover:before,
.site-header .main-navigation ul li ul li a::before {
	color: <?php echo esc_html( $submenu_hover_color ); ?>;
}
.site-header .main-navigation ul.menu li ul.sub-menu li a:hover {
	color: <?php echo esc_html( $submenu_hover_color ); ?>;
}

<?php // Multi Column Menu ?>
.site-header .main-navigation ul li.mega-menu > ul.sub-menu {
	background-color: <?php echo esc_html( $submenu_bgcolor ); ?>
}
.site-header .main-navigation ul li.mega-menu ul.sub-menu li a {
	color: <?php echo esc_html( $submenu_color ); ?>
}
.site-header .main-navigation ul li.mega-menu > ul.sub-menu li:hover:before
 {
	color: <?php echo esc_html( $submenu_hover_color ); ?>;
}

.site-header .main-navigation ul li ul:after,
.site-header .main-navigation ul  li.mega-menu >  ul:after
{
	background:<?php echo esc_html( $primary_color ); ?>;
}
<?php // Mean Menu ?>
.mean-container a.meanmenu-reveal,
.mean-container .mean-nav ul li a.mean-expand {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.mean-container a.meanmenu-reveal span {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.mean-container .mean-bar {	
	border-color: <?php echo esc_html( $primary_color ); ?>;
}
<?php if(!empty($menu_hover_color)){ ?>
.mean-container .mean-nav ul li a:hover,
.mean-container .mean-nav > ul > li.current-menu-item > a {
	color: <?php echo esc_html( $menu_hover_color ); ?>;
}
<?php } ?>
.mean-container .mean-nav ul li.current_page_item > a,
.mean-container .mean-nav ul li.current-menu-item > a,
.mean-container .mean-nav ul li.current-menu-parent > a {
	color: <?php echo esc_html( $primary_color );?>;
}
<?php // Header icons ?>
.header-style-1 ul.info-wrap .header-number .media .item-icon {
	color: <?php echo esc_html( $primary_color );?>;
}
<?php if(!empty($menu_hover_color)){ ?>
.additional-menu-area a.side-menu-trigger:hover,
.trheader.non-stick .additional-menu-area a.side-menu-trigger:hover {
	color: <?php echo esc_html( $menu_hover_color );?>;
}
<?php } ?>
.site-header .search-box .search-text {
	border-color: <?php echo esc_html( $primary_color );?>;
}
<?php // Header Layout 1 ?>
.header-style-1 .site-header .header-top .icon-left {
	border-color: <?php echo esc_html( $secondary_color ); ?>;
}
.header-style-1.trheader .rt-sticky ul.info-wrap .header-number .media .item-icon
{
	color:<?php echo esc_html( $primary_color );?>
}
<?php if(!empty($menu_hover_color)){ ?>
.header-style-1 .menu-wrap .main-navigation  .menu li.current-menu-item > a,
.site-header .rt-sticky .main-navigation ul.menu > li.current-menu-item > a,
.site-header  .main-navigation ul.menu > li.current-menu-item > a
{
	color: <?php echo esc_html( $menu_hover_color );?>;
}
<?php } ?>
<?php // Sticky Menu ?>
.rt-sticky-menu-wrapper {
	border-color: <?php echo esc_html( $primary_color ); ?>
}
.header-style-6.trheader .header-area .header-menu.rt-sticky{
	background-color:<?php echo esc_html( $primary_color ); ?>;
}
<?php if(!empty(FinbuzzTheme::$options['sticky_menu_color'])){?>
	.site-header .rt-sticky .main-navigation nav > ul > li > a,
	.trheader .site-header .rt-sticky .main-navigation .menu > li > a,
	.header-style-1.trheader .rt-sticky ul.info-wrap .header-number .media .media-body .item-number,
	.header-style-4.trheader .rt-sticky .info-wrap .search-btn i,
	.header-style-8 .rt-sticky .header-style-8-menu .menu-wrap .info-wrap .header-3-right a
	{
		color:<?php echo esc_html( FinbuzzTheme::$options['sticky_menu_color'] ); ?>!important;
	}
<?php } ?>
<?php
/*-------------------------------------
#. Banner
---------------------------------------*/
?>
.entry-banner .entry-banner-content h1 {
	color: <?php echo esc_html( FinbuzzTheme::$options['banner_heading_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb span a,
.breadcrumb-trail ul.trail-items li a {
	color: <?php echo esc_html( FinbuzzTheme::$options['breadcrumb_link_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb span a:hover,
.breadcrumb-trail ul.trail-items li a:hover {
	color: <?php echo esc_html( FinbuzzTheme::$options['breadcrumb_link_hover_color'] );?>;
}
.breadcrumb-trail ul.trail-items li,
.entry-banner .entry-breadcrumb .delimiter,
.entry-banner .entry-breadcrumb .dvdr {
	color: <?php echo esc_html( FinbuzzTheme::$options['breadcrumb_seperator_color'] );?>;
}
.breadcrumb-area .entry-breadcrumb > span:last-child,
.breadcrumb-trail ul.trail-items li > span {
	color: <?php echo esc_html( FinbuzzTheme::$options['breadcrumb_active_color'] );?>;
}
.entry-banner:after {
    background: rgba(0, 0, 0, <?php  echo esc_html( FinbuzzTheme::$options['banner_bg_opacity'] ); ?>);
}
.entry-banner .entry-banner-content {
	padding-top: <?php  echo esc_html( FinbuzzTheme::$options['banner_top_padding'] ); ?>px;
	padding-bottom: <?php  echo esc_html( FinbuzzTheme::$options['banner_bottom_padding'] ); ?>px;
}
<?php
/*-------------------------------------
#. Footer
---------------------------------------*/
?> 
a.scrollup {
	background-color: <?php echo esc_html( $primary_color ); ?>;
} 
a.scrollup:hover {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.footer-top-area {
	background-color: <?php echo esc_html( FinbuzzTheme::$options['fbgcolor'] ); ?>;
	
}
<?php if(!empty(FinbuzzTheme::$options['f4bgcolor'])){ ?>
    .footer-style-4 .footer-top-area:before,
	.footer-style-5 .footer-area .footer-top-area,
	.footer-style-5 .footer-area{
		background:<?php echo esc_html( FinbuzzTheme::$options['f4bgcolor'] ); ?>;
	}
<?php } ?>
<?php if(!empty(FinbuzzTheme::$options['f4bg_bottom_color'])){ ?>
	.footer-style-4 .footer-bottom{
		background:<?php echo esc_html( FinbuzzTheme::$options['f4bg_bottom_color'] ); ?>;
	}
<?php } ?>	
<?php if(!empty(FinbuzzTheme::$options['footer_color'])){ ?>
	.footer-top-area,
	.footer-top-area .corporate-address li,
	.footer-top-area .corporate-address li i,
	.footer-style-3 .footer-top-area.has-footer-img,
	.footer-style-3 .footer-top-area.has-footer-img .corporate-address li,
	.footer-style-4 .footer-bottom .copyright-wrap .copyright,
	.footer-style-5 .footer-area .copyright_wrap,
	.footer-style-3 .footer-top-area.has-footer-img .copyright_wrap .copyright {
		color: <?php echo esc_html( FinbuzzTheme::$options['footer_color'] ); ?>!important;
	}
<?php } ?>
<?php if(!empty(FinbuzzTheme::$options['footer_title_color'])){ ?>
	.footer-top-area .widget .widgettitle,
	.footer-style-4 .footer-top-area .widget .widgettitle,
	.footer-style-5 .footer-top-area .widget .widgettitle,
	.footer-style-3 .footer-top-area.has-footer-img .widget .widgettitle {
		color: <?php echo esc_html( FinbuzzTheme::$options['footer_title_color'] ); ?>;
	}
<?php } ?>
.footer-area .widgettitle:after,
.footer-area .mc4wp-form .mc4wp-form-fields .mc4-subscriber button{
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.footer-area .widgettitle:before{
	background-color: <?php echo esc_html( $secondary_color ); ?>;
}
<?php if(!empty(FinbuzzTheme::$options['footer_link_color'])){ ?> 
.footer-top-area .widget a,
 .footer-area .copyright a,
 .footer-style-3 .footer-top-area.has-footer-img .copyright_wrap .copyright a,
.footer-top-area .widget ul.menu li a:before,
.footer-top-area .widget_archive li a:before,
.footer-top-area ul li.recentcomments a:before,
.footer-top-area ul li.recentcomments span a:before,
.footer-top-area .widget_categories li a:before,
.footer-top-area .widget_pages li a:before,
.footer-top-area .widget_meta li a:before,
.footer-top-area .widget_recent_entries ul li a:before,
.footer-top-area .widget ul.menu > li a,
.footer-style-4 .footer-bottom .copyright-wrap .copyright a,
.footer-style-5 .footer-bottom .copyright-wrap .copyright a,
.footer-style-4 .footer-bottom .footer-menu li a,
.footer-style-5 .footer-top-area .widget ul.menu li a:before,
.footer-style-3 .footer-top-area.has-footer-img .widget ul.menu li a,
.footer-style-4 .footer-top-area .widget ul.menu li a,
.footer-style-5 .footer-top-area .widget ul.menu li a {
	color: <?php echo esc_html( FinbuzzTheme::$options['footer_link_color'] ); ?>;
}
<?php } ?>

<?php if(!empty(FinbuzzTheme::$options['footer_link_color'])){ ?>
	.footer-top-area .widget_finbuzz_address ul li a,
	.footer-style-4 .footer-top-area .corporate-address li,
	.footer-style-4 .footer-top-area .corporate-address li a,
	.footer-style-3 .footer-top-area.has-footer-img .corporate-address li,
	.footer-style-3 .footer-top-area.has-footer-img .corporate-address li a,
	.footer-style-3 .footer-top-area .corporate-address li a,
	.footer-style-5 .footer-top-area .corporate-address li,
	.footer-style-5 .footer-area .copyright_wrap .copyright a,
	.footer-style-5 .footer-top-area .corporate-address li a{
		color: <?php echo esc_html( FinbuzzTheme::$options['footer_link_color'] ); ?>!important;
	}
<?php } ?>	
	

<?php if(!empty(FinbuzzTheme::$options['footer_link_hover_color'])){ ?> 
.footer-top-area .widget a:hover,
.footer-top-area .widget a:active,
.footer-style-4 .footer-top-area .copyright_wrap .copyright a:hover,
.footer-style-5 .footer-top-area .copyright_wrap .copyright a:hover,
.footer-style-3 .footer-top-area.has-footer-img .copyright_wrap .copyright a:hover,
.footer-style-1 .footer-area .copyright a:hover,
.footer-top-area .widget ul.menu li a:hover:before,
.footer-top-area .widget_archive li a:hover:before,
.footer-style-4 .footer-bottom .copyright-wrap .copyright a:hover,
.footer-top-area .widget_categories li a:hover:before,
.footer-top-area .widget_pages li a:hover:before,
.footer-top-area .widget_meta li a:hover:before,
.footer-style-4 .footer-bottom .footer-menu li a:hover,
.footer-top-area .widget_recent_entries ul li a:hover:before,
.footer-top-area .widget ul.menu > li a:hover,
.footer-top-area .widget ul.menu li a:hover:before,
.footer-top-area .widget ul.menu > li a:hover:before,
.footer-style-3 .footer-top-area.has-footer-img .widget ul.menu li a:hover,
.footer-style-3 .footer-top-area.has-footer-img .widget ul.menu li a:hover:before,
.footer-style-4 .footer-top-area .widget ul.menu li a:hover,
.footer-style-5 .footer-top-area .widget ul.menu li a:hover,
.footer-style-4 .footer-top-area .widget ul.menu li a:hover:before,
.footer-style-5 .footer-top-area .widget ul.menu li a:hover:before,
.footer-area .copyright a:hover,
.footer-style-3 .footer-top-area.has-footer-img .corporate-address li a:hover,
.footer-style-4 .footer-top-area  .corporate-address li a:hover,
.footer-style-5 .footer-top-area  .corporate-address li a:hover,
.footer-top-area .widget_finbuzz_address ul li a:hover {
	color: <?php echo esc_html( FinbuzzTheme::$options['footer_link_hover_color'] ); ?>!important;
}
<?php } ?>
<?php if(!empty(FinbuzzTheme::$options['footer_color'])){ ?>
	.footer-style-2 .footer-top-area{
		color: <?php echo esc_html( FinbuzzTheme::$options['footer_color'] ); ?>;
	}
<?php } ?>
.footer-style-2 .footer-top-area .rt_footer_social_widget .footer-social li a:hover {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.rt-box-title-1 span {
	border-top-color: <?php echo esc_html( $primary_color ); ?>;
}

.footer-area .rt_footer_social_widget .footer-social li a:hover{
	background:<?php echo esc_html( $primary_color ); ?>;
}

<?php if(!empty(FinbuzzTheme::$options['foverlay'])){ ?>
	.footer-style-3 .footer-area .footer-top-area.has-footer-img::before{
		background:<?php echo FinbuzzTheme::$options['foverlay']; ?>
	}
<?php } ?>
<?php
/*-------------------------------------
#. Widgets
---------------------------------------*/
?>

.widget_finbuzz_download .download-list .item .item-icon2 a,
.sidebar-widget-area .widget_recent_comments ul  li.recentcomments:hover::after,
.sidebar-widget-area .widget_recent_comments ul  li.recentcomments:hover::before
{
	background:<?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .widget ul li a:hover {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .widget ul li:before,
.blog-date:after,
.sidebar-widget-area .widget h3.widgettitle::after  {
	background:<?php echo esc_html( $primary_color ); ?>;
} 
.rt-post-box .post-box-style .media .media-body ul li a,
.post-box-style .post-box-date ul li i,
.post-box-style .media-body h3 a:hover,
.feature-post-layout .entry-title a:hover,
.post-tab-layout .post-box-date ul li:first-child,
.post-tab-layout .entry-title a:hover,
.blog-box .entry-content ul li a:hover,
.blog-box .entry-content h3:hover a,
.rt_widget_recent_entries_with_image .topic-box .posted-date i
{
	color:<?php echo esc_html( $primary_color ); ?>;
}
.search-form input:focus
{
	border-color: <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .rt_widget_recent_entries_with_image .media-body .posted-date a,
.sidebar-widget-area .widget ul li.active a,
.sidebar-widget-area .widget ul li.active a:before,
.footer-top-area .search-form input.search-submit,
.footer-top-area ul li:before,
.footer-top-area ul li a:before,
.author-widget .phone-number-layout .phone a:hover
{
	color: <?php echo esc_html( $primary_color ); ?>;
}

.footer-top-area .search-form input.search-submit,
.footer-top-area ul li a:before,
.footer-top-area .stylish-input-group .input-group-addon button i {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.footer-top-area .stylish-input-group .input-group-addon button:hover {
	background: <?php echo esc_html( $primary_color ); ?>;
}
.rt-box-title-1,
 .author-widget .phone-number-layout .author-icon > div{
	background-color: <?php echo esc_html( $primary_color ); ?>;
}

.sidebar-widget-area .widget_recent_comments ul li.recentcomments:hover > span:before,
.footer-area .mc4wp-form .mc4wp-form-fields .mc4-subscriber button:hover,
.sidebar-widget-area .widget h3.widgettitle::before,
.sidebar-widget-area .widget_block h2:before{
	background-color: <?php echo esc_html( $secondary_color ); ?>;
}
.feature-post-layout .post-box-date ul li.feature-date,
.rt_widget_recent_entries_with_image .topic-box .widget-recent-post-title a:hover,
.single-post .entry-content ul li a:hover,
.blog .entry-content ul li a:hover {
	color: <?php echo esc_html( $primary_color ); ?>;
}
.rt_widget_recent_entries_with_image .topic-box .post-date1 span
{
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .mc4wp-form .form-group .item-btn {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .mc4wp-form .form-group .item-btn:hover {
	background-color: <?php echo esc_html( $secondary_color ); ?>;
}
.post-tab-layout ul.btn-tab li .active {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.call-to-action-content .rtin-des .item-btn:hover,
.download-list ul li a{
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.download-list ul li a:hover
{
	background-color: <?php echo esc_html( $secondary_color ); ?>;
}
.sidebar-widget-area .widget_calendar td a,
.sidebar-widget-area .widget_calendar a:hover,
 .download-list .item .item-icon i
{
	color: <?php echo esc_html( $primary_color ); ?>;
}
 .menu-service-menu-container #menu-service-menu .service-sidebar-menu:after,
.download-list .item:after{
	background-color:<?php echo esc_html( $primary_color ); ?>;
}
 .menu-service-menu-container #menu-service-menu .service-sidebar-menu a::after{
	border-color:<?php echo esc_html( $primary_color ); ?>;
}
.single-service-1   .elementor-widget-container:after{
	border-bottom: 55px solid <?php echo esc_html( $primary_color ); ?>; 
}
.sidebar-widget-area .widget_recent_comments ul li.recentcomments:hover::before,
.wp-block-archives li a:hover:before,
.wp-block-categories li a:hover:before,
.wp-block-archives li:hover{
	color:<?php echo esc_html( $primary_color ); ?>!important;
}

.widget_block .wp-block-latest-comments .wp-block-latest-comments__comment a:hover{
	color:<?php echo esc_html( $primary_color ); ?>;
}
<?php
/*-------------------------------------
#. Inner Contents
---------------------------------------*/
?>
.entry-footer .about-author .media-body .author-title,
.entry-title h1 a {
	color: <?php echo esc_html( $primary_color );?>;
}
.comments-area .main-comments .replay-area a:hover {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.blog-style-2 .readmore-btn:hover {
	background-color: <?php echo esc_html( $primary_color );?>;
	color: #ffffff;
}

.entry-header .entry-meta .post-date:after,
blockquote:before,
.single-post .single-post-list li:before,
.entry-footer .item-tags a:hover{
	background:<?php echo esc_html( $primary_color );?>;
}
.entry-footer .post-share .share-links a:hover,
.post-navigation .post-nav-title a:hover,
.rt-related-post-info .post-date ul li.post-relate-date,
.post-navigation .next-article a:hover,
.post-navigation .prev-article a:hover{
	color:<?php echo esc_html( $primary_color );?>
}

<?php
/*-------------------------------------
#. Error 404
---------------------------------------*/
?>
.error-page-area {
    background-color: <?php echo esc_html( FinbuzzTheme::$options['error_bodybg'] );?>;
}
.error-page-area .text-1 {	
	color: <?php echo esc_html( FinbuzzTheme::$options['error_text1_color'] );?>;
}
.error-page-area .text-2 {
	color: <?php echo esc_html( FinbuzzTheme::$options['error_text2_color'] );?>;
}
.error-page-area .error-page-content .go-home a:after {
    background: <?php echo esc_html( $primary_color );?>;
}
.error-page-area .error-page-content .go-home a:before {
    background: <?php echo esc_html( $secondary_color );?>;
}
.error-btn{
	background: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-------------------------------------
#. Comment
---------------------------------------*/
?>
.comments-area > h4:before,
.comment-respond > h4:before{
	background: <?php echo esc_html( $secondary_color);?>;
}
.comments-area > h4::after,
.comment-respond > h4:after{
	background: <?php echo esc_html( $primary_color );?>;
}
<?php
/*------------------------------------
#. Buttons
------------------------------------*/
?>

.submit-btn:hover {
	background-color: <?php echo esc_html( $secondary_color );?>;
}
.footer-top-area .mc4wp-form .form-group .item-btn:hover {
	background-color: <?php echo esc_html( $secondary_color );?>;
}
.submit-btn:after {
    background: <?php echo esc_html( $primary_color );?>;
}
.submit-btn:before {
    background: <?php echo esc_html( $secondary_color );?>;
}


<?php
/*------------------------------------
#. Gradient
------------------------------------*/
?>



.sidebar-widget-area .widget_calendar caption,
.sidebar-widget-area .widget_calendar table td#today {
	background: <?php echo esc_html( $primary_color );?>;
}

.footer-top-area .mc4wp-form .form-group .item-btn {
	background: <?php echo esc_html( $primary_color );?>;
}

<?php
/*-------------------------------------
#. Single Content
---------------------------------------*/
?>
.entry-footer ul.item-tags li a:hover,
.entry-header .entry-meta ul li a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}


.about-author ul.author-box-social li a:hover {
	color: <?php echo esc_html( $primary_color );?>;
}


.post-navigation .next-article i,
.post-navigation .prev-article i {
	color: <?php echo esc_html( $primary_color );?>;
}
.entry-header .entry-meta ul li i,
.entry-header .entry-post-meta ul li a {
	color: <?php echo esc_html( $primary_color );?>;
}
.single-post .entry-content ol li:before,
.entry-content ol li:before {
	background-color: <?php echo esc_html( $primary_color );?>;
}
.rt-related-post .title-section h2:after {
	background-color: <?php echo esc_html( $primary_color );?>;
}

.blog .entry-content .entry-title a:hover,
.content-search .entry-content .entry-title a:hover{
	color: <?php echo esc_html( $primary_color );?>;
}
.blog .blog-layout-1 .blog-box .entry-content h3 a:hover{
	color: <?php echo esc_html( $primary_color );?>;
}
<?php
/*-------------------------------------
#. Archive Contents
---------------------------------------*/
?>


.sidebar-widget-area .widget_block.widget_search .wp-block-search__button{
	background-color: <?php echo esc_html( $primary_color );?>;
}

<?php
/*-------------------------------------
#. Pagination
---------------------------------------*/
?>

.sidebar-widget-area .widget ul li a:hover:before{
	color: <?php echo esc_html( $primary_color );?>;
}
.pagination-area ul li.active a,
.pagination-area ul li a:hover
{
	background-color: <?php echo esc_html( $primary_color );?>;
	border-color:<?php echo esc_html( $primary_color );?>;
	
}
.pagination-area ul li.active a{
	border-color:<?php echo esc_html( $primary_color );?>;
}

.widget_block .wp-block-latest-comments .wp-block-latest-comments__comment:hover:before{
	color:<?php echo esc_html( $primary_color ); ?>;
}
<?php
/*-------------------------------------
#. WooCommerce
---------------------------------------*/
?>

.rt-woo-nav .owl-custom-nav .owl-prev:hover,
.rt-woo-nav .owl-custom-nav .owl-next:hover {
	background-color: <?php echo esc_html( $secondary_color );?>;
}



<?php
/*----------------------
#. Miscellaneous
----------------------*/
?>
.rt-drop,
.post-detail-style3 .breadcrumbs-area2 .breadcrumbs-content ul li,
.post-detail-style3 .breadcrumbs-area2 .breadcrumbs-content ul li a, 
.post-detail-style3 .breadcrumbs-area2 .breadcrumbs-content ul li a:hover,
.breadcrumbs-area2 .breadcrumbs-content h3 a:hover,
.post-detail-style3 .post-3-no-img-meta ul.post-info-light li a:hover,
.post-detail-style3 .entry-meta li a:hover,
.rt-news-box .post-cat span a:hover,
.rt-news-box .topic-box .post-date1 span a:hover,
.rt_widget_recent_entries_with_image .topic-box .post-date1 span a:hover,
.sidebar-widget-area .widget.title-style-1 h3.widgettitle,
.search-form input.search-submit,
ul.news-info-list li i,
.search-form input.search-submit:hover,
.rt-cat-list-widget li:hover a,
.footer-top-area .search-form input.search-submit,
.ui-cat-tag a:hover,
.entry-post-meta .post-author a:hover,
.post-detail-style2 .post-info-light ul li a:hover,
.post-detail-style2 .entry-meta li a:hover,
.entry-title a:hover,
.blog-layout-1 .entry-meta ul li a:hover,
.blog-box .blog-bottom-content-holder ul li i,
.blog .entry-content ul li i,
.blog-layout-2 .blog-list .entry-content .blog-date i,
.content-search .entry-content ul li i,
.footer-top-area .rt-news-box .dark .rt-news-box-widget .media-body a:hover,
.entry-footer .share-social ul a:hover,
.archive .entry-content ul li i,
.archive .entry-content .entry-title a:hover{
	color: <?php echo esc_html( $primary_color );?>;
}
.blog-box .entry-content .blog-date:after{
	background-color:<?php echo esc_html( $primary_color );?>;
}
.search-form button,
#respond form .btn-send:hover{
	color:<?php echo esc_html( $primary_color );?>;
}
 
.rt-box-title-2,.blog-box .blog-img-holder .entry-content,
button, input[type="button"], input[type="reset"], input[type="submit"],
.sidebar-widget-area .widget.title-style-1 h3.widgettitle, 
.rt-cat-list-widget li:before, 
.elementor-widget-wp-widget-categories ul li:before, 
.cat-holder-text, 
.blog-layout-2 .entry-meta .blog-cat ul li a:hover,
.blog-layout-3 .entry-meta ul li.blog-cat li a:hover,
#respond form .btn-send  {
    background-color: <?php echo esc_html( $primary_color );?>;
}

.elementor-widget-wp-widget-categories ul li a:before {
    color: <?php echo esc_html( $primary_color );?>;
}
.elementor-widget-wp-widget-categories ul li:hover a {
	color: <?php echo esc_html($secondary_color); ?>;
}
.post-detail-style2 .cat-holder:before {
    border-top: 8px solid <?php echo esc_html( $primary_color );?>;
}
.footer-top-area .widget_tag_cloud a:hover {
	background-color: <?php echo esc_html( $primary_color );?> !important;
}
.entry-content .wpb_layerslider_element a.layerslider-button, 
.comments-area h3.comment-num:after {	
	background: <?php echo esc_html( $primary_color );?>; 
}
.entry-content .btn-read-more-h-b, .pagination-area ul li span 
.header-style-10.trheader #tophead .tophead-social li a:hover {
    border: 1px solid <?php echo esc_html( $primary_color );?>;
}

.bottomBorder {
    border-bottom: 2px solid <?php echo esc_html( $primary_color ); ?>;
}
.search-form input.search-field {
	border-color: <?php echo esc_html( $primary_color ); ?>;
}


.search-form input.search-submit  {
	background-color: <?php echo esc_html( $primary_color ); ?>;
	border: 2px solid <?php echo esc_html( $primary_color ); ?>;
}
.sidebar-widget-area .widget.title-style-1 h3.widgettitle span {
	border-top: 10px solid <?php echo esc_html( $primary_color ); ?>;
}

 .sidebar-widget-area .widget_tag_cloud a:hover,
.sidebar-widget-area .widget_product_tag_cloud a:hover {
	background-color: <?php  echo esc_html( $primary_color ); ?>;
}

.cat-holder:before {
    border-top: 8px solid <?php echo esc_html( $primary_color ); ?>;
}
.footer-bottom-social ul li a {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.footer-bottom-social ul li a:hover {
    background-color: <?php echo esc_html( $secondary_color ); ?>;
}

.page-links span.current .page-number,
.page-links a.post-page-numbers:hover .page-number {
	background-color: <?php echo esc_html( $primary_color ); ?>;
}


<?php
/*----------------------
#. Service Archive & Service Single
----------------------*/
?>

.service-grid-layout2 .service-item .service-content .service-button1 a:after,
.service-grid-layout2 .service-item:after,
.rt-related-service .service-item .service-content,
.rt-related-service .rtin-item .rtin-content,
.service-grid-layout3 .service-item:hover .service-content:after{
	background-color: <?php echo esc_html( $primary_color ); ?>;
}
.elementor-3673 .elementor-element.elementor-element-6559048 .elementor-icon-list-icon i,
.elementor-3673 .elementor-element.elementor-element-26af55c .elementor-icon-list-icon i,
.service-grid-layout3 .service-item .service-title a:hover {
	color:<?php echo esc_html( $primary_color ); ?>;
}  

#sb_instagram #sbi_images .sbi_item .sbi_photo_wrap::before{
	background-color: rgba(<?php echo esc_html( $primary_rgb );?>, 0.79);
}
<?php
/*----------------------
#. Project Archive & Service Single
----------------------*/
?>

.portfolio-single .single-portfolio-img-wrap:before,
.rt-woo-nav .owl-custom-nav .owl-prev, .rt-woo-nav .owl-custom-nav .owl-next{ 
	background:<?php echo esc_html( $primary_color ); ?>;
}

<?php
/*----------------------
#. Gallery Archive & Service Single
----------------------*/
?>

.gallery-single .rt-swiper-slider .rt-swiper-container .swiper-button > div{
	background:<?php echo esc_html( $primary_color ); ?>;
}
.gallery-multi-layout-1 .rtin-item .rtin-figure .rtin-content .item-button .gallery-btn{
	color:<?php echo esc_html( $primary_color ); ?>;
}
.gallery-default .rtin-item  .rtin-content .rtin-cat a,
.gallery-multi-layout-2 .rtin-item h3 a:hover{
	color:<?php echo esc_html( $secondary_color ); ?>;
}
.gallery-multi-layout-2 .rtin-item .item-icon a:hover,
.gallery-single .rt-swiper-slider .rt-swiper-container .swiper-button > div:hover{
	background-color:<?php echo esc_html( $secondary_color ); ?>;
}
<?php
/*----------------------
#. Team Archive & Service Single
----------------------*/
?>

.fluentform .team-form-input .team-fluent-date .ff-el-input--content:before,
 .rtin-item .rtin-content h3 a:hover
{
	color:<?php echo esc_html( $primary_color ); ?>;
} 

.team-single .rtin-item-wrap .rtin-item .rtin-social ul.rtin-social-icon li a:hover,
.team-multi-layout-1 .rtin-item .team-thumb .rtin-social-icon,
.team-multi-layout-1 .rtin-item:hover::before,
.team-multi-layout-2 .rtin-item:hover .rtin-content-wrap .rtin-content .btn-style4::after,
.team-multi-layout-2 .rtin-item .rtin-content-wrap .rtin-content .rtin-designation:after,
.team-single .rtin-item-wrap .rtin-content .rtin-designation::after,
.team-single .rtin-item-wrap .rtin-content ul li::before
{
	background:<?php echo esc_html( $primary_color ); ?>;
	
}
.team-multi-layout-2 .rtin-item .rtin-content-wrap .rtin-content .rtin-designation:before{
	background:<?php echo esc_html( $secondary_color ); ?>;
}
.team-multi-layout-1 .rtin-item:hover::after
{
	border-color:<?php echo esc_html( $primary_color ); ?>;
}
.team-single .rtin-item .rtin-thums:after{
	border-bottom: 55px solid <?php echo esc_html( $primary_color ); ?>;
}
.team-related-post .rtin-item .rtin-social li ul li a{
	background:<?php echo esc_html( $primary_color ); ?>;
}
.team-related-post .rtin-item .rtin-social li ul li a:hover{
	background:#fff;
	color:<?php echo esc_html( $primary_color ); ?>;
}
.team-single .rtin-item-wrap .rtin-item .rtin-social ul.rtin-social-icon li a{
	color:<?php echo esc_html( $primary_color ); ?>;
}
.team-single .rtin-item-wrap .rtin-content .rtin-designation::before
{
	background-color:<?php echo esc_html( $secondary_color ); ?>;
}
<?php
/*-------------------------------------
#. fluent form
---------------------------------------*/
?>
.widget_fluentform_widget .service-form-btn .ff-btn-submit,
.fluentform .team-form-btn button.ff-btn{
	background:<?php echo esc_html( $primary_color ); ?>;
}

.widget_fluentform_widget .service-form-btn .ff-btn-submit:hover,
.fluentform .team-form-btn button.ff-btn:hover{
	background:<?php echo esc_html( $secondary_color ); ?>;
}

<?php
/*-------------------------------------
#. Button
---------------------------------------*/
?>
.btn-style2:after
{
	background-color:<?php echo esc_html($primary_color); ?>;
}
.btn-style1:hover
{
	background-color:<?php echo esc_html($primary_color); ?>;
	border-color:<?php echo esc_html($primary_color); ?>;
}
.btn-style1 svg path{
	fill:<?php echo esc_html($primary_color); ?>;
}
.header-style-6 .header-icon-area .search-icon a:hover i{
	color:<?php echo esc_html($primary_color); ?>;
}
.header-search .stylish-input-group input[type=search], 
.header-search .header-search-form input[type=search],
 .header-search .custom-search-input input[type=text]{
	 border-color:<?php echo esc_html($primary_color); ?>;
 }

 @-webkit-keyframes pulse2 {
	0% {
	  -webkit-box-shadow: 0 0 0 0 <?php echo esc_html($primary_color); ?>;;
			  box-shadow: 0 0 0 0 <?php echo esc_html($primary_color); ?>;;
	}
	70% {
	  -webkit-box-shadow: 0 0 0 20px rgba(94, 223, 255, 0);
			  box-shadow: 0 0 0 20px rgba(94, 223, 255, 0);
	}
	100% {
	  -webkit-box-shadow: 0 0 0 0 rgba(94, 223, 255, 0);
			  box-shadow: 0 0 0 0 rgba(94, 223, 255, 0);
	}
  }
  @keyframes pulse2 {
	0% {
	  -webkit-box-shadow: 0 0 0 0 <?php echo esc_html($primary_color); ?>;;
			  box-shadow: 0 0 0 0 <?php echo esc_html($primary_color); ?>;;
	}
	70% {
	  -webkit-box-shadow: 0 0 0 20px rgba(94, 223, 255, 0);
			  box-shadow: 0 0 0 20px rgba(94, 223, 255, 0);
	}
	100% {
	  -webkit-box-shadow: 0 0 0 0 rgba(94, 223, 255, 0);
			  box-shadow: 0 0 0 0 rgba(94, 223, 255, 0);
	}
  }