<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = FinbuzzTheme_Helper::nav_menu_args();

// Logo

if( !empty( FinbuzzTheme::$options['logo'] ) ) {
	$logo_dark = wp_get_attachment_image( FinbuzzTheme::$options['logo'], 'full' );
	$finbuzz_dark_logo = $logo_dark;
}else {
	$finbuzz_dark_logo = "<img width='192' height='47' src='" . FINBUZZ_IMG_URL . 'logo-dark.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "' loading='lazy'>"; 
}

if( !empty( FinbuzzTheme::$options['logo_light'] ) ) {
	$logo_lights = wp_get_attachment_image( FinbuzzTheme::$options['logo_light'], 'full' );
	$finbuzz_light_logo = $logo_lights;
}else {
	$finbuzz_light_logo = "<img width='192' height='47' src='" . FINBUZZ_IMG_URL . 'logo-light.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "'>";
}

?>

<div id="rt-sticky-placeholder"></div>
<div class="header-menu menu-layout2" id="header-menu">
    <div class="container">
        <div class="menu-full-wrap">
            <div class="d-flex align-items-center justify-content-between">
                <div class="site-branding">
                    <a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_dark_logo, 'allow_link' ); ?></a>
                    <a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_light_logo, 'allow_link' ); ?></a>
                </div>
                <div class="header-layout1-right">
                    <div class="menu-wrap">
                        <div id="site-navigation" class="main-navigation">
                            <?php wp_nav_menu( $nav_menu_args );?>
                        </div>
                    </div>	
                    <?php if ( FinbuzzTheme::$options['search_icon'] || FinbuzzTheme::$options['vertical_menu_icon'] ) { ?>
                    <div class="info-wrap">
                        <div class="header-icon-area">
                            <?php	
                            if ( FinbuzzTheme::$options['search_icon'] ) { ?>
                                <div class="search-icon">
                                    <a href="#header-search" title="<?php echo esc_attr('Search','finbuzz'); ?>">
                                        <i class="flaticon-magnifiying-glass"></i>
                                    </a>
                                </div>
                            <?php }
                            if ( FinbuzzTheme::$options['vertical_menu_icon']){
                                get_template_part( 'template-parts/header/icon-menu', '2' );
                            }
                            ?>
                        </div>							
                    </div>
                    <?php } ?>	
                </div>
            </div>		
        </div>
    </div>
</div>
